/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.limewire.bittorrent.Torrent;
import org.limewire.core.api.callback.GuiCallback;
import org.limewire.core.api.callback.GuiCallbackService;
import org.limewire.core.api.download.DownloadAction;
import org.limewire.core.api.download.DownloadException;
import org.limewire.core.impl.download.DownloadListener;
import org.limewire.core.impl.download.DownloadListenerList;
import org.limewire.core.impl.magnet.MagnetLinkImpl;
import org.limewire.core.impl.monitor.IncomingSearchListener;
import org.limewire.core.impl.monitor.IncomingSearchListenerList;
import org.limewire.core.impl.search.QueryReplyListener;
import org.limewire.core.impl.search.QueryReplyListenerList;
import org.limewire.core.impl.upload.UploadListener;
import org.limewire.core.impl.upload.UploadListenerList;
import org.limewire.i18n.I18nMarker;
import org.limewire.io.GUID;
import org.limewire.io.IpPort;
import org.limewire.service.ErrorService;
import org.limewire.service.MessageService;

@Singleton
class GlueActivityCallback
implements ActivityCallback,
QueryReplyListenerList,
DownloadListenerList,
UploadListenerList,
IncomingSearchListenerList,
GuiCallbackService {
    private final SortedMap<byte[], List<QueryReplyListener>> queryReplyListeners;
    private final List<DownloadListener> downloadListeners = new CopyOnWriteArrayList<DownloadListener>();
    private final List<UploadListener> uploadListeners = new CopyOnWriteArrayList<UploadListener>();
    private final List<IncomingSearchListener> monitorListeners = new CopyOnWriteArrayList<IncomingSearchListener>();
    private final DownloadManager downloadManager;
    private GuiCallback guiCallback = null;

    @Inject
    public GlueActivityCallback(DownloadManager downloadManager) {
        this.downloadManager = downloadManager;
        this.queryReplyListeners = new ConcurrentSkipListMap<byte[], List<QueryReplyListener>>(GUID.GUID_BYTE_COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addQueryReplyListener(byte[] guid, QueryReplyListener listener) {
        SortedMap<byte[], List<QueryReplyListener>> sortedMap = this.queryReplyListeners;
        synchronized (sortedMap) {
            CopyOnWriteArrayList<QueryReplyListener> listeners = (CopyOnWriteArrayList<QueryReplyListener>)this.queryReplyListeners.get(guid);
            if (listeners == null) {
                listeners = new CopyOnWriteArrayList<QueryReplyListener>();
                this.queryReplyListeners.put(guid, listeners);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeQueryReplyListener(byte[] guid, QueryReplyListener listener) {
        SortedMap<byte[], List<QueryReplyListener>> sortedMap = this.queryReplyListeners;
        synchronized (sortedMap) {
            List listeners = (List)this.queryReplyListeners.get(guid);
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.queryReplyListeners.remove(guid);
                }
            }
        }
    }

    @Override
    public void addDownloadListener(DownloadListener listener) {
        this.downloadListeners.add(listener);
    }

    @Override
    public void removeDownloadListener(DownloadListener listener) {
        this.downloadListeners.remove(listener);
    }

    @Override
    public void handleMagnets(MagnetOptions[] magnets) {
        if (this.guiCallback != null) {
            for (MagnetOptions magnetOption : magnets) {
                this.guiCallback.handleMagnet(new MagnetLinkImpl(magnetOption));
            }
        }
    }

    @Override
    public void handleQueryResult(RemoteFileDesc rfd, QueryReply queryReply, Set<? extends IpPort> locs) {
        List listeners = (List)this.queryReplyListeners.get(queryReply.getGUID());
        if (listeners != null) {
            for (QueryReplyListener listener : listeners) {
                listener.handleQueryReply(rfd, queryReply, locs);
            }
        }
    }

    @Override
    public void handleQuery(QueryRequest query, String address, int port) {
        for (IncomingSearchListener listener : this.monitorListeners) {
            listener.handleQueryString(query.getQuery());
        }
    }

    @Override
    public void handleSharedFileUpdate(File file) {
    }

    @Override
    public void handleTorrent(final File torrentFile) {
        if (torrentFile != null && torrentFile.exists() && torrentFile.length() > 0L) {
            try {
                this.downloadManager.downloadTorrent(torrentFile, null, false);
            }
            catch (DownloadException e) {
                this.handleDownloadException(new DownloadAction(){

                    @Override
                    public void download(File saveDirectory, boolean overwrite) throws DownloadException {
                        GlueActivityCallback.this.downloadManager.downloadTorrent(torrentFile, saveDirectory, overwrite);
                    }

                    @Override
                    public void downloadCanceled(DownloadException ignored) {
                    }
                }, e, false);
            }
        }
    }

    @Override
    public void installationCorrupted() {
        MessageService.showError(I18nMarker.marktr("<html><b>Your LimeWire may have been corrupted by a virus or trojan!</b><br><br>Please visit <a href=\"http://www.limewire.com/corrupted\">www.limewire.com</a> and download the newest official version of LimeWire.</html>"));
    }

    @Override
    public boolean isQueryAlive(GUID guid) {
        return this.queryReplyListeners.containsKey(guid.bytes());
    }

    @Override
    public void addUpload(Uploader u) {
        for (UploadListener listener : this.uploadListeners) {
            listener.uploadAdded(u);
        }
    }

    @Override
    public void uploadComplete(Uploader u) {
        for (UploadListener listener : this.uploadListeners) {
            listener.uploadComplete(u);
        }
    }

    @Override
    public void restoreApplication() {
        if (this.guiCallback != null) {
            this.guiCallback.restoreApplication();
        }
    }

    @Override
    public String translate(String s) {
        if (this.guiCallback != null) {
            return this.guiCallback.translate(s);
        }
        return s;
    }

    @Override
    public void uploadsComplete() {
        for (UploadListener listener : this.uploadListeners) {
            listener.uploadsCompleted();
        }
    }

    @Override
    public void addDownload(Downloader d) {
        for (DownloadListener listener : this.downloadListeners) {
            listener.downloadAdded(d);
        }
    }

    @Override
    public void downloadsComplete() {
        for (DownloadListener listener : this.downloadListeners) {
            listener.downloadsCompleted();
        }
    }

    @Override
    public void promptAboutUnscannedPreview(Downloader dloader) {
        if (this.guiCallback == null) {
            dloader.discardUnscannedPreview(true);
        } else {
            String msg = I18nMarker.marktr("Oh noes! Preview anyway?");
            boolean previewAnyway = this.guiCallback.promptUserQuestion(msg);
            dloader.discardUnscannedPreview(!previewAnyway);
        }
    }

    @Override
    public void removeDownload(Downloader d) {
        for (DownloadListener listener : this.downloadListeners) {
            listener.downloadRemoved(d);
        }
    }

    @Override
    public void setGuiCallback(GuiCallback guiCallback) {
        this.guiCallback = guiCallback;
    }

    @Override
    public void handleDownloadException(DownloadAction downLoadAction, DownloadException e, boolean supportsNewSaveDir) {
        if (this.guiCallback != null) {
            this.guiCallback.handleDownloadException(downLoadAction, e, supportsNewSaveDir);
        } else {
            ErrorService.error(e, "Error handling DownloadException. GuiCallBack not yet initialized.");
        }
    }

    @Override
    public void addUploadListener(UploadListener listener) {
        this.uploadListeners.add(listener);
    }

    @Override
    public void removeUploadListener(UploadListener listener) {
        this.uploadListeners.remove(listener);
    }

    @Override
    public void addIncomingSearchListener(IncomingSearchListener listener) {
        this.monitorListeners.add(listener);
    }

    @Override
    public void removeIncomingSearchListener(IncomingSearchListener listener) {
        this.monitorListeners.remove(listener);
    }

    @Override
    public boolean promptTorrentFilePriorities(Torrent torrent) {
        if (this.guiCallback != null && torrent.hasMetaData()) {
            return this.guiCallback.promptTorrentFilePriorities(torrent);
        }
        return true;
    }
}

