/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.util.concurrent.Lock;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractListEventListener<E> {
    private final List<E> cache = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(EventList<E> source) {
        Lock lock = source.getReadWriteLock().readLock();
        lock.lock();
        try {
            this.cache.addAll(source);
            source.addListEventListener(new ListEventListener<E>(){

                @Override
                public void listChanged(ListEvent<E> changes) {
                    while (changes.next()) {
                        int type = changes.getType();
                        int idx = changes.getIndex();
                        EventList source = changes.getSourceList();
                        switch (type) {
                            case 2: {
                                AbstractListEventListener.this.cache.add(idx, changes.getSourceList().get(idx));
                                AbstractListEventListener.this.itemAdded(AbstractListEventListener.this.cache.get(idx), idx, source);
                                break;
                            }
                            case 0: {
                                Object removed = AbstractListEventListener.this.cache.remove(idx);
                                AbstractListEventListener.this.itemRemoved(removed, idx, source);
                                break;
                            }
                            case 1: {
                                Object prior = AbstractListEventListener.this.cache.get(idx);
                                AbstractListEventListener.this.cache.set(idx, changes.getSourceList().get(idx));
                                AbstractListEventListener.this.itemUpdated(AbstractListEventListener.this.cache.get(idx), prior, idx, source);
                            }
                        }
                    }
                }
            });
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract void itemAdded(E var1, int var2, EventList<E> var3);

    protected abstract void itemRemoved(E var1, int var2, EventList<E> var3);

    protected abstract void itemUpdated(E var1, E var2, int var3, EventList<E> var4);
}

