/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.AudioStreamChunk;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.StreamChunk;
import org.jaudiotagger.audio.asf.data.VideoStreamChunk;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

public class StreamChunkReader
implements ChunkReader {
    protected StreamChunkReader() {
    }

    @Override
    public boolean canFail() {
        return true;
    }

    @Override
    public GUID getApplyingId() {
        return GUID.GUID_STREAM;
    }

    @Override
    public Chunk read(GUID guid, InputStream stream, long chunkStart) throws IOException {
        StreamChunk result = null;
        BigInteger chunkLength = Utils.readBig64(stream);
        GUID streamTypeGUID = Utils.readGUID(stream);
        if (GUID.GUID_AUDIOSTREAM.equals(streamTypeGUID) || GUID.GUID_VIDEOSTREAM.equals(streamTypeGUID)) {
            GUID errorConcealment = Utils.readGUID(stream);
            long timeOffset = Utils.readUINT64(stream);
            long typeSpecificDataSize = Utils.readUINT32(stream);
            long streamSpecificDataSize = Utils.readUINT32(stream);
            int mask = Utils.readUINT16(stream);
            int streamNumber = mask & 0x7F;
            boolean contentEncrypted = (mask & 0x8000) == 1;
            stream.skip(4L);
            long streamSpecificBytes = 0L;
            if (GUID.GUID_AUDIOSTREAM.equals(streamTypeGUID)) {
                AudioStreamChunk audioStreamChunk = new AudioStreamChunk(chunkLength);
                result = audioStreamChunk;
                long compressionFormat = Utils.readUINT16(stream);
                long channelCount = Utils.readUINT16(stream);
                long samplingRate = Utils.readUINT32(stream);
                long avgBytesPerSec = Utils.readUINT32(stream);
                long blockAlignment = Utils.readUINT16(stream);
                int bitsPerSample = Utils.readUINT16(stream);
                int codecSpecificDataSize = Utils.readUINT16(stream);
                byte[] codecSpecificData = new byte[codecSpecificDataSize];
                stream.read(codecSpecificData);
                audioStreamChunk.setCompressionFormat(compressionFormat);
                audioStreamChunk.setChannelCount(channelCount);
                audioStreamChunk.setSamplingRate(samplingRate);
                audioStreamChunk.setAverageBytesPerSec(avgBytesPerSec);
                audioStreamChunk.setErrorConcealment(errorConcealment);
                audioStreamChunk.setBlockAlignment(blockAlignment);
                audioStreamChunk.setBitsPerSample(bitsPerSample);
                audioStreamChunk.setCodecData(codecSpecificData);
                streamSpecificBytes = 18 + codecSpecificData.length;
            } else if (GUID.GUID_VIDEOSTREAM.equals(streamTypeGUID)) {
                VideoStreamChunk videoStreamChunk = new VideoStreamChunk(chunkLength);
                result = videoStreamChunk;
                long pictureWidth = Utils.readUINT32(stream);
                long pictureHeight = Utils.readUINT32(stream);
                stream.skip(1L);
                stream.skip(2L);
                stream.skip(16L);
                byte[] fourCC = new byte[4];
                stream.read(fourCC);
                videoStreamChunk.setPictureWidth(pictureWidth);
                videoStreamChunk.setPictureHeight(pictureHeight);
                videoStreamChunk.setCodecId(fourCC);
                streamSpecificBytes = 31L;
            }
            result.setStreamNumber(streamNumber);
            result.setStreamSpecificDataSize(streamSpecificDataSize);
            result.setTypeSpecificDataSize(typeSpecificDataSize);
            result.setTimeOffset(timeOffset);
            result.setContentEncrypted(contentEncrypted);
            result.setPosition(chunkStart);
            stream.skip(chunkLength.longValue() - 24L - streamSpecificBytes - 54L);
        }
        return result;
    }
}

