/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import org.bushe.swing.event.CleanupEvent;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventSubscriber;
import org.bushe.swing.event.EventTopicSubscriber;
import org.bushe.swing.event.Logger;
import org.bushe.swing.event.ProxySubscriber;
import org.bushe.swing.event.SubscriberTimingEvent;
import org.bushe.swing.event.VetoEventListener;
import org.bushe.swing.event.VetoTopicEventListener;
import org.bushe.swing.event.annotation.ReferenceStrength;
import org.bushe.swing.exception.SwingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadSafeEventService
implements EventService {
    public static final Integer CLEANUP_START_THRESHOLD_DEFAULT = 250;
    public static final Integer CLEANUP_STOP_THRESHOLD_DEFAULT = 100;
    public static final Long CLEANUP_PERIOD_MS_DEFAULT = 1200000L;
    protected static final Logger LOG = Logger.getLogger(EventService.class.getName());
    private Map subscribersByEventType = new HashMap();
    private Map subscribersByEventClass = new HashMap();
    private Map subscribersByExactEventClass = new HashMap();
    private Map subscribersByTopic = new HashMap();
    private Map subscribersByTopicPattern = new HashMap();
    private Map vetoListenersByClass = new HashMap();
    private Map vetoListenersByExactClass = new HashMap();
    private Map vetoListenersByTopic = new HashMap();
    private Map vetoListenersByTopicPattern = new HashMap();
    private final Object listenerLock = new Object();
    private final Object cacheLock = new Object();
    private Long timeThresholdForEventTimingEventPublication;
    private Map<Class, List> cacheByEvent = new HashMap<Class, List>();
    private int defaultCacheSizePerClassOrTopic = 0;
    private Map<Class, Integer> cacheSizesForEventClass;
    private Map<Class, Integer> rawCacheSizesForEventClass;
    private boolean rawCacheSizesForEventClassChanged;
    private Map<String, List> cacheByTopic = new HashMap<String, List>();
    private Map<String, Integer> cacheSizesForTopic;
    private Map<String, Integer> rawCacheSizesForTopic;
    private boolean rawCacheSizesForTopicChanged;
    private Map<Pattern, Integer> rawCacheSizesForPattern;
    private boolean rawCacheSizesForPatternChanged;
    private Integer cleanupStartThreshhold;
    private Integer cleanupStopThreshold;
    private Long cleanupPeriodMS;
    private int weakRefPlusProxySubscriberCount;
    private Timer cleanupTimer;
    private TimerTask cleanupTimerTask;

    public ThreadSafeEventService() {
        this(null, false, null, null, null);
    }

    public ThreadSafeEventService(Long l) {
        this(l, false, null, null, null);
    }

    public ThreadSafeEventService(Long l, boolean bl) {
        this(l, bl, null, null, null);
    }

    public ThreadSafeEventService(Integer n, Integer n2, Long l) {
        this(null, false, n, n2, l);
    }

    public ThreadSafeEventService(Long l, boolean bl, Integer n, Integer n2, Long l2) {
        if (l == null && bl) {
            throw new IllegalArgumentException("null, true in constructor is not valid.  If you want to send timing messages for all events and subscribe them internally, pass 0, true");
        }
        this.timeThresholdForEventTimingEventPublication = l;
        if (bl) {
            this.subscribeStrongly(SubscriberTimingEvent.class, new EventSubscriber(){

                public void onEvent(Object object) {
                    ThreadSafeEventService.this.subscribeTiming((SubscriberTimingEvent)object);
                }
            });
        }
        this.cleanupStartThreshhold = n == null ? CLEANUP_START_THRESHOLD_DEFAULT : n;
        this.cleanupStopThreshold = n2 == null ? CLEANUP_STOP_THRESHOLD_DEFAULT : n2;
        this.cleanupPeriodMS = l2 == null ? CLEANUP_PERIOD_MS_DEFAULT : l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getCleanupStartThreshhold() {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.cleanupStartThreshhold;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCleanupStartThreshhold(Integer n) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.cleanupStartThreshhold = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getCleanupStopThreshold() {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.cleanupStopThreshold;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCleanupStopThreshold(Integer n) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.cleanupStopThreshold = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getCleanupPeriodMS() {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.cleanupPeriodMS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCleanupPeriodMS(Long l) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.cleanupPeriodMS = l;
        }
    }

    @Override
    public boolean subscribe(Class clazz, EventSubscriber eventSubscriber) {
        if (clazz == null) {
            throw new IllegalArgumentException("Event class must not be null");
        }
        if (eventSubscriber == null) {
            throw new IllegalArgumentException("Event subscriber must not be null");
        }
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("Subscribing by class, class:" + clazz + ", subscriber:" + eventSubscriber);
        }
        return this.subscribe(clazz, this.subscribersByEventClass, new WeakReference<EventSubscriber>(eventSubscriber));
    }

    @Override
    public boolean subscribe(Type type, EventSubscriber eventSubscriber) {
        return this.subscribe(type, this.subscribersByEventType, new WeakReference<EventSubscriber>(eventSubscriber));
    }

    @Override
    public boolean subscribeExactly(Class clazz, EventSubscriber eventSubscriber) {
        if (clazz == null) {
            throw new IllegalArgumentException("Event class must not be null");
        }
        if (eventSubscriber == null) {
            throw new IllegalArgumentException("Event subscriber must not be null");
        }
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("Subscribing by class, class:" + clazz + ", subscriber:" + eventSubscriber);
        }
        return this.subscribe(clazz, this.subscribersByExactEventClass, new WeakReference<EventSubscriber>(eventSubscriber));
    }

    @Override
    public boolean subscribe(String string, EventTopicSubscriber eventTopicSubscriber) {
        if (string == null) {
            throw new IllegalArgumentException("Topic must not be null");
        }
        if (eventTopicSubscriber == null) {
            throw new IllegalArgumentException("Event topic subscriber must not be null");
        }
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("Subscribing by topic name, name:" + string + ", subscriber:" + eventTopicSubscriber);
        }
        return this.subscribe(string, this.subscribersByTopic, new WeakReference<EventTopicSubscriber>(eventTopicSubscriber));
    }

    @Override
    public boolean subscribe(Pattern pattern, EventTopicSubscriber eventTopicSubscriber) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern must not be null");
        }
        if (eventTopicSubscriber == null) {
            throw new IllegalArgumentException("Event subscriber must not be null");
        }
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("Subscribing by pattern, pattern:" + pattern + ", subscriber:" + eventTopicSubscriber);
        }
        return this.subscribe(pattern, this.subscribersByTopicPattern, new WeakReference<EventTopicSubscriber>(eventTopicSubscriber));
    }

    @Override
    public boolean subscribeStrongly(Class clazz, EventSubscriber eventSubscriber) {
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("Subscribing weakly by class, class:" + clazz + ", subscriber:" + eventSubscriber);
        }
        if (eventSubscriber == null) {
            throw new IllegalArgumentException("Subscriber cannot be null.");
        }
        return this.subscribe(clazz, this.subscribersByEventClass, eventSubscriber);
    }

    @Override
    public boolean subscribeExactlyStrongly(Class clazz, EventSubscriber eventSubscriber) {
        if (clazz == null) {
            throw new IllegalArgumentException("Event class must not be null");
        }
        if (eventSubscriber == null) {
            throw new IllegalArgumentException("Event subscriber must not be null");
        }
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("Subscribing by class, class:" + clazz + ", subscriber:" + eventSubscriber);
        }
        return this.subscribe(clazz, this.subscribersByExactEventClass, eventSubscriber);
    }

    @Override
    public boolean subscribeStrongly(String string, EventTopicSubscriber eventTopicSubscriber) {
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("Subscribing weakly by topic name, name:" + string + ", subscriber:" + eventTopicSubscriber);
        }
        if (eventTopicSubscriber == null) {
            throw new IllegalArgumentException("Subscriber cannot be null.");
        }
        return this.subscribe(string, this.subscribersByTopic, eventTopicSubscriber);
    }

    @Override
    public boolean subscribeStrongly(Pattern pattern, EventTopicSubscriber eventTopicSubscriber) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern must not be null");
        }
        if (eventTopicSubscriber == null) {
            throw new IllegalArgumentException("Event subscriber must not be null");
        }
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("Subscribing by pattern, pattern:" + pattern + ", subscriber:" + eventTopicSubscriber);
        }
        return this.subscribe(pattern, this.subscribersByTopicPattern, eventTopicSubscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllSubscribers() {
        Object object = this.listenerLock;
        synchronized (object) {
            this.unsubscribeAllInMap(this.subscribersByEventType);
            this.unsubscribeAllInMap(this.subscribersByEventClass);
            this.unsubscribeAllInMap(this.subscribersByExactEventClass);
            this.unsubscribeAllInMap(this.subscribersByTopic);
            this.unsubscribeAllInMap(this.subscribersByTopicPattern);
            this.unsubscribeAllInMap(this.vetoListenersByClass);
            this.unsubscribeAllInMap(this.vetoListenersByExactClass);
            this.unsubscribeAllInMap(this.vetoListenersByTopic);
            this.unsubscribeAllInMap(this.vetoListenersByTopicPattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribeAllInMap(Map map) {
        Object object = this.listenerLock;
        synchronized (object) {
            Set set = map.keySet();
            for (Object k : set) {
                List list = (List)map.get(k);
                while (!list.isEmpty()) {
                    this.unsubscribe(k, map, list.get(0));
                }
            }
        }
    }

    @Override
    public boolean subscribeVetoListener(Class clazz, VetoEventListener vetoEventListener) {
        if (vetoEventListener == null) {
            throw new IllegalArgumentException("VetoListener cannot be null.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("eventClass cannot be null.");
        }
        return this.subscribeVetoListener(clazz, this.vetoListenersByClass, new WeakReference<VetoEventListener>(vetoEventListener));
    }

    @Override
    public boolean subscribeVetoListenerExactly(Class clazz, VetoEventListener vetoEventListener) {
        if (vetoEventListener == null) {
            throw new IllegalArgumentException("VetoListener cannot be null.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("eventClass cannot be null.");
        }
        return this.subscribeVetoListener(clazz, this.vetoListenersByExactClass, new WeakReference<VetoEventListener>(vetoEventListener));
    }

    @Override
    public boolean subscribeVetoListener(String string, VetoTopicEventListener vetoTopicEventListener) {
        if (vetoTopicEventListener == null) {
            throw new IllegalArgumentException("VetoListener cannot be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("topic cannot be null.");
        }
        return this.subscribeVetoListener(string, this.vetoListenersByTopic, new WeakReference<VetoTopicEventListener>(vetoTopicEventListener));
    }

    @Override
    public boolean subscribeVetoListener(Pattern pattern, VetoTopicEventListener vetoTopicEventListener) {
        if (vetoTopicEventListener == null) {
            throw new IllegalArgumentException("VetoListener cannot be null.");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("topicPattern cannot be null.");
        }
        return this.subscribeVetoListener(pattern, this.vetoListenersByTopicPattern, new WeakReference<VetoTopicEventListener>(vetoTopicEventListener));
    }

    @Override
    public boolean subscribeVetoListenerStrongly(Class clazz, VetoEventListener vetoEventListener) {
        if (vetoEventListener == null) {
            throw new IllegalArgumentException("VetoListener cannot be null.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("eventClass cannot be null.");
        }
        return this.subscribeVetoListener(clazz, this.vetoListenersByClass, vetoEventListener);
    }

    @Override
    public boolean subscribeVetoListenerExactlyStrongly(Class clazz, VetoEventListener vetoEventListener) {
        if (vetoEventListener == null) {
            throw new IllegalArgumentException("VetoListener cannot be null.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("eventClass cannot be null.");
        }
        return this.subscribeVetoListener(clazz, this.vetoListenersByExactClass, vetoEventListener);
    }

    @Override
    public boolean subscribeVetoListenerStrongly(String string, VetoTopicEventListener vetoTopicEventListener) {
        if (vetoTopicEventListener == null) {
            throw new IllegalArgumentException("VetoListener cannot be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("topic cannot be null.");
        }
        return this.subscribeVetoListener(string, this.vetoListenersByTopic, vetoTopicEventListener);
    }

    @Override
    public boolean subscribeVetoListenerStrongly(Pattern pattern, VetoTopicEventListener vetoTopicEventListener) {
        if (vetoTopicEventListener == null) {
            throw new IllegalArgumentException("VetoListener cannot be null.");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("topicPattern cannot be null.");
        }
        return this.subscribeVetoListener(pattern, this.vetoListenersByTopicPattern, vetoTopicEventListener);
    }

    protected boolean subscribeVetoListener(Object object, Map map, Object object2) {
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("subscribeVetoListener(" + object + "," + object2 + ")");
        }
        if (object2 == null) {
            throw new IllegalArgumentException("Can't subscribe null veto listener to " + object);
        }
        if (object == null) {
            throw new IllegalArgumentException("Can't subscribe veto listener to null.");
        }
        return this.subscribe(object, map, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean subscribe(Object object, Map<Object, Object> map, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException("Can't subscribe to null.");
        }
        if (object2 == null) {
            throw new IllegalArgumentException("Can't subscribe null subscriber to " + object);
        }
        boolean bl = false;
        boolean bl2 = object2 instanceof WeakReference;
        boolean bl3 = object2 instanceof ProxySubscriber && ((ProxySubscriber)object2).getReferenceStrength() == ReferenceStrength.WEAK;
        Object object3 = this.listenerLock;
        synchronized (object3) {
            ArrayList<Object> arrayList = (ArrayList<Object>)map.get(object);
            if (arrayList == null) {
                if (LOG.isLoggable(Logger.Level.DEBUG)) {
                    LOG.debug("Creating new subscriber map for :" + object);
                }
                arrayList = new ArrayList<Object>();
                map.put(object, arrayList);
            } else {
                Object object4 = object2;
                if (bl2) {
                    object4 = ((WeakReference)object2).get();
                    if (bl3) {
                        throw new IllegalArgumentException("ProxySubscribers should always be subscribed strongly.");
                    }
                }
                if (bl3) {
                    object4 = ((ProxySubscriber)object2).getProxiedSubscriber();
                }
                if (object4 == null) {
                    return false;
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Object object5 = this.getRealSubscriberAndCleanStaleSubscriberIfNecessary(iterator, e);
                    if (!object4.equals(object5)) continue;
                    iterator.remove();
                    bl = true;
                }
            }
            arrayList.add(object2);
            if (bl3 || bl2) {
                this.incWeakRefPlusProxySubscriberCount();
            }
            return !bl;
        }
    }

    @Override
    public boolean unsubscribe(Class clazz, EventSubscriber eventSubscriber) {
        return this.unsubscribe(clazz, this.subscribersByEventClass, eventSubscriber);
    }

    @Override
    public boolean unsubscribeExactly(Class clazz, EventSubscriber eventSubscriber) {
        return this.unsubscribe(clazz, this.subscribersByExactEventClass, eventSubscriber);
    }

    @Override
    public boolean unsubscribe(String string, EventTopicSubscriber eventTopicSubscriber) {
        return this.unsubscribe(string, this.subscribersByTopic, eventTopicSubscriber);
    }

    @Override
    public boolean unsubscribe(Pattern pattern, EventTopicSubscriber eventTopicSubscriber) {
        return this.unsubscribe(pattern, this.subscribersByTopicPattern, eventTopicSubscriber);
    }

    @Override
    public boolean unsubscribe(Class clazz, Object object) {
        EventSubscriber eventSubscriber = (EventSubscriber)((Object)this.getProxySubscriber(clazz, object));
        if (eventSubscriber == null) {
            return false;
        }
        return this.unsubscribe(clazz, eventSubscriber);
    }

    @Override
    public boolean unsubscribeExactly(Class clazz, Object object) {
        ProxySubscriber proxySubscriber = this.getProxySubscriber(clazz, object);
        if (proxySubscriber == null) {
            return false;
        }
        return this.unsubscribeExactly(clazz, proxySubscriber);
    }

    @Override
    public boolean unsubscribe(String string, Object object) {
        EventTopicSubscriber eventTopicSubscriber = (EventTopicSubscriber)((Object)this.getProxySubscriber(string, object));
        if (eventTopicSubscriber == null) {
            return false;
        }
        return this.unsubscribe(string, eventTopicSubscriber);
    }

    @Override
    public boolean unsubscribe(Pattern pattern, Object object) {
        EventTopicSubscriber eventTopicSubscriber = (EventTopicSubscriber)((Object)this.getProxySubscriber(pattern, object));
        if (eventTopicSubscriber == null) {
            return false;
        }
        return this.unsubscribe(pattern, eventTopicSubscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unsubscribe(Object object, Map map, Object object2) {
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("unsubscribe(" + object + "," + object2 + ")");
        }
        if (object == null) {
            throw new IllegalArgumentException("Can't unsubscribe to null.");
        }
        if (object2 == null) {
            throw new IllegalArgumentException("Can't unsubscribe null subscriber to " + object);
        }
        Object object3 = this.listenerLock;
        synchronized (object3) {
            return this.removeFromSetResolveWeakReferences(map, object, object2);
        }
    }

    private ProxySubscriber getProxySubscriber(Class clazz, Object object) {
        List list = this.getSubscribers(clazz);
        return this.getProxySubscriber(list, object);
    }

    private ProxySubscriber getProxySubscriber(String string, Object object) {
        List list = this.getSubscribers(string);
        return this.getProxySubscriber(list, object);
    }

    private ProxySubscriber getProxySubscriber(Pattern pattern, Object object) {
        List list = this.getSubscribersToPattern(pattern);
        return this.getProxySubscriber(list, object);
    }

    private ProxySubscriber getProxySubscriber(List list, Object object) {
        for (Object object2 : list) {
            Object object3;
            if (object2 instanceof WeakReference) {
                object3 = (WeakReference)object2;
                object2 = ((Reference)object3).get();
            }
            if (!(object2 instanceof ProxySubscriber) || (object2 = (object3 = (ProxySubscriber)object2).getProxiedSubscriber()) != object) continue;
            return object3;
        }
        return null;
    }

    @Override
    public boolean unsubscribeVetoListener(Class clazz, VetoEventListener vetoEventListener) {
        return this.unsubscribeVetoListener(clazz, this.vetoListenersByClass, vetoEventListener);
    }

    @Override
    public boolean unsubscribeVetoListenerExactly(Class clazz, VetoEventListener vetoEventListener) {
        return this.unsubscribeVetoListener(clazz, this.vetoListenersByExactClass, vetoEventListener);
    }

    @Override
    public boolean unsubscribeVetoListener(String string, VetoTopicEventListener vetoTopicEventListener) {
        return this.unsubscribeVetoListener(string, this.vetoListenersByTopic, vetoTopicEventListener);
    }

    @Override
    public boolean unsubscribeVetoListener(Pattern pattern, VetoTopicEventListener vetoTopicEventListener) {
        return this.unsubscribeVetoListener(pattern, this.vetoListenersByTopicPattern, vetoTopicEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unsubscribeVetoListener(Object object, Map map, Object object2) {
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("unsubscribeVetoListener(" + object + "," + object2 + ")");
        }
        if (object == null) {
            throw new IllegalArgumentException("Can't unsubscribe veto listener to null.");
        }
        if (object2 == null) {
            throw new IllegalArgumentException("Can't unsubscribe null veto listener to " + object);
        }
        Object object3 = this.listenerLock;
        synchronized (object3) {
            return this.removeFromSetResolveWeakReferences(map, object, object2);
        }
    }

    @Override
    public void publish(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot publish null event.");
        }
        this.publish(object, null, null, this.getSubscribers(object.getClass()), this.getVetoSubscribers(object.getClass()), null);
    }

    @Override
    public void publish(Type type, Object object) {
        if (type == null) {
            throw new IllegalArgumentException("genericType must not be null.");
        }
        if (object == null) {
            throw new IllegalArgumentException("Cannot publish null event.");
        }
        this.publish(object, null, null, this.getSubscribers(type), null, null);
    }

    @Override
    public void publish(String string, Object object) {
        this.publish(null, string, object, this.getSubscribers(string), this.getVetoSubscribers(string), null);
    }

    protected void publish(Object object, String string, Object object2, List list, List list2, StackTraceElement[] stackTraceElementArray) {
        Object object3;
        if (object == null && string == null) {
            throw new IllegalArgumentException("Can't publish to null topic/event.");
        }
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            if (object != null) {
                LOG.debug("Publishing event: class=" + object.getClass() + ", event=" + object);
            } else if (string != null) {
                LOG.debug("Publishing event: topic=" + string + ", eventObj=" + object2);
            }
        }
        if (list2 != null && !list2.isEmpty()) {
            for (Object e : list2) {
                object3 = null;
                VetoTopicEventListener vetoTopicEventListener = null;
                if (object == null) {
                    vetoTopicEventListener = (VetoTopicEventListener)e;
                } else {
                    object3 = (VetoEventListener)e;
                }
                long l = System.currentTimeMillis();
                try {
                    boolean bl = false;
                    bl = object == null ? vetoTopicEventListener.shouldVeto(string, object2) : object3.shouldVeto(object);
                    if (!bl) continue;
                    this.handleVeto((VetoEventListener)object3, object, vetoTopicEventListener, string, object2);
                    this.checkTimeLimit(l, object, null, (VetoEventListener)object3);
                    if (LOG.isLoggable(Logger.Level.DEBUG)) {
                        LOG.debug("Publication vetoed. Event:" + object + ", Topic:" + string + ", veto subscriber:" + object3);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    this.checkTimeLimit(l, object, null, (VetoEventListener)object3);
                    this.subscribeVetoException(object, string, object2, throwable, stackTraceElementArray, (VetoEventListener)object3);
                }
            }
        }
        this.addEventToCache(object, string, object2);
        if (list == null || list.isEmpty()) {
            if (LOG.isLoggable(Logger.Level.DEBUG)) {
                LOG.debug("No subscribers for event or topic. Event:" + object + ", Topic:" + string);
            }
            return;
        }
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("Publishing to subscribers :" + list);
        }
        for (int i = 0; i < list.size(); ++i) {
            Object e;
            e = list.get(i);
            if (object != null) {
                object3 = (EventSubscriber)e;
                long l = System.currentTimeMillis();
                try {
                    object3.onEvent(object);
                    this.checkTimeLimit(l, object, (EventSubscriber)object3, null);
                }
                catch (Throwable throwable) {
                    this.checkTimeLimit(l, object, (EventSubscriber)object3, null);
                    this.handleException(object, throwable, stackTraceElementArray, (EventSubscriber)object3);
                }
                continue;
            }
            object3 = (EventTopicSubscriber)e;
            try {
                object3.onEvent(string, object2);
                continue;
            }
            catch (Throwable throwable) {
                this.onEventException(string, object2, throwable, stackTraceElementArray, (EventTopicSubscriber)object3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEventToCache(Object object, String string, Object object2) {
        Object object3 = this.listenerLock;
        synchronized (object3) {
            if (object != null) {
                int n = this.getCacheSizeForEventClass(object.getClass());
                LinkedList<Object> linkedList = this.cacheByEvent.get(object.getClass());
                if (n <= 0) {
                    if (linkedList != null) {
                        this.cacheByEvent.remove(object.getClass());
                    }
                } else {
                    if (linkedList == null) {
                        linkedList = new LinkedList<Object>();
                        this.cacheByEvent.put(object.getClass(), linkedList);
                    }
                    linkedList.add(0, object);
                    while (linkedList.size() > n) {
                        linkedList.remove(linkedList.size() - 1);
                    }
                }
            } else {
                int n = this.getCacheSizeForTopic(string);
                LinkedList<Object> linkedList = this.cacheByTopic.get(string);
                if (n <= 0) {
                    if (linkedList != null) {
                        linkedList.remove(string);
                    }
                } else {
                    if (linkedList == null) {
                        linkedList = new LinkedList<Object>();
                        this.cacheByTopic.put(string, linkedList);
                    }
                    linkedList.add(0, object2);
                    while (linkedList.size() > n) {
                        linkedList.remove(linkedList.size() - 1);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSubscribers(Class clazz) {
        Object object = this.listenerLock;
        synchronized (object) {
            List list = this.getSubscribersToClass(clazz);
            List list2 = this.getSubscribersToExactClass(clazz);
            ArrayList arrayList = new ArrayList();
            if (list2 != null) {
                arrayList.addAll(list2);
            }
            if (list != null) {
                arrayList.addAll(list);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSubscribersToClass(Class clazz) {
        Object object = this.listenerLock;
        synchronized (object) {
            Map map = this.subscribersByEventClass;
            return this.getEventOrVetoSubscribersToClass(map, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSubscribersToExactClass(Class clazz) {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.getSubscribers(clazz, this.subscribersByExactEventClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSubscribers(Type type) {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.getEventOrVetoSubscribersToType(this.subscribersByEventType, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSubscribers(String string) {
        Object object = this.listenerLock;
        synchronized (object) {
            List list = this.getSubscribersToTopic(string);
            List list2 = this.getSubscribersByPattern(string);
            ArrayList arrayList = new ArrayList();
            if (list != null) {
                arrayList.addAll(list);
            }
            if (list2 != null) {
                arrayList.addAll(list2);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSubscribersToTopic(String string) {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.getSubscribers(string, this.subscribersByTopic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSubscribersByPattern(String string) {
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList arrayList = new ArrayList();
            Set set = this.subscribersByTopicPattern.keySet();
            for (Pattern pattern : set) {
                if (!pattern.matcher(string).matches()) continue;
                if (LOG.isLoggable(Logger.Level.DEBUG)) {
                    LOG.debug("Pattern " + pattern + " matched topic name " + string);
                }
                Collection collection = (Collection)this.subscribersByTopicPattern.get(pattern);
                arrayList.addAll(this.createCopyOfContentsRemoveWeakRefs(collection));
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getSubscribersToPattern(Pattern pattern) {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.getSubscribers(pattern, this.subscribersByTopicPattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getVetoSubscribers(Class clazz) {
        Object object = this.listenerLock;
        synchronized (object) {
            List list = this.getVetoSubscribersToClass(clazz);
            List list2 = this.getVetoSubscribersToExactClass(clazz);
            ArrayList arrayList = new ArrayList();
            if (list != null) {
                arrayList.addAll(list);
            }
            if (list2 != null) {
                arrayList.addAll(list2);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getVetoSubscribersToClass(Class clazz) {
        Object object = this.listenerLock;
        synchronized (object) {
            Map map = this.vetoListenersByClass;
            return this.getEventOrVetoSubscribersToClass(map, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getVetoSubscribersToExactClass(Class clazz) {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.getSubscribers(clazz, this.vetoListenersByExactClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getVetoSubscribers(String string) {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.getSubscribers(string, this.vetoListenersByTopic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getVetoSubscribers(Pattern pattern) {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.getSubscribers(pattern, this.vetoListenersByTopicPattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getSubscribers(Object object, Map map) {
        Object object2 = this.listenerLock;
        synchronized (object2) {
            List list = (List)map.get(object);
            return this.createCopyOfContentsRemoveWeakRefs(list);
        }
    }

    private List getEventOrVetoSubscribersToClass(Map map, Class clazz) {
        ArrayList arrayList = new ArrayList();
        Set set = map.keySet();
        for (Class clazz2 : set) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            if (LOG.isLoggable(Logger.Level.DEBUG)) {
                LOG.debug("Hierachical match " + clazz2 + " matched event of class " + clazz);
            }
            Collection collection = (Collection)map.get(clazz2);
            arrayList.addAll(this.createCopyOfContentsRemoveWeakRefs(collection));
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List getEventOrVetoSubscribersToType(Map map, Type type) {
        ArrayList arrayList = new ArrayList();
        Set set = map.keySet();
        for (Object k : set) {
            Collection collection;
            Type type2 = (Type)k;
            if (!(type instanceof ParameterizedType) || !(type2 instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            ParameterizedType parameterizedType2 = (ParameterizedType)type;
            if (!parameterizedType2.getRawType().equals(parameterizedType.getRawType())) continue;
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            Type[] typeArray2 = parameterizedType2.getActualTypeArguments();
            if (typeArray == null || typeArray2 == null || typeArray.length != typeArray2.length) continue;
            boolean bl = true;
            for (int i = 0; i < typeArray.length; ++i) {
                Type type3 = typeArray2[i];
                if (type3 instanceof WildcardType) {
                    throw new IllegalArgumentException("Only simple Class parameterized types can be published, not wildcards, etc.  Published attempt made for:" + type3);
                }
                Type type4 = typeArray[i];
                if (type4 instanceof WildcardType) {
                    Class clazz;
                    WildcardType wildcardType = (WildcardType)type4;
                    Type[] typeArray3 = wildcardType.getUpperBounds();
                    Type[] typeArray4 = wildcardType.getLowerBounds();
                    if (typeArray3 != null && typeArray3.length > 0) {
                        if (!(typeArray3[0] instanceof Class)) throw new IllegalArgumentException("Only Class and Interface types are supported as types of wildcard subscriptions.  Type:" + typeArray3[0]);
                        clazz = (Class)typeArray3[0];
                        if (type3 instanceof Class) {
                            if (!clazz.isAssignableFrom((Class)type3)) {
                                bl = false;
                                break;
                            }
                        } else {
                            bl = false;
                            break;
                        }
                    }
                    if (typeArray4 == null || typeArray4.length <= 0) continue;
                    if (!(typeArray4[0] instanceof Class)) throw new IllegalArgumentException("Only Class and Interface types are supported as types of wildcard subscriptions.  Type:" + typeArray3[0]);
                    clazz = (Class)typeArray4[0];
                    if (type3 instanceof Class) {
                        if (((Class)type3).isAssignableFrom(clazz)) continue;
                        bl = false;
                        break;
                    }
                    bl = false;
                    break;
                }
                if (type4.equals(type3)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            if (LOG.isLoggable(Logger.Level.DEBUG)) {
                LOG.debug("Exact parameterized subscriberType match for event subscriberType " + type);
            }
            if ((collection = (Collection)map.get(type2)) == null) continue;
            arrayList.addAll(this.createCopyOfContentsRemoveWeakRefs(collection));
        }
        return arrayList;
    }

    private void checkTimeLimit(long l, Object object, EventSubscriber eventSubscriber, VetoEventListener vetoEventListener) {
        if (this.timeThresholdForEventTimingEventPublication == null) {
            return;
        }
        long l2 = System.currentTimeMillis();
        if (l2 - l > this.timeThresholdForEventTimingEventPublication) {
            this.publish(new SubscriberTimingEvent(this, new Long(l), new Long(l2), this.timeThresholdForEventTimingEventPublication, object, eventSubscriber, vetoEventListener));
        }
    }

    protected void subscribeTiming(SubscriberTimingEvent subscriberTimingEvent) {
        LOG.log(Logger.Level.WARN, subscriberTimingEvent + "");
    }

    protected void handleVeto(VetoEventListener vetoEventListener, Object object, VetoTopicEventListener vetoTopicEventListener, String string, Object object2) {
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            if (object != null) {
                LOG.debug("Vetoing event: class=" + object.getClass() + ", event=" + object + ", vetoer:" + vetoEventListener);
            } else {
                LOG.debug("Vetoing event: topic=" + string + ", eventObj=" + object2 + ", vetoer:" + vetoTopicEventListener);
            }
        }
    }

    private boolean removeFromSetResolveWeakReferences(Map map, Object object, Object object2) {
        List list = (List)map.get(object);
        if (list == null) {
            return false;
        }
        if (list.remove(object2)) {
            if (object2 instanceof WeakReference) {
                this.decWeakRefPlusProxySubscriberCount();
            }
            if (object2 instanceof ProxySubscriber) {
                ((ProxySubscriber)object2).proxyUnsubscribed();
                this.decWeakRefPlusProxySubscriberCount();
            }
            return true;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ProxySubscriber proxySubscriber;
            Object object3;
            Object object4 = iterator.next();
            if (object4 instanceof ProxySubscriber && (object4 = (object3 = (ProxySubscriber)object4).getProxiedSubscriber()) == object2) {
                this.removeProxySubscriber((ProxySubscriber)object3, iterator);
                return true;
            }
            if (!(object4 instanceof WeakReference)) continue;
            object3 = (WeakReference)object4;
            Object t = ((Reference)object3).get();
            if (t == null) {
                iterator.remove();
                this.decWeakRefPlusProxySubscriberCount();
                return true;
            }
            if (t == object2) {
                iterator.remove();
                this.decWeakRefPlusProxySubscriberCount();
                return true;
            }
            if (!(t instanceof ProxySubscriber) || (object4 = (proxySubscriber = (ProxySubscriber)t).getProxiedSubscriber()) != object2) continue;
            this.removeProxySubscriber(proxySubscriber, iterator);
            return true;
        }
        return false;
    }

    private List createCopyOfContentsRemoveWeakRefs(Collection collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<ProxySubscriber> arrayList = new ArrayList<ProxySubscriber>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ProxySubscriber proxySubscriber;
            Object object = iterator.next();
            if (object instanceof ProxySubscriber) {
                proxySubscriber = (ProxySubscriber)object;
                if ((object = proxySubscriber.getProxiedSubscriber()) == null) {
                    this.removeProxySubscriber(proxySubscriber, iterator);
                    continue;
                }
                arrayList.add(proxySubscriber);
                continue;
            }
            if (object instanceof WeakReference) {
                proxySubscriber = ((WeakReference)object).get();
                if (proxySubscriber == null) {
                    iterator.remove();
                    this.decWeakRefPlusProxySubscriberCount();
                    continue;
                }
                arrayList.add(proxySubscriber);
                continue;
            }
            arrayList.add((ProxySubscriber)object);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultCacheSizePerClassOrTopic(int n) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.defaultCacheSizePerClassOrTopic = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDefaultCacheSizePerClassOrTopic() {
        Object object = this.cacheLock;
        synchronized (object) {
            return this.defaultCacheSizePerClassOrTopic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCacheSizeForEventClass(Class clazz, int n) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.rawCacheSizesForEventClass == null) {
                this.rawCacheSizesForEventClass = new HashMap<Class, Integer>();
            }
            this.rawCacheSizesForEventClass.put(clazz, new Integer(n));
            this.rawCacheSizesForEventClassChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCacheSizeForEventClass(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("eventClass must not be null.");
        }
        Object object = this.cacheLock;
        synchronized (object) {
            Object object2;
            Integer n;
            if (this.rawCacheSizesForEventClass == null || this.rawCacheSizesForEventClass.size() == 0) {
                return this.getDefaultCacheSizePerClassOrTopic();
            }
            if (this.cacheSizesForEventClass == null) {
                this.cacheSizesForEventClass = new HashMap<Class, Integer>();
            }
            if (this.rawCacheSizesForEventClassChanged) {
                this.cacheSizesForEventClass.clear();
                this.cacheSizesForEventClass.putAll(this.rawCacheSizesForEventClass);
                this.rawCacheSizesForEventClassChanged = false;
            }
            if ((n = this.cacheSizesForEventClass.get(clazz)) != null) {
                return n;
            }
            for (Class clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                object2 = this.cacheSizesForEventClass.get(clazz2);
                if (object2 == null) continue;
                this.cacheSizesForEventClass.put(clazz, (Integer)object2);
                return (Integer)object2;
            }
            object2 = clazz.getInterfaces();
            for (int i = 0; i < ((Class<?>[])object2).length; ++i) {
                Class<?> clazz3 = object2[i];
                Integer n2 = this.cacheSizesForEventClass.get(clazz3);
                if (n2 == null) continue;
                this.cacheSizesForEventClass.put(clazz, n2);
                return n2;
            }
            return this.getDefaultCacheSizePerClassOrTopic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCacheSizeForTopic(String string, int n) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.rawCacheSizesForTopic == null) {
                this.rawCacheSizesForTopic = new HashMap<String, Integer>();
            }
            this.rawCacheSizesForTopic.put(string, new Integer(n));
            this.rawCacheSizesForTopicChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCacheSizeForTopic(Pattern pattern, int n) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.rawCacheSizesForPattern == null) {
                this.rawCacheSizesForPattern = new HashMap<Pattern, Integer>();
            }
            this.rawCacheSizesForPattern.put(pattern, new Integer(n));
            this.rawCacheSizesForPatternChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCacheSizeForTopic(String string) {
        if (string == null) {
            throw new IllegalArgumentException("topic must not be null.");
        }
        Object object = this.cacheLock;
        synchronized (object) {
            Integer n;
            if ((this.rawCacheSizesForTopic == null || this.rawCacheSizesForTopic != null && this.rawCacheSizesForTopic.size() == 0) && (this.rawCacheSizesForPattern == null || this.rawCacheSizesForPattern != null && this.rawCacheSizesForPattern.size() == 0)) {
                return this.getDefaultCacheSizePerClassOrTopic();
            }
            if (this.cacheSizesForTopic == null) {
                this.cacheSizesForTopic = new HashMap<String, Integer>();
            }
            if (this.rawCacheSizesForTopicChanged || this.rawCacheSizesForPatternChanged) {
                this.cacheSizesForTopic.clear();
                this.cacheSizesForTopic.putAll(this.rawCacheSizesForTopic);
                this.rawCacheSizesForTopicChanged = false;
                this.rawCacheSizesForPatternChanged = false;
            }
            if ((n = this.cacheSizesForTopic.get(string)) != null) {
                return n;
            }
            if (this.rawCacheSizesForPattern != null) {
                Set<Pattern> set = this.rawCacheSizesForPattern.keySet();
                for (Pattern pattern : set) {
                    if (!pattern.matcher(string).matches()) continue;
                    n = this.rawCacheSizesForPattern.get(pattern);
                    this.cacheSizesForTopic.put(string, n);
                    return n;
                }
            }
            return this.getDefaultCacheSizePerClassOrTopic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getLastEvent(Class clazz) {
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("Interfaces are not accepted in get last event, use a specific event class.");
        }
        Object object = this.cacheLock;
        synchronized (object) {
            List list = this.cacheByEvent.get(clazz);
            if (list == null || list.size() == 0) {
                return null;
            }
            return list.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getCachedEvents(Class clazz) {
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("Interfaces are not accepted in get last event, use a specific event class.");
        }
        Object object = this.cacheLock;
        synchronized (object) {
            List list = this.cacheByEvent.get(clazz);
            if (list == null || list.size() == 0) {
                return null;
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getLastTopicData(String string) {
        Object object = this.cacheLock;
        synchronized (object) {
            List list = this.cacheByTopic.get(string);
            if (list == null || list.size() == 0) {
                return null;
            }
            return list.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getCachedTopicData(String string) {
        Object object = this.cacheLock;
        synchronized (object) {
            List list = this.cacheByTopic.get(string);
            if (list == null || list.size() == 0) {
                return null;
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache(Class clazz) {
        Object object = this.cacheLock;
        synchronized (object) {
            Set<Class> set = this.cacheByEvent.keySet();
            Iterator<Class> iterator = set.iterator();
            while (iterator.hasNext()) {
                Class clazz2 = iterator.next();
                if (!clazz.isAssignableFrom(clazz2)) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache(String string) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.cacheByTopic.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache(Pattern pattern) {
        Object object = this.cacheLock;
        synchronized (object) {
            Set<String> set = this.cacheByTopic.keySet();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (!pattern.matcher(string).matches()) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        Object object = this.cacheLock;
        synchronized (object) {
            this.cacheByEvent.clear();
            this.cacheByTopic.clear();
        }
    }

    protected void subscribeVetoException(Object object, String string, Object object2, Throwable throwable, StackTraceElement[] stackTraceElementArray, VetoEventListener vetoEventListener) {
        String string2 = "EventService veto event listener r:" + vetoEventListener;
        if (vetoEventListener != null) {
            string2 = string2 + ".  Vetoer class:" + vetoEventListener.getClass();
        }
        this.handleException("vetoing", object, string, object2, throwable, stackTraceElementArray, string2);
    }

    protected void onEventException(String string, Object object, Throwable throwable, StackTraceElement[] stackTraceElementArray, EventTopicSubscriber eventTopicSubscriber) {
        String string2 = "EventService topic subscriber:" + eventTopicSubscriber;
        if (eventTopicSubscriber != null) {
            string2 = string2 + ".  Subscriber class:" + eventTopicSubscriber.getClass();
        }
        this.handleException("handling event", null, string, object, throwable, stackTraceElementArray, string2);
    }

    protected void handleException(Object object, Throwable throwable, StackTraceElement[] stackTraceElementArray, EventSubscriber eventSubscriber) {
        String string = "EventService subscriber:" + eventSubscriber;
        if (eventSubscriber != null) {
            string = string + ".  Subscriber class:" + eventSubscriber.getClass();
        }
        this.handleException("handling event topic", object, null, null, throwable, stackTraceElementArray, string);
    }

    protected void handleException(String string, Object object, String string2, Object object2, Throwable throwable, StackTraceElement[] stackTraceElementArray, String string3) {
        String string4 = object == null ? "none" : object.getClass().getName();
        String string5 = object + "";
        String string6 = "Exception " + string + " event class=" + string4 + ", event=" + string5 + ", topic=" + string2 + ", eventObj=" + object2;
        SwingException swingException = new SwingException(string6, throwable, stackTraceElementArray);
        String string7 = "Exception thrown by;" + string3;
        LOG.log(Logger.Level.WARN, string7, swingException);
    }

    protected Object getRealSubscriberAndCleanStaleSubscriberIfNecessary(Iterator iterator, Object object) {
        ProxySubscriber proxySubscriber = null;
        if (object instanceof WeakReference && (object = ((WeakReference)object).get()) == null) {
            iterator.remove();
            this.decWeakRefPlusProxySubscriberCount();
        }
        if (object instanceof ProxySubscriber) {
            proxySubscriber = (ProxySubscriber)object;
            object = proxySubscriber.getProxiedSubscriber();
            if (proxySubscriber == null) {
                this.removeProxySubscriber(proxySubscriber, iterator);
            }
        }
        return object;
    }

    protected void removeProxySubscriber(ProxySubscriber proxySubscriber, Iterator iterator) {
        iterator.remove();
        proxySubscriber.proxyUnsubscribed();
        this.decWeakRefPlusProxySubscriberCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incWeakRefPlusProxySubscriberCount() {
        Object object = this.listenerLock;
        synchronized (object) {
            ++this.weakRefPlusProxySubscriberCount;
            if (this.cleanupStartThreshhold == null || this.cleanupPeriodMS == null) {
                return;
            }
            if (this.weakRefPlusProxySubscriberCount >= this.cleanupStartThreshhold) {
                this.startCleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decWeakRefPlusProxySubscriberCount() {
        Object object = this.listenerLock;
        synchronized (object) {
            --this.weakRefPlusProxySubscriberCount;
            if (this.weakRefPlusProxySubscriberCount < 0) {
                this.weakRefPlusProxySubscriberCount = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCleanup() {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.cleanupTimer == null) {
                this.cleanupTimer = new Timer();
            }
            if (this.cleanupTimerTask == null) {
                this.cleanupTimerTask = new CleanupTimerTask();
                this.cleanupTimer.schedule(this.cleanupTimerTask, 0L, (long)this.cleanupPeriodMS);
            }
        }
    }

    class CleanupTimerTask
    extends TimerTask {
        CleanupTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = ThreadSafeEventService.this.listenerLock;
            synchronized (object) {
                ThreadSafeEventService.this.publish(new CleanupEvent(CleanupEvent.Status.STARTING, ThreadSafeEventService.this.weakRefPlusProxySubscriberCount, null));
                if (ThreadSafeEventService.this.weakRefPlusProxySubscriberCount <= ThreadSafeEventService.this.cleanupStopThreshold) {
                    this.cancel();
                    ThreadSafeEventService.this.cleanupTimer = null;
                    ThreadSafeEventService.this.cleanupTimerTask = null;
                    LOG.debug("Cancelled scheduled weak reference and proxy cleanup.");
                    ThreadSafeEventService.this.publish(new CleanupEvent(CleanupEvent.Status.UNDER_STOP_THRESHOLD_CLEANING_CANCELLED, ThreadSafeEventService.this.weakRefPlusProxySubscriberCount, null));
                    return;
                }
                LOG.debug("Starting a weak reference and proxy cleanup.");
                ThreadSafeEventService.this.publish(new CleanupEvent(CleanupEvent.Status.OVER_STOP_THRESHOLD_CLEANING_BEGUN, ThreadSafeEventService.this.weakRefPlusProxySubscriberCount, null));
                ArrayList<Map> arrayList = new ArrayList<Map>();
                arrayList.add(ThreadSafeEventService.this.subscribersByEventType);
                arrayList.add(ThreadSafeEventService.this.subscribersByEventClass);
                arrayList.add(ThreadSafeEventService.this.subscribersByExactEventClass);
                arrayList.add(ThreadSafeEventService.this.subscribersByTopic);
                arrayList.add(ThreadSafeEventService.this.subscribersByTopicPattern);
                arrayList.add(ThreadSafeEventService.this.vetoListenersByClass);
                arrayList.add(ThreadSafeEventService.this.vetoListenersByExactClass);
                arrayList.add(ThreadSafeEventService.this.vetoListenersByTopic);
                arrayList.add(ThreadSafeEventService.this.vetoListenersByTopicPattern);
                int n = 0;
                for (Map map : arrayList) {
                    Set set = map.keySet();
                    for (Object k : set) {
                        List list = (List)map.get(k);
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            Object object2 = ThreadSafeEventService.this.getRealSubscriberAndCleanStaleSubscriberIfNecessary(iterator, e);
                            if (object2 != null) continue;
                            ++n;
                        }
                    }
                }
                ThreadSafeEventService.this.publish(new CleanupEvent(CleanupEvent.Status.FINISHED_CLEANING, ThreadSafeEventService.this.weakRefPlusProxySubscriberCount, n));
            }
        }
    }
}

