/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.XMLStringUtils;
import java.io.Serializable;
import java.util.Map;

public class SerialXml
implements Serializable {
    private static final long serialVersionUID = 7396170507085078485L;
    private Map<String, String> fieldToValue;
    private String schemaUri;
    private int version;

    public String getXml(boolean includeVersion) {
        if (this.fieldToValue != null && this.schemaUri != null && !this.fieldToValue.isEmpty()) {
            StringBuilder tag = new StringBuilder(100);
            tag.append("<?xml version=\"1.0\"?>").append("<");
            String type = LimeXMLSchema.getDisplayString(this.schemaUri);
            String root = type + "s";
            tag.append(root).append(" ").append("xsi:noNamespaceSchemaLocation=\"").append(this.schemaUri).append("\">");
            String canonicalKey = root + "__" + type + "__";
            tag.append("<").append(type);
            for (Map.Entry<String, String> entry : this.fieldToValue.entrySet()) {
                String name = XMLStringUtils.getLastField(canonicalKey, entry.getKey());
                if (name == null) continue;
                tag.append(" ").append(name).append("=\"").append(LimeXMLUtils.encodeXML(entry.getValue())).append("\"");
            }
            if (includeVersion) {
                tag.append(" internal_version=\"").append(this.version).append("\"");
            }
            tag.append("/></").append(root).append(">");
            return tag.toString();
        }
        return null;
    }
}

