/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.uploader.BrowseRequestHandler;
import com.limegroup.gnutella.uploader.BrowseRequestHandlerFactory;
import com.limegroup.gnutella.uploader.FileRequestHandler;
import com.limegroup.gnutella.uploader.FileRequestHandlerFactory;
import com.limegroup.gnutella.uploader.FreeLoaderRequestHandler;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.HttpPushRequestHandler;
import com.limegroup.gnutella.uploader.HttpRequestHandlerFactory;
import com.limegroup.gnutella.uploader.LimitReachedRequestHandler;
import com.limegroup.gnutella.uploader.authentication.HttpRequestFileViewProvider;

@Singleton
public class HttpRequestHandlerFactoryImpl
implements HttpRequestHandlerFactory {
    private final Provider<FileRequestHandlerFactory> fileRequestHandlerProvider;
    private final Provider<FreeLoaderRequestHandler> freeLoaderRequestHandlerProvider;
    private final Provider<HttpPushRequestHandler> pushProxyRequestHandlerProvider;
    private final HTTPHeaderUtils httpHeaderUtils;
    private final AltLocManager altLocManager;
    private final Provider<BrowseRequestHandlerFactory> browseRequestHandlerFactory;

    @Inject
    public HttpRequestHandlerFactoryImpl(Provider<FileRequestHandlerFactory> fileRequestHandlerProvider, Provider<FreeLoaderRequestHandler> freeLoaderRequestHandlerProvider, Provider<HttpPushRequestHandler> pushProxyRequestHandlerProvider, HTTPHeaderUtils httpHeaderUtils, AltLocManager altLocManager, Provider<BrowseRequestHandlerFactory> browseRequestHandlerFactory) {
        this.fileRequestHandlerProvider = fileRequestHandlerProvider;
        this.freeLoaderRequestHandlerProvider = freeLoaderRequestHandlerProvider;
        this.pushProxyRequestHandlerProvider = pushProxyRequestHandlerProvider;
        this.httpHeaderUtils = httpHeaderUtils;
        this.altLocManager = altLocManager;
        this.browseRequestHandlerFactory = browseRequestHandlerFactory;
    }

    @Override
    public FileRequestHandler createFileRequestHandler(HttpRequestFileViewProvider provider, boolean requiresAuthentication) {
        return this.fileRequestHandlerProvider.get().createFileRequestHandler(provider, requiresAuthentication);
    }

    @Override
    public BrowseRequestHandler createBrowseRequestHandler(HttpRequestFileViewProvider browseRequestFileListProvider, boolean requiresAuthentication) {
        return this.browseRequestHandlerFactory.get().createBrowseRequestHandler(browseRequestFileListProvider, requiresAuthentication);
    }

    @Override
    public FreeLoaderRequestHandler createFreeLoaderRequestHandler() {
        return this.freeLoaderRequestHandlerProvider.get();
    }

    @Override
    public LimitReachedRequestHandler createLimitReachedRequestHandler(HTTPUploader uploader) {
        return new LimitReachedRequestHandler(uploader, this.httpHeaderUtils, this.altLocManager);
    }

    @Override
    public HttpPushRequestHandler createPushProxyRequestHandler() {
        return this.pushProxyRequestHandlerProvider.get();
    }
}

