/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.bittorrent;

import com.limegroup.gnutella.metadata.MetaData;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.limewire.bittorrent.BTData;
import org.limewire.util.Base32;
import org.limewire.util.NameValue;
import org.limewire.util.StringUtils;

public class TorrentMetaData
implements MetaData {
    private List<NameValue<String>> nameValues;

    public TorrentMetaData(BTData data) throws IOException {
        this.nameValues = Collections.unmodifiableList(this.buildNameValueList(data));
    }

    @Override
    public String getSchemaURI() {
        return "http://www.limewire.com/schemas/torrent.xsd";
    }

    @Override
    public void populate(LimeXMLDocument doc) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    private List<NameValue<String>> buildNameValueList(BTData data) throws IOException {
        List<BTData.BTFileData> files;
        String uris;
        NameValueListBuilder builder = new NameValueListBuilder();
        builder.add("torrents__torrent__infohash__", Base32.encode(data.getInfoHash()));
        List<URI> trackers = data.getTrackerUris();
        int maxSize = Math.min(trackers.size(), 3);
        String trackerUris = StringUtils.explode(trackers.subList(0, maxSize), " ");
        builder.add("torrents__torrent__trackers__", trackerUris);
        Long length = data.getLength();
        if (length != null) {
            builder.add("torrents__torrent__length__", length);
        }
        builder.add("torrents__torrent__name__", data.getName());
        boolean isPrivate = data.isPrivate();
        if (isPrivate) {
            builder.add("torrents__torrent__private__", Boolean.TRUE.toString());
        }
        if ((uris = StringUtils.explode(data.getWebSeeds(), " ")).length() > 0) {
            builder.add("torrents__torrent__webseeds__", uris);
        }
        if ((files = data.getFiles()) != null) {
            ArrayList<String> filePaths = new ArrayList<String>(files.size());
            ArrayList<Long> fileLengths = new ArrayList<Long>(files.size());
            for (BTData.BTFileData file : files) {
                filePaths.add(file.getPath());
                fileLengths.add(file.getLength());
            }
            builder.add("torrents__torrent__filepaths__", StringUtils.explode(filePaths, "//"));
            builder.add("torrents__torrent__filesizes__", StringUtils.explode(fileLengths, " "));
        }
        return builder.toList();
    }

    @Override
    public List<NameValue<String>> toNameValueList() {
        return this.nameValues;
    }

    public String toString() {
        return StringUtils.toString(this, new Object[0]);
    }

    private static class NameValueListBuilder {
        private List<NameValue<String>> values = new ArrayList<NameValue<String>>();

        private NameValueListBuilder() {
        }

        public void add(String name, String value) {
            this.values.add(new NameValue<String>(name, value));
        }

        public void add(String name, long value) {
            this.values.add(new NameValue<String>(name, Long.toString(value)));
        }

        List<NameValue<String>> toList() {
            return this.values;
        }
    }
}

