/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.ui;

import com.openstego.desktop.util.LabelUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpAboutDialog
extends JDialog {
    private static final long serialVersionUID = 2707372931999569066L;
    private static LabelUtil labelUtil = LabelUtil.getInstance("OpenStego");
    private JEditorPane content;
    private JButton okButton;

    public JEditorPane getContent() {
        if (this.content == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("<html>");
            buf.append("  <table width=100% cellspacing=0 cellpadding=0 style='font:serif;'>");
            buf.append("    <tr style='background-color:white'>");
            buf.append("      <td align=left style='padding-left:8px'>");
            buf.append("        <span style='font-size:24px; font-weight:bold'>");
            buf.append("          ").append(labelUtil.getString("appName")).append("</span>");
            buf.append("        <p style='font-size:10px; margin-top:6px'>");
            buf.append("          ").append(labelUtil.getString("appVersion")).append("</p>");
            buf.append("      </td>");
            buf.append("      <td align=right>");
            buf.append("        <img src='").append(this.getClass().getResource("/images/About.png").toString()).append("'/></td>");
            buf.append("    </tr>");
            buf.append("    <tr>");
            buf.append("      <td colspan=2 style='padding:5px;font-size:10px'>");
            buf.append("        <p>").append(labelUtil.getString("copyright")).append("</p><br/>");
            buf.append("        <p>").append(labelUtil.getString("gui.label.help.sitelink")).append("</p><br/>");
            buf.append("        <p><u>").append(labelUtil.getString("gui.label.help.ackHeader")).append("</u></p>");
            buf.append("        <ol style='margin-left:10px; margin-top:2px;'>");
            buf.append("          <li>").append(labelUtil.getString("gui.label.help.acknowledgement")).append("</li>");
            buf.append("        </ol>");
            buf.append("      </td>");
            buf.append("    </tr>");
            buf.append("  </table>");
            buf.append("</html>");
            this.content = new JEditorPane("text/html", buf.toString());
            this.content.setEditable(false);
            this.content.setBorder(BorderFactory.createEmptyBorder());
            this.content.setBackground(this.getBackground());
            this.content.setPreferredSize(new Dimension(450, 320));
            this.content.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        JEditorPane pane = (JEditorPane)e.getSource();
                        if (e.getURL() == null) {
                            BareBonesBrowserLaunch.openURL(labelUtil.getString("homepage"), pane);
                        } else {
                            BareBonesBrowserLaunch.openURL(e.getURL().toString(), pane);
                        }
                    }
                }
            });
        }
        return this.content;
    }

    public JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HelpAboutDialog.this.setVisible(false);
                }
            });
        }
        return this.okButton;
    }

    public HelpAboutDialog(Frame parent) {
        super(parent, "About OpenStego", true);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints g = new GridBagConstraints();
        g.gridy = 0;
        g.weighty = 1.0;
        g.fill = 1;
        this.getContentPane().add((Component)this.getContent(), g);
        g = new GridBagConstraints();
        g.gridy = 1;
        g.weighty = 0.0;
        g.anchor = 13;
        g.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.getOkButton(), g);
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = -4890560722044735566L;

            @Override
            public void actionPerformed(ActionEvent ev) {
                HelpAboutDialog.this.setVisible(false);
            }
        };
        this.getRootPane().getInputMap(2).put(escapeKeyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.pack();
        this.setResizable(false);
        Dimension parentSize = parent.getSize();
        this.setLocation(parent.getLocation().x + parentSize.width / 2 - this.getWidth() / 2, parent.getLocation().y + parentSize.height / 2 - this.getHeight() / 2);
    }

    static class BareBonesBrowserLaunch {
        private static final String[] browsers = new String[]{"firefox", "google-chrome", "opera", "epiphany", "konqueror", "conkeror", "midori", "kazehakase", "mozilla"};

        BareBonesBrowserLaunch() {
        }

        public static void openURL(String url, JComponent parent) {
            try {
                Class<?> d = Class.forName("java.awt.Desktop");
                d.getDeclaredMethod("browse", URI.class).invoke(d.getDeclaredMethod("getDesktop", new Class[0]).invoke(null, new Object[0]), URI.create(url));
            }
            catch (Exception ignore) {
                String osName = System.getProperty("os.name");
                try {
                    if (osName.startsWith("Mac OS")) {
                        Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", String.class).invoke(null, url);
                    } else if (osName.startsWith("Windows")) {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                    } else {
                        String browser = null;
                        for (String b : browsers) {
                            if (browser != null || Runtime.getRuntime().exec(new String[]{"which", b}).getInputStream().read() == -1) continue;
                            Runtime.getRuntime().exec(new String[]{browser = b, url});
                        }
                        if (browser == null) {
                            throw new Exception(Arrays.toString(browsers));
                        }
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(parent, labelUtil.getString("gui.msg.err.browserLaunch"), labelUtil.getString("gui.msg.title.err"), 0);
                }
            }
        }
    }
}

