/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.seawind.internal.core;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xmind.seawind.internal.core.SPath;
import org.xmind.seawind.internal.core.SSerializable;
import org.xmind.seawind.internal.core.SeawindFile;

public class SeawindFolder
implements SSerializable,
SPath {
    private static final int TITLE_LENGTH = 50;
    private String title;
    private Set<SeawindFile> files;
    private long creationTime;
    private long modificationTime;
    private Set<SeawindFolder> folders;
    private SeawindFolder ownedParent;

    public SeawindFolder(String title) {
        this(new JSONObject().put("title", (Object)SeawindFolder.urlEncode(title)));
    }

    public SeawindFolder(JSONObject json) {
        JSONArray folderJsonArray;
        this.title = json.optString("title", "Root");
        this.creationTime = json.optLong("creationTime");
        this.modificationTime = json.optLong("modificationTime");
        this.files = new HashSet<SeawindFile>();
        this.folders = new HashSet<SeawindFolder>();
        JSONArray filesJsonArray = json.optJSONArray("files");
        if (filesJsonArray != null) {
            for (Object file : filesJsonArray) {
                if (!(file instanceof JSONObject)) continue;
                SeawindFile seawindFile = new SeawindFile((JSONObject)file);
                seawindFile.setOwnedParent(this);
                this.files.add(seawindFile);
            }
        }
        if ((folderJsonArray = json.optJSONArray("folders")) != null) {
            for (Object folder : folderJsonArray) {
                if (!(folder instanceof JSONObject)) continue;
                SeawindFolder seawindFolder = new SeawindFolder((JSONObject)folder);
                seawindFolder.setOwnedParent(this);
                this.folders.add(seawindFolder);
            }
        }
    }

    private static String urlEncode(String identifier) {
        String charsetName = "UTF-8";
        try {
            return URLEncoder.encode(identifier, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError(String.format("Decoding not supported: %s", charsetName), e);
        }
    }

    private static String urlDecode(String identifier) {
        String charsetName = "UTF-8";
        try {
            return URLDecoder.decode(identifier, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError(String.format("Encoding not supported: %s", charsetName), e);
        }
    }

    @Override
    public String getPath() {
        String path = this.ownedParent == null ? "/" + this.title + "/" : String.valueOf(this.ownedParent.getPath()) + this.title + "/";
        return path;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    public Set<SeawindFile> getFiles() {
        return this.files;
    }

    public Set<SeawindFolder> getFolders() {
        return this.folders;
    }

    public String getTitle() {
        return SeawindFolder.urlDecode(this.title);
    }

    public void setTitle(String title) {
        SeawindFolder parent = this.ownedParent;
        if (this.ownedParent != null) {
            this.ownedParent.removeFolder(this);
        }
        if (title.length() > 50) {
            title = title.substring(0, 50);
        }
        this.title = SeawindFolder.urlEncode(title);
        if (parent != null) {
            parent.addFolder(this);
        }
    }

    public void addFile(SeawindFile file) {
        file.setOwnedParent(this);
        this.files.add(file);
    }

    public void addFolder(SeawindFolder folder) {
        this.setModificationTime(System.currentTimeMillis());
        folder.setOwnedParent(this);
        this.folders.add(folder);
    }

    public void removeFile(SeawindFile file) {
        this.files.remove(file);
        file.setOwnedParent(null);
    }

    public void removeFolder(SeawindFolder folder) {
        this.folders.remove(folder);
        folder.setOwnedParent(null);
    }

    public SeawindFolder getOwnedParent() {
        return this.ownedParent;
    }

    public void setOwnedParent(SeawindFolder ownedParent) {
        this.ownedParent = ownedParent;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    public boolean isEmpty() {
        return this.getFolders().size() == 0 && this.getFiles().size() == 0;
    }

    @Override
    public boolean isSameWith(SPath spath) {
        boolean same = false;
        if (spath instanceof SeawindFolder) {
            Set<SeawindFile> thatFiles = ((SeawindFolder)spath).getFiles();
            Set<SeawindFolder> thatFolders = ((SeawindFolder)spath).getFolders();
            same = thatFiles.size() == this.files.size() && thatFolders.size() == this.folders.size();
            HashSet<SSerializable> thatChildren = new HashSet<SSerializable>();
            thatChildren.addAll(thatFiles);
            thatChildren.addAll(thatFolders);
            thatChildren.removeAll(this.files);
            thatChildren.removeAll(this.folders);
            same = same && thatChildren.isEmpty();
            HashMap<SeawindFolder, SeawindFolder> thatFolderMap = new HashMap<SeawindFolder, SeawindFolder>();
            SeawindFolder.collectFoldersMap((SeawindFolder)spath, thatFolderMap);
            HashMap<SeawindFolder, SeawindFolder> thisFolderMap = new HashMap<SeawindFolder, SeawindFolder>();
            SeawindFolder.collectFoldersMap((SeawindFolder)spath, thisFolderMap);
            for (SeawindFolder sf : thisFolderMap.keySet()) {
                SeawindFolder thatFD = thatFolderMap.get(sf);
                boolean bl = same = same && thatFD.creationTime == sf.creationTime && thatFD.modificationTime == sf.modificationTime;
            }
        }
        return same;
    }

    private static void collectFoldersMap(SeawindFolder tf, HashMap<SeawindFolder, SeawindFolder> folders) {
        folders.put(tf, tf);
        Set<SeawindFolder> fds = tf.getFolders();
        for (SeawindFolder sf : fds) {
            SeawindFolder.collectFoldersMap(sf, folders);
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject object = new JSONObject();
        object.put("title", (Object)(this.title != null ? this.title : ""));
        object.put("modificationTime", this.modificationTime);
        object.put("creationTime", this.creationTime);
        JSONArray fileArray = new JSONArray();
        for (SeawindFile file : this.files) {
            fileArray.put((Object)file.toJSON());
        }
        JSONArray folderArray = new JSONArray();
        for (SeawindFolder folder : this.folders) {
            folderArray.put((Object)folder.toJSON());
        }
        if (fileArray.length() > 0) {
            object.put("files", (Object)fileArray);
        }
        if (folderArray.length() > 0) {
            object.put("folders", (Object)folderArray);
        }
        return object;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SeawindFolder)) {
            return false;
        }
        return ((SeawindFolder)obj).getPath().equals(this.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public String toString() {
        return "(" + this.getTitle() + ")SeawindFolder(" + this.getPath() + "): " + this.toJSON();
    }
}

