/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind.dashboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.internal.SpaceCollaborativeEngine;
import org.xmind.gef.util.Properties;
import org.xmind.seawind.internal.core.SeawindFile;
import org.xmind.seawind.internal.core.SeawindFolder;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GalleryEditTool;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.gallery.IDecorationContext;
import org.xmind.ui.internal.dashboard.pages.IDashboardContext;
import org.xmind.ui.internal.seawind.ISeawindLibraryListener;
import org.xmind.ui.internal.seawind.SeawindFolderManager;
import org.xmind.ui.internal.seawind.SeawindLibrary;
import org.xmind.ui.internal.seawind.SeawindLibraryEvent;
import org.xmind.ui.internal.seawind.SeawindMessages;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;
import org.xmind.ui.internal.seawind.SeawindWorkbookRef;
import org.xmind.ui.internal.seawind.URIUtils;
import org.xmind.ui.internal.seawind.dashboard.CloudMapGalleryPartFactory;
import org.xmind.ui.internal.seawind.dashboard.CloudMapLabelProvider;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.texteditor.FloatingTextEditor;

public class CloudFolderPageSection {
    private static final int FRAME_WIDTH = 210;
    private static final int FRAME_HEIGHT = 91;
    private static final String COLOR_CONTENT_BORDER = "#cccccc";
    private final IDashboardContext context;
    private SeawindLibrary library;
    private final GalleryViewer viewer;
    private ResourceManager resources;
    private Control control;
    private Set<SeawindFolder> folders;
    private SpaceCollaborativeEngine spaceCollaborativeEngine;

    public CloudFolderPageSection(IDashboardContext context, final SeawindLibrary library, Composite parent, SpaceCollaborativeEngine spaceCollaborativeEngine) {
        this.context = context;
        this.library = library;
        this.spaceCollaborativeEngine = spaceCollaborativeEngine;
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.viewer = new GalleryViewer();
        this.control = this.doCreateControl(parent);
        final ISeawindLibraryListener listener = new ISeawindLibraryListener(){

            @Override
            public void handleSeawindLibraryEvent(SeawindLibraryEvent event) {
                if (event.getType() == 1 && event.getTarget() instanceof SeawindFolder) {
                    SeawindFolder folder = (SeawindFolder)event.getTarget();
                    CloudFolderPageSection.this.viewer.refresh();
                    CloudFolderPageSection.this.viewer.setSelection((ISelection)new StructuredSelection((Object)folder));
                }
            }
        };
        library.addLibraryListener(listener);
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (library != null) {
                    library.removeLibraryListener(listener);
                }
            }
        });
    }

    private Control doCreateControl(Composite parent) {
        Properties properties = this.viewer.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_BOTTOM);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.FALSE);
        properties.set("org.xmind.ui.gallery.solidFrames", true);
        properties.set("org.xmind.ui.gallery.flatFrames", true);
        properties.set("constrained", true);
        properties.set("stretched", true);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(1, 1, 30, 0, new Insets(10, 65, 20, 65)));
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(210, 91));
        properties.set("org.xmind.ui.gallery.customDecorateContentPane", true);
        properties.set("org.xmind.ui.gallery.contentPaneBorderWidth", 1);
        properties.set("org.xmind.ui.gallery.contentPaneBorderColor", (Object)((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)COLOR_CONTENT_BORDER))));
        properties.set("org.xmind.ui.gallery.contentPaneSpaceCollaborativeEngine", (Object)this.spaceCollaborativeEngine);
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new CloudFolderSelectTool());
        editDomain.installTool("edit tool", (ITool)new CloudFolderTitleEditTool());
        this.viewer.setEditDomain(editDomain);
        this.viewer.setTitleEditingApprover(new IFilter(){

            public boolean select(Object toTest) {
                SeawindFolder folder = SeawindUIPlugin.getAdapter(toTest, SeawindFolder.class);
                if (folder != null) {
                    return true;
                }
                return toTest instanceof IPart && (folder = SeawindUIPlugin.getAdapter(((IPart)toTest).getModel(), SeawindFolder.class)) != null;
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                CloudFolderPageSection.this.openSelectedFolder(event.getSelection());
            }
        });
        Control viewerControl = this.viewer.createControl(parent);
        viewerControl.setBackground(parent.getBackground());
        viewerControl.setForeground(parent.getForeground());
        viewerControl.setLayoutData((Object)new GridData(4, 4, true, false));
        this.viewer.setPartFactory((IPartFactory)new CloudMapGalleryPartFactory());
        this.viewer.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new CloudFolderLabelProvider(viewerControl, this.library));
        this.context.registerContextMenu((Object)viewerControl, "org.xmind.ui.popup.dashboard.cloud.mapCollection");
        final Shell shellForRenameHelper = this.initRenameHelper(parent);
        viewerControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!shellForRenameHelper.isDisposed()) {
                    shellForRenameHelper.setData("org.xmind.ui.seawind.dashboard.renameFolderHelper", null);
                }
            }
        });
        return viewerControl;
    }

    private Shell initRenameHelper(Composite parent) {
        Shell shellForRenameHelper = parent.getShell();
        shellForRenameHelper.setData("org.xmind.ui.seawind.dashboard.renameFolderHelper", (Object)new Runnable(){

            @Override
            public void run() {
                CloudFolderPageSection.this.startEditing();
            }
        });
        return shellForRenameHelper;
    }

    public void setInput(SeawindFolder folder) {
        Set folders;
        this.folders = folders = folder.getFolders();
        this.viewer.setInput((Object)folders);
        this.viewer.getControl().setVisible(folders.size() != 0);
        ((GridData)this.viewer.getControl().getLayoutData()).exclude = folders.size() == 0;
        this.viewer.getControl().getParent().layout(true, true);
        this.initRenameHelper(this.viewer.getControl().getParent());
    }

    private void startEditing() {
        if (this.viewer == null) {
            return;
        }
        EditDomain domain = this.viewer.getEditDomain();
        domain.handleRequest("edit", (IViewer)this.viewer);
    }

    private void openSelectedFolder(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (!(element instanceof SeawindFolder)) {
            return;
        }
        SeawindFolder folder = (SeawindFolder)element;
        this.library.setCurrentFolderPath(folder.getPath());
    }

    public Control getControl() {
        return this.control;
    }

    public GalleryViewer getViewer() {
        return this.viewer;
    }

    public void setSelection(List<String> folderPaths) {
        if (this.folders != null) {
            ArrayList<SeawindFolder> selections = new ArrayList<SeawindFolder>();
            for (SeawindFolder folder : this.folders) {
                if (!folderPaths.contains(folder.getPath())) continue;
                selections.add(folder);
            }
            this.viewer.setSelection((ISelection)new StructuredSelection(selections), true);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.viewer != null) {
            if (adapter.isAssignableFrom(this.viewer.getClass())) {
                return adapter.cast(this.viewer);
            }
            Object obj = this.viewer.getAdapter(adapter);
            if (obj != null) {
                return (T)obj;
            }
        }
        return null;
    }

    private static class CloudFolderLabelProvider
    extends CloudMapLabelProvider {
        private ResourceManager resources;
        private SeawindLibrary library;

        public CloudFolderLabelProvider(Control control, SeawindLibrary library) {
            super(control);
            this.resources = new LocalResourceManager(JFaceResources.getResources(), control);
            this.library = library;
        }

        @Override
        public String getText(Object element) {
            if (element instanceof SeawindFolder) {
                String title = ((SeawindFolder)element).getTitle();
                if (title.length() > 20) {
                    title = String.valueOf(title.substring(0, 20)) + "...";
                }
                return title;
            }
            return super.getText(element);
        }

        @Override
        public Image getImage(Object element) {
            if (element instanceof SeawindFolder) {
                return (Image)this.resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("folder.png"));
            }
            return super.getImage(element);
        }

        @Override
        public String getSubtitle(Object element) {
            int count = this.countSeawindFiles((SeawindFolder)element);
            return count > 1 ? String.valueOf(count) + SeawindMessages.CloudFolderPageSection_Items : String.valueOf(count) + SeawindMessages.CloudFolderPageSection_Item;
        }

        private int countSeawindFiles(SeawindFolder folder) {
            Assert.isTrue((boolean)(folder instanceof SeawindFolder));
            Collection<IWorkbookRef> allWorkbookRefs = this.library.getWorkbookRefs();
            Set files = folder.getFiles();
            int count = 0;
            block0: for (SeawindFile file : files) {
                String identifier = file.getIdentifier();
                for (IWorkbookRef workbookRef : allWorkbookRefs) {
                    if (!identifier.equals(URIUtils.getWorkbookIdFromURI(workbookRef.getURI()))) continue;
                    ++count;
                    continue block0;
                }
            }
            return count;
        }

        @Override
        public String getToolTip(Object element) {
            if (element instanceof SeawindFolder) {
                SeawindFolder folder = (SeawindFolder)element;
                SeawindLibrary library = SeawindUIPlugin.getSeawindLibrary();
                ArrayList<IWorkbookRef> workbookRefs = new ArrayList<IWorkbookRef>();
                Collection<IWorkbookRef> allWorkbookRefs = library.getWorkbookRefs();
                Set<SeawindFile> files = SeawindFolderManager.collectLeafs(folder, new HashSet<SeawindFile>());
                block0: for (SeawindFile file : files) {
                    String identifier = file.getIdentifier();
                    for (IWorkbookRef workbookRef : allWorkbookRefs) {
                        if (!identifier.equals(URIUtils.getWorkbookIdFromURI(workbookRef.getURI()))) continue;
                        workbookRefs.add(workbookRef);
                        continue block0;
                    }
                }
                boolean isWarningState = false;
                boolean isSyncingState = false;
                for (IWorkbookRef workbookRef : workbookRefs) {
                    if (!(workbookRef instanceof SeawindWorkbookRef) || ((SeawindWorkbookRef)workbookRef).getSyncError() == null) continue;
                    isWarningState = true;
                    break;
                }
                if (!isWarningState) {
                    for (IWorkbookRef workbookRef : workbookRefs) {
                        if (!workbookRef.isInState(2)) continue;
                        isSyncingState = true;
                        break;
                    }
                }
                if (isWarningState) {
                    return SeawindMessages.CloudFolderPageSection_ToolTip_Sync_Error;
                }
                if (isSyncingState) {
                    return SeawindMessages.CloudFolderPageSection_Tooltip_Syncing;
                }
            }
            return null;
        }

        @Override
        public Color getForeground(Object element) {
            return null;
        }

        @Override
        public IFigure decorateFigure(IFigure figure, Object element, IDecorationContext context) {
            if (!(element instanceof SeawindFolder)) {
                return figure;
            }
            return this.decorateFrameFigure(figure, (SeawindFolder)element, context);
        }

        protected IFigure decorateFrameFigure(IFigure contentPane, SeawindFolder folder, IDecorationContext context) {
            SizeableImageFigure stateIconFigure;
            SizeableImageFigure thumbnailFigure;
            List figures = contentPane.getChildren();
            boolean needInitFigureContent = figures.isEmpty();
            if (needInitFigureContent) {
                contentPane.setLayoutManager((LayoutManager)new CloudMapLabelProvider.CloudMapFrameContentLayout(context));
                thumbnailFigure = new SizeableImageFigure(this.getImage(folder));
                stateIconFigure = new SizeableImageFigure(this.getStateImage(folder));
                contentPane.add((IFigure)thumbnailFigure);
                contentPane.add((IFigure)stateIconFigure, (Object)36);
                if (context != null) {
                    boolean imageConstrained = Boolean.TRUE.equals(context.getProperty("constrained", (Object)false));
                    boolean imageStretched = Boolean.TRUE.equals(context.getProperty("stretched", (Object)false));
                    thumbnailFigure.setConstrained(imageConstrained);
                    thumbnailFigure.setStretched(imageStretched);
                }
            } else {
                thumbnailFigure = (SizeableImageFigure)figures.get(0);
                stateIconFigure = (SizeableImageFigure)figures.get(1);
            }
            thumbnailFigure.setImage(this.getImage(folder));
            stateIconFigure.setImage(this.getStateImage(folder));
            return contentPane;
        }

        private Image getStateImage(SeawindFolder folder) {
            SeawindLibrary library = SeawindUIPlugin.getSeawindLibrary();
            ArrayList<IWorkbookRef> workbookRefs = new ArrayList<IWorkbookRef>();
            Collection<IWorkbookRef> allWorkbookRefs = library.getWorkbookRefs();
            Set<SeawindFile> files = SeawindFolderManager.collectLeafs(folder, new HashSet<SeawindFile>());
            block0: for (SeawindFile file : files) {
                String identifier = file.getIdentifier();
                for (IWorkbookRef workbookRef : allWorkbookRefs) {
                    if (!identifier.equals(URIUtils.getWorkbookIdFromURI(workbookRef.getURI()))) continue;
                    workbookRefs.add(workbookRef);
                    continue block0;
                }
            }
            boolean isWarningState = false;
            boolean isSyncingState = false;
            for (IWorkbookRef workbookRef : workbookRefs) {
                if (!(workbookRef instanceof SeawindWorkbookRef) || ((SeawindWorkbookRef)workbookRef).getSyncError() == null) continue;
                isWarningState = true;
                break;
            }
            if (!isWarningState) {
                for (IWorkbookRef workbookRef : workbookRefs) {
                    if (!workbookRef.isInState(2)) continue;
                    isSyncingState = true;
                    break;
                }
            }
            ImageDescriptor imageDescriptor = isWarningState ? SeawindUIPlugin.getImageDescriptor("warning.png") : (isSyncingState ? SeawindUIPlugin.getImageDescriptor("syncing.png") : SeawindUIPlugin.getImageDescriptor("synced.png"));
            return (Image)this.resources.get((DeviceResourceDescriptor)imageDescriptor);
        }
    }

    private class CloudFolderSelectTool
    extends GallerySelectTool {
        private CloudFolderSelectTool() {
        }

        protected boolean handleSelectionOnMouseDown(MouseEvent me) {
            CloudFolderPageSection.this.control.setFocus();
            return super.handleSelectionOnMouseDown(me);
        }

        protected boolean handleMouseDown(MouseEvent me) {
            FramePart targetFrame = this.findFrame(me.target);
            if (targetFrame != null && targetFrame.getFigure().isSelected()) {
                return super.handleMouseDown(me);
            }
            return this.handleSelectionOnMouseDown(me);
        }

        private FramePart findFrame(IPart part) {
            while (part != null) {
                if (part instanceof FramePart) {
                    return (FramePart)part;
                }
                part = part.getParent();
            }
            return null;
        }
    }

    private static class CloudFolderTitleEditTool
    extends GalleryEditTool {
        private CloudFolderTitleEditTool() {
        }

        protected IDocument getTextContents(IPart source) {
            return new Document(((SeawindFolder)source.getModel()).getTitle());
        }

        protected void handleTextModified(IPart source, IDocument document) {
            if (source == null) {
                return;
            }
            String newName = document.get();
            if (newName == null || "".equals(newName)) {
                return;
            }
            SeawindFolder folder = (SeawindFolder)source.getModel();
            if (folder == null || folder.getOwnedParent() == null) {
                return;
            }
            for (SeawindFolder brother : folder.getOwnedParent().getFolders()) {
                if (!brother.getTitle().equals(newName)) continue;
                return;
            }
            SeawindUIPlugin.getSeawindLibrary().renameFolder(folder, newName);
        }

        protected void hookEditor(FloatingTextEditor editor) {
            super.hookEditor(editor);
            Dimension frameSize = (Dimension)this.getTargetViewer().getProperties().get("org.xmind.ui.gallery.frameContentSize");
            if (frameSize != null) {
                this.getHelper().setPrefWidth(frameSize.width);
            }
        }
    }
}

