/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind.dashboard;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.xmind.seawind.internal.core.SeawindFolder;
import org.xmind.ui.internal.seawind.SeawindMessages;
import org.xmind.ui.internal.seawind.SeawindWorkbookRef;

public class CloudComparator
extends ViewerComparator {
    public static final String BY_NAME_ASC = "by_name_asc";
    public static final String BY_NAME_DESC = "by_name_desc";
    public static final String BY_MODIFICATION_TIME_ASC = "by_modification_time_asc";
    public static final String BY_MODIFICATION_TIME_DESC = "by_modification_time_desc";
    private static final int NAME = 5;
    private static final int MODIFICATION_TIME = 6;
    private String sortType;
    private boolean isNameAsc = true;
    private boolean isTimeAsc = true;
    public static final CloudComparator NAME_ASC = new CloudComparator("by_name_asc");
    public static final CloudComparator NAME_DESC = new CloudComparator("by_name_desc");
    public static final CloudComparator MODIFICATION_TIME_ASC = new CloudComparator("by_modification_time_asc");
    public static final CloudComparator MODIFICATION_TIME_DESC = new CloudComparator("by_modification_time_desc");

    public static CloudComparator getComparatorAsType(String type) {
        if (type == null || type.equals("")) {
            type = BY_NAME_ASC;
        }
        if (BY_NAME_ASC.equals(type)) {
            return NAME_ASC;
        }
        if (BY_NAME_DESC.equals(type)) {
            return NAME_DESC;
        }
        if (BY_MODIFICATION_TIME_ASC.equals(type)) {
            return MODIFICATION_TIME_ASC;
        }
        if (BY_MODIFICATION_TIME_DESC.equals(type)) {
            return MODIFICATION_TIME_DESC;
        }
        return null;
    }

    private CloudComparator(String type) {
        this.sortType = type;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.cloudCompara(e1, e2);
    }

    private int cloudCompara(Object e1, Object e2) {
        if (this.sortType == null || "".equals(this.sortType)) {
            return 0;
        }
        if (!(e1 instanceof SeawindFolder) && !(e1 instanceof SeawindWorkbookRef) || !(e2 instanceof SeawindFolder) && !(e2 instanceof SeawindWorkbookRef)) {
            return 0;
        }
        if (BY_NAME_ASC.equals(this.sortType)) {
            return this.comparaForSort(5, this.isNameAsc, e1, e2);
        }
        if (BY_NAME_DESC.equals(this.sortType)) {
            return this.comparaForSort(5, !this.isNameAsc, e1, e2);
        }
        if (BY_MODIFICATION_TIME_ASC.equals(this.sortType)) {
            return this.comparaForSort(6, this.isTimeAsc, e1, e2);
        }
        if (BY_MODIFICATION_TIME_DESC.equals(this.sortType)) {
            return this.comparaForSort(6, !this.isTimeAsc, e1, e2);
        }
        return 0;
    }

    private int comparaForSort(int sortType, boolean asc, Object resource1, Object resource2) {
        if (resource1 instanceof SeawindFolder && resource2 instanceof SeawindFolder) {
            SeawindFolder folder1 = (SeawindFolder)resource1;
            SeawindFolder folder2 = (SeawindFolder)resource2;
            return asc ? this.comparaFolder(sortType, folder1, folder2) : this.comparaFolder(sortType, folder2, folder1);
        }
        if (resource1 instanceof SeawindFolder && resource2 instanceof SeawindWorkbookRef) {
            return -1;
        }
        if (resource1 instanceof SeawindWorkbookRef && resource2 instanceof SeawindFolder) {
            return 1;
        }
        SeawindWorkbookRef file1 = (SeawindWorkbookRef)((Object)resource1);
        SeawindWorkbookRef file2 = (SeawindWorkbookRef)((Object)resource2);
        return asc ? this.comparaSeawindWorkbookRef(sortType, file1, file2) : this.comparaSeawindWorkbookRef(sortType, file2, file1);
    }

    private int comparaSeawindWorkbookRef(int sortType, SeawindWorkbookRef file1, SeawindWorkbookRef file2) {
        switch (sortType) {
            case 5: {
                String name = file1.getName();
                String name2 = file2.getName();
                if (name == null || name2 == null) {
                    name = name2 = SeawindMessages.SeawindWorkbookRef_UntitledWorkbookName;
                }
                return name.toLowerCase().compareTo(name2.toLowerCase());
            }
            case 6: {
                return String.valueOf(file1.getModificationTime()).compareTo(String.valueOf(file2.getModificationTime()));
            }
        }
        return 0;
    }

    private int comparaFolder(int sortType, SeawindFolder folder1, SeawindFolder folder2) {
        switch (sortType) {
            case 5: {
                return folder1.getTitle().toLowerCase().compareTo(folder2.getTitle().toLowerCase());
            }
            case 6: {
                return String.valueOf(folder1.getModificationTime()).compareTo(String.valueOf(folder2.getModificationTime()));
            }
        }
        return 0;
    }
}

