/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.net.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.Assert;
import org.xmind.core.net.http.HttpEntity;

public class StreamedEntity
extends HttpEntity {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private InputStream input;
    private long length;
    private int bufferSize;

    public StreamedEntity(InputStream input, long length, int bufferSize) {
        Assert.isLegal((input != null ? 1 : 0) != 0);
        Assert.isLegal((bufferSize > 0 ? 1 : 0) != 0);
        this.input = input;
        this.length = length;
        this.bufferSize = bufferSize;
    }

    public StreamedEntity(InputStream input, long length) {
        this(input, length, 4096);
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        StreamedEntity.transfer(this.input, output, this.bufferSize);
    }

    @Override
    public long getContentLength() {
        return this.length;
    }

    public static void transfer(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int numRead;
        byte[] buffer = new byte[bufferSize];
        while ((numRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, numRead);
        }
    }
}

