/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.fishbone.structures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.xmind.core.util.Point;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.geometry.IPrecisionTransformer;
import org.xmind.gef.draw2d.geometry.PrecisionInsets;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.geometry.PrecisionRotator;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.BoundaryLayoutHelper;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.internal.fishbone.structures.AbstractSubFishboneDirection;
import org.xmind.ui.internal.fishbone.structures.FishboneData;
import org.xmind.ui.internal.fishbone.structures.ISubDirection;
import org.xmind.ui.internal.fishbone.structures.SubFishboneStructure;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NorthEastRotated
extends AbstractSubFishboneDirection {
    public NorthEastRotated() {
        super(-70.0, false, false, true, 16, 8);
    }

    @Override
    public ISubDirection getSubDirection() {
        return NE;
    }

    @Override
    public void fillFishboneData(IBranchPart branch, FishboneData data, IPrecisionTransformer h, PrecisionRotator r, double spacing, List<IBranchPart> subbranches) {
        IInsertion insertion;
        PrecisionPoint origin = h.getOrigin();
        PrecisionInsets hTopicIns = h.ti(data.topicRefIns);
        PrecisionRectangle hBranchBounds = h.ti(data.branchRefIns).getBounds(origin);
        PrecisionRectangle rhBranchBounds = h.ti(data.rBranchRefIns).getBounds(origin);
        double sin = r.sin();
        double ctg = r.cos() / r.sin();
        subbranches = new ArrayList<IBranchPart>(subbranches);
        Collections.reverse(subbranches);
        PrecisionPoint joint = origin.getTranslated(0.0, hTopicIns.bottom);
        IPlusMinusPart plusMinus = branch.getPlusMinus();
        if (plusMinus != null) {
            joint.x += (double)plusMinus.getFigure().getPreferredSize().width;
        }
        int insIndex = (insertion = (IInsertion)MindMapUtils.getCache((IPart)branch, (String)"org.xmind.ui.branchCache.insertion")) == null ? -1 : subbranches.size() - insertion.getIndex();
        Dimension insSize = insertion == null ? null : insertion.getSize();
        double insHeight = insSize == null ? 0 : insSize.height;
        IStructure structure = branch.getBranchPolicy().getStructure((IGraphicalPart)branch);
        BoundaryLayoutHelper helper = ((SubFishboneStructure)structure).getBoundaryLayoutHelper(branch);
        int i = 0;
        while (i < subbranches.size()) {
            PrecisionInsets rhChildBranchIns;
            PrecisionInsets hChildBranchIns;
            IBranchPart subBranch = subbranches.get(i);
            IFigure subBranchFigure = subBranch.getFigure();
            Insets ins = helper.getInsets(subBranch);
            PrecisionInsets hChildBorder = h.ti(new PrecisionInsets(ins));
            PrecisionInsets rhChildBorder = r.ti(hChildBorder);
            IStructure bsa = subBranch.getBranchPolicy().getStructure((IGraphicalPart)subBranch);
            if (bsa instanceof SubFishboneStructure) {
                SubFishboneStructure sa = (SubFishboneStructure)bsa;
                FishboneData subData = sa.getCastedData(subBranch).getFishboneData();
                hChildBranchIns = h.ti(subData.branchRefIns);
                rhChildBranchIns = h.ti(subData.rBranchRefIns);
            } else {
                PrecisionInsets childBranchNormal = new PrecisionInsets(((IReferencedFigure)subBranchFigure).getReferenceDescription());
                hChildBranchIns = h.ti(childBranchNormal);
                rhChildBranchIns = r.ti(hChildBranchIns);
            }
            double dy = rhChildBranchIns.top;
            double dx1 = Math.abs((hChildBorder.bottom + hChildBranchIns.bottom) / sin);
            if (insIndex >= 0 && i == insIndex) {
                dx1 += Math.abs(insHeight / sin);
            }
            double dx2 = Math.abs(dy * ctg);
            double dx = dx1 + dx2;
            PrecisionPoint hChildRef = joint.getTranslated(dx, dy);
            PrecisionPoint rhChildRef = r.rp(hChildRef);
            data.addChildOffset(subBranch, h.rp(rhChildRef));
            hBranchBounds.union(rhChildBranchIns.getBounds(hChildRef).expand(rhChildBorder));
            rhBranchBounds.union(hChildBranchIns.getBounds(rhChildRef).expand(hChildBorder));
            double dx3 = Math.abs((hChildBorder.top + hChildBranchIns.top) / sin);
            joint.x += dx1 + dx3 + spacing;
            ++i;
        }
        data.branchRefIns = h.rr(hBranchBounds).getInsets(origin);
        data.rBranchRefIns = h.rr(rhBranchBounds).getInsets(origin);
    }

    @Override
    public void fillFishboneExtraData(IBranchPart branch, FishboneData data, IPrecisionTransformer h, PrecisionRotator r, double spacing, boolean extraBranch) {
        if (!extraBranch) {
            return;
        }
        List calloutBranches = branch.getCalloutBranches();
        PrecisionPoint origin = h.getOrigin();
        PrecisionInsets hTopicIns = h.ti(data.topicRefIns);
        PrecisionRectangle rhTopicBounds = h.ti(data.rTopicRefIns).getBounds(origin);
        double tan = r.sin() / r.cos();
        double bottomLineX = hTopicIns.bottom / r.sin();
        double bottomLineY = 0.0;
        double topLineX = -hTopicIns.top / r.sin();
        double topLineY = 0.0;
        PrecisionRectangle hBranchBounds = h.ti(data.branchRefIns).getBounds(origin);
        PrecisionRectangle rhBranchBounds = h.ti(data.rBranchRefIns).getBounds(origin);
        int i = 0;
        while (i < calloutBranches.size()) {
            PrecisionInsets rhChildBranchIns;
            PrecisionInsets hChildBranchIns;
            IBranchPart calloutBranch = (IBranchPart)calloutBranches.get(i);
            Dimension calloutTopicSize = calloutBranch.getTopicPart().getFigure().getPreferredSize();
            IReferencedFigure calloutBranchFigure = (IReferencedFigure)calloutBranch.getFigure();
            IStructure structure = calloutBranch.getBranchPolicy().getStructure((IGraphicalPart)calloutBranch);
            if (structure instanceof SubFishboneStructure) {
                FishboneData calloutData = ((SubFishboneStructure)structure).getCastedData(calloutBranch).getFishboneData();
                hChildBranchIns = h.ti(calloutData.branchRefIns);
                rhChildBranchIns = h.ti(calloutData.rBranchRefIns);
            } else {
                PrecisionInsets childBranchNormal = new PrecisionInsets(calloutBranchFigure.getReferenceDescription());
                hChildBranchIns = h.ti(childBranchNormal);
                rhChildBranchIns = r.ti(hChildBranchIns);
            }
            Point position = calloutBranch.getTopic().getPosition();
            if (position == null) {
                position = new Point();
            }
            boolean originPosition = position.x == 0 && position.y == 0;
            double dx = originPosition ? -(0.5 * hTopicIns.getHeight() / r.sin() + (double)(calloutTopicSize.width / 2)) : (double)position.x;
            double dy = originPosition ? -10 - calloutTopicSize.height : position.y;
            PrecisionPoint rhChildRef = origin.getTranslated(h.tp(dx, dy));
            PrecisionRectangle hChildBounds = hChildBranchIns.getBounds(rhChildRef);
            double distTop = (-tan * (hChildBounds.getBottomRight().x - topLineX) + topLineY - hChildBounds.getBottomRight().y) / Math.sqrt(tan * tan + 1.0);
            double distBottom = (-tan * (hChildBounds.getBottomRight().x - bottomLineX) + bottomLineY - hChildBounds.getBottomRight().y) / Math.sqrt(tan * tan + 1.0);
            double distLimit = hChildBounds.bottom() - rhTopicBounds.bottom();
            if (distLimit > 0.0) {
                rhChildRef = rhChildRef.getTranslated(0.0, -distLimit);
                hChildBounds = hChildBranchIns.getBounds(rhChildRef);
            }
            if (distBottom < 0.0) {
                rhChildRef = rhChildRef.getTranslated(distBottom / r.sin(), 0.0);
                hChildBounds = hChildBranchIns.getBounds(rhChildRef);
            }
            if (hChildBounds.toDraw2DRectangle().touches(rhTopicBounds.toDraw2DRectangle()) && distTop < 0.0) {
                rhChildRef = rhChildRef.getTranslated(distTop / r.sin(), 0.0);
            }
            PrecisionPoint hChildRef = r.tp(rhChildRef);
            data.addChildOffset(calloutBranch, h.rp(rhChildRef));
            hBranchBounds.union(rhChildBranchIns.getBounds(hChildRef));
            rhBranchBounds.union(hChildBranchIns.getBounds(rhChildRef));
            ++i;
        }
        data.branchRefIns = h.rr(hBranchBounds).getInsets(origin);
        data.rBranchRefIns = h.rr(rhBranchBounds).getInsets(origin);
    }
}

