/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.tool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.xmind.gef.GraphicalViewer;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.event.MouseWheelEvent;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.GraphicalTool;
import org.xmind.gef.tool.IDraggingTool;
import org.xmind.gef.tool.IGraphicalTool;
import org.xmind.gef.tool.ISourceTool;
import org.xmind.gef.tool.ITool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectTool
extends GraphicalTool {
    private static final List<IPart> EMPTY_PARTS = Collections.emptyList();
    private IPart sequenceStart = null;
    private boolean ignoreResetSeqStart = false;
    private IPart toSelectOnMouseUp = null;

    protected void setToSelectOnMouseUp(IPart part) {
        this.toSelectOnMouseUp = part;
    }

    @Override
    public void mouseDoubleClick(MouseEvent me, IViewer viewer) {
        this.setToSelectOnMouseUp(null);
        super.mouseDoubleClick(me, viewer);
    }

    @Override
    protected boolean handleMouseDoubleClick(MouseEvent me) {
        IPart source;
        if (me.leftOrRight && (source = me.target).hasRole("editable role")) {
            this.resetSeqSelectStart();
            this.handleEditRequest(this.createEditRequestOnDoubleClick(source, me));
            me.consume();
            return true;
        }
        return super.handleMouseDoubleClick(me);
    }

    protected Request createEditRequestOnDoubleClick(IPart source, MouseEvent me) {
        return new Request("edit").setPrimaryTarget(me.target).setDomain(this.getDomain()).setViewer(this.getTargetViewer());
    }

    @Override
    public void mouseDown(MouseEvent me, IViewer viewer) {
        this.setToSelectOnMouseUp(null);
        super.mouseDown(me, viewer);
    }

    @Override
    protected boolean handleMouseDown(MouseEvent me) {
        this.getStatus().setStatus(64, true);
        this.getStatus().setStatus(256, !me.leftOrRight);
        if (this.isToSelectOnMouseUp(me.target, this.getTargetViewer())) {
            this.setToSelectOnMouseUp(me.target);
        } else {
            this.mouseSelect(me.target);
        }
        return true;
    }

    protected void mouseSelect(IPart target) {
        if (target.hasRole("selectable role")) {
            if (this.getStatus().isStatus(4)) {
                this.getTargetViewer().setFocused(target);
            } else if (!target.getStatus().isSelected()) {
                if (this.getStatus().isStatus(8) && this.getTargetViewer().getFocused() != null) {
                    this.sequenceSelect(target);
                } else {
                    this.selectSingle(target);
                }
            }
        } else if (!this.getStatus().isStatus(4)) {
            this.handleSelectNone(this.getTargetViewer());
        }
    }

    protected boolean isToSelectOnMouseUp(IPart part, IViewer viewer) {
        return part == viewer.getRootPart();
    }

    @Override
    public void mouseDrag(MouseDragEvent me, IViewer viewer) {
        this.setToSelectOnMouseUp(null);
        super.mouseDrag(me, viewer);
    }

    @Override
    protected boolean handleMouseDrag(MouseDragEvent me) {
        this.resetSeqSelectStart();
        if (this.getStatus().isStatus(2048)) {
            me.consume();
            return true;
        }
        IPart dragSource = me.source;
        String toolType = null;
        if (this.canStartBrowsing(dragSource, me)) {
            toolType = this.getBrowseToolId();
        } else if (this.canMove(dragSource, me)) {
            toolType = this.getMoveTool(dragSource, me);
        } else if (dragSource == this.getTargetViewer().getRootPart()) {
            toolType = this.getAreaSelectToolId();
        }
        ITool tool = this.getTool(toolType);
        if (tool != null && tool != this) {
            this.changeToMoveTool(toolType, tool, dragSource, me);
            me.consume();
            return true;
        }
        return super.handleMouseDrag(me);
    }

    protected String getBrowseToolId() {
        return "browse tool";
    }

    protected String getAreaSelectToolId() {
        return "area select tool";
    }

    protected void changeToMoveTool(String moveToolType, ITool moveTool, IPart dragSource, MouseDragEvent me) {
        if (moveTool instanceof ISourceTool && dragSource instanceof IGraphicalEditPart) {
            ((ISourceTool)((Object)moveTool)).setSource((IGraphicalEditPart)dragSource);
        }
        if (moveTool instanceof IGraphicalTool) {
            ((IGraphicalTool)((Object)moveTool)).setCursorPosition(this.getCursorPosition());
        }
        if (moveTool instanceof IDraggingTool) {
            ((IDraggingTool)((Object)moveTool)).setStartingPosition(me.startingLocation);
        }
        this.changeActiveTool(moveToolType);
        if (moveTool == this.getDomain().getActiveTool()) {
            moveTool.mouseDrag(me, this.getTargetViewer());
        }
    }

    protected boolean canStartBrowsing(IPart host, MouseDragEvent me) {
        return this.getStatus().isStatus(256) || this.getStatus().isStatus(64) && host.hasRole("map movable role");
    }

    protected boolean canMove(IPart host, MouseDragEvent me) {
        return host.hasRole("movable role");
    }

    protected String getMoveTool(IPart source, MouseDragEvent me) {
        return "move tool";
    }

    @Override
    protected boolean handleMouseEntered(MouseEvent me) {
        IPart target = me.target;
        if (target != null && target.hasRole("selectable role")) {
            this.setPreSelected(target);
        } else {
            this.setPreSelected(null);
        }
        return super.handleMouseEntered(me);
    }

    protected void setPreSelected(IPart target) {
        this.getTargetViewer().setPreselected(target);
    }

    @Override
    protected boolean handleMouseHover(MouseEvent me) {
        this.getStatus().setStatus(16, true);
        return super.handleMouseHover(me);
    }

    @Override
    public void mouseLongPressed(MouseEvent me, IViewer viewer) {
        this.setToSelectOnMouseUp(null);
        super.mouseLongPressed(me, viewer);
    }

    @Override
    protected boolean handleLongPressed(MouseEvent me) {
        ITool tool;
        String browseToolId;
        if (me.leftOrRight && !this.getStatus().isStatus(8) && !this.getStatus().isStatus(4) && !this.getStatus().isStatus(2) && (browseToolId = this.getBrowseToolId()) != null && (tool = this.getTool(browseToolId)) != null) {
            if (tool instanceof IDraggingTool) {
                ((IDraggingTool)((Object)tool)).setStartingPosition(this.getCursorPosition());
            }
            if (tool instanceof IGraphicalTool) {
                ((IGraphicalTool)((Object)tool)).setCursorPosition(this.getCursorPosition());
            }
            this.changeActiveTool(browseToolId);
            if (tool == this.getDomain().getActiveTool()) {
                me.consume();
            }
            return true;
        }
        return super.handleLongPressed(me);
    }

    @Override
    public void mouseMove(MouseEvent me, IViewer viewer) {
        this.setToSelectOnMouseUp(null);
        super.mouseMove(me, viewer);
    }

    @Override
    protected boolean handleMouseMove(MouseEvent me) {
        this.getStatus().setStatus(16, false);
        return super.handleMouseMove(me);
    }

    @Override
    public boolean handleMouseUp(MouseEvent me) {
        this.getStatus().setStatus(2048, false);
        this.getStatus().setStatus(64, false);
        IPart host = me.target;
        if (this.getStatus().isStatus(4) && host.hasRole("selectable role")) {
            this.multiSelect(host);
        }
        if (this.toSelectOnMouseUp != null) {
            this.mouseSelect(this.toSelectOnMouseUp);
            this.setToSelectOnMouseUp(null);
        }
        if (!me.leftOrRight) {
            IGraphicalViewer viewer;
            this.getStatus().setStatus(256, false);
            if (!this.getStatus().isStatus(512) && (viewer = this.getTargetViewer()) instanceof GraphicalViewer) {
                ((GraphicalViewer)viewer).hideToolTip();
            }
        }
        return true;
    }

    @Override
    protected boolean handleKeyDown(KeyEvent ke) {
        int state = ke.getState();
        int key = ke.keyCode;
        IGraphicalViewer viewer = this.getTargetViewer();
        if (viewer != null && this.isNavigationKey(state, key)) {
            return this.handleNavigationKeyDown(viewer, state, key);
        }
        return super.handleKeyDown(ke);
    }

    protected boolean handleNavigationKeyDown(IGraphicalViewer viewer, int state, int key) {
        String type = this.getNavigationRequestType(key);
        if (type != null) {
            Request request = this.createTargetedRequest(type, viewer, false);
            request.setPrimaryTarget(viewer.getFocusedPart());
            if (request.hasTargets()) {
                boolean sequential = this.isSequentialNavigation(state);
                if (sequential) {
                    request.setParameter("navigationSequential", Boolean.TRUE);
                    if (this.getSequenceStart() == null) {
                        IPart newStart = request.getPrimaryTarget();
                        this.setSequenceStart(newStart);
                    }
                    request.setParameter("navigationSequenceStart", this.getSequenceStart());
                }
                return this.handleNavRequest(request, sequential);
            }
        }
        return true;
    }

    protected boolean handleNavRequest(Request request, boolean sequential) {
        this.getDomain().handleRequest(request);
        Object result = request.getResult("navigationResult");
        if (result != null && result instanceof IPart[]) {
            IPart[] toSelect = (IPart[])result;
            IPart toFocus = (IPart)request.getResult("newFocus");
            this.navigateTo(Arrays.asList(toSelect), toFocus, sequential);
            return true;
        }
        return false;
    }

    protected void navigateTo(List<IPart> toSelect, boolean sequential) {
        this.navigateTo(toSelect, null, sequential);
    }

    protected void navigateTo(List<IPart> toSelect, IPart toFocus, boolean sequential) {
        if (sequential) {
            this.ignoreResetSeqStart = true;
        }
        this.select(toSelect, toFocus == null || !toSelect.contains(toFocus) ? (toSelect.isEmpty() ? null : toSelect.get(0)) : toFocus);
        if (sequential) {
            this.ignoreResetSeqStart = false;
        }
    }

    protected boolean isNavigationKey(int state, int key) {
        if (state == 0 || state == SWT.MOD2) {
            return key == 0x1000001 || key == 0x1000002 || key == 0x1000003 || key == 0x1000004 || key == 0x1000007 || key == 0x1000008;
        }
        return false;
    }

    protected boolean isSequentialNavigation(int state) {
        return state == SWT.MOD2;
    }

    protected String getNavigationRequestType(int key) {
        switch (key) {
            case 0x1000001: {
                return "navigate_up";
            }
            case 0x1000002: {
                return "navigate_down";
            }
            case 0x1000003: {
                return "navigate_left";
            }
            case 0x1000004: {
                return "navigate_right";
            }
            case 0x1000007: {
                return "navigate_beginning";
            }
            case 0x1000008: {
                return "navigate_end";
            }
        }
        return null;
    }

    @Override
    protected void handleNonTargetedRequest(Request request) {
        String requestType = request.getType();
        if ("undo".equals(requestType)) {
            ICommandStack cs = this.getDomain().getCommandStack();
            if (cs.canUndo()) {
                cs.undo();
            }
            return;
        }
        if ("redo".equals(requestType)) {
            ICommandStack cs = this.getDomain().getCommandStack();
            if (cs.canRedo()) {
                cs.redo();
            }
            return;
        }
        if (request.getTargetViewer() != null) {
            if ("select_none".equals(requestType)) {
                this.handleSelectNone(request.getTargetViewer());
                return;
            }
            if ("select_all".equals(requestType)) {
                this.handleSelectAll(request.getTargetViewer());
                return;
            }
            if (this.allowsFillTargets(request)) {
                this.fillTargets(request, request.getTargetViewer(), false);
                if (request.hasTargets()) {
                    this.handleTargetedRequest(request);
                    return;
                }
            }
        }
        super.handleNonTargetedRequest(request);
    }

    protected boolean allowsFillTargets(Request request) {
        return true;
    }

    @Override
    protected void handleTargetedRequest(Request request) {
        String requestType = request.getType();
        if ("select".equals(requestType)) {
            this.select(request.getTargets(), request.getPrimaryTarget());
        } else if ("select_single".equals(requestType)) {
            this.selectSingle(request.getPrimaryTarget());
        } else if ("edit".equals(requestType)) {
            this.handleEditRequest(request);
        } else {
            super.handleTargetedRequest(request);
        }
    }

    protected void handleSelectAll(IViewer viewer) {
        List<IPart> allSelectable = this.collectAllSelectable(viewer.getRootPart(), new ArrayList<IPart>());
        IPart toFocus = this.getTargetViewer().getFocusedPart();
        this.select(allSelectable, toFocus);
    }

    protected List<IPart> collectAllSelectable(IPart parent, List<IPart> results) {
        for (IPart child : parent.getChildren()) {
            if (this.isSelectableOnSelectAll(child)) {
                results.add(child);
            }
            this.collectAllSelectable(child, results);
        }
        return results;
    }

    protected boolean isSelectableOnSelectAll(IPart child) {
        return this.getTargetViewer().getSelectionSupport().isSelectable(child);
    }

    public IPart getSequenceStart() {
        return this.sequenceStart;
    }

    protected List<IPart> getSequenceParts(IPart start, IPart end) {
        return Arrays.asList(start, end);
    }

    protected void select(List<? extends IPart> toSelect, IPart toFocus) {
        IGraphicalViewer viewer = this.getTargetViewer();
        if (viewer != null) {
            IPart lastFocused = viewer.getFocusedPart();
            viewer.setSelection((ISelection)new StructuredSelection(toSelect), true);
            this.resetSeqSelectStart();
            viewer.setFocused(this.getToFocus(toFocus, lastFocused));
        }
    }

    protected IPart getToFocus(IPart toFocus, IPart lastFocused) {
        if (this.isFocusable(toFocus, lastFocused)) {
            return toFocus;
        }
        return null;
    }

    protected boolean isFocusable(IPart toFocus, IPart lastFocused) {
        if (lastFocused != null && lastFocused.getStatus().isSelected()) {
            return true;
        }
        return toFocus != null && toFocus.getStatus().isSelected();
    }

    protected void multiSelect(IPart host) {
        if (!host.getStatus().isSelected()) {
            this.getTargetViewer().getSelectionSupport().appendSelection(host);
        } else {
            this.getTargetViewer().getSelectionSupport().deselect(host);
        }
    }

    protected void handleSelectNone(IViewer viewer) {
        this.select(EMPTY_PARTS, null);
    }

    protected void selectSingle(IPart target) {
        this.select(Collections.singletonList(target), target);
    }

    protected void sequenceSelect(IPart target) {
        List<IPart> seqParts;
        if (this.getSequenceStart() == null) {
            this.setSequenceStart(this.getTargetViewer().getFocusedPart());
        }
        if ((seqParts = this.getSequenceParts(this.getSequenceStart(), target)) != null && !seqParts.isEmpty()) {
            this.ignoreResetSeqStart = true;
            this.select(seqParts, target);
            this.ignoreResetSeqStart = false;
        }
    }

    protected void setSequenceStart(IPart start) {
        this.sequenceStart = start;
    }

    public void resetSeqSelectStart() {
        if (this.ignoreResetSeqStart) {
            return;
        }
        this.setSequenceStart(null);
    }

    protected void handleEditRequest(Request request) {
        this.startEditing(request.getPrimaryTarget(), request);
    }

    protected void startEditing(IPart source, Request request) {
        String editToolType = this.getEditTool(source, request);
        ITool et = this.getTool(editToolType);
        if (et != null && et != this) {
            this.changeActiveTool(editToolType);
            if (et == this.getDomain().getActiveTool()) {
                et.handleRequest(request);
            }
        }
    }

    protected String getEditTool(IPart source, Request request) {
        return "edit tool";
    }

    @Override
    protected boolean handleWheelScrolled(MouseWheelEvent me) {
        if (this.getStatus().isStatus(4) && this.handleZoomByScroll(me)) {
            return true;
        }
        return super.handleWheelScrolled(me);
    }

    protected boolean handleZoomByScroll(MouseWheelEvent me) {
        if (me.upOrDown) {
            this.getDomain().handleRequest("zoom_in", this.getTargetViewer());
        } else {
            this.getDomain().handleRequest("zoom_out", this.getTargetViewer());
        }
        me.doIt = false;
        return true;
    }
}

