/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.tools;

import org.eclipse.draw2d.IFigure;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.IInsertableBranchStructureExtension;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.tools.ParentSearchKey;

public class ParentSearcher {
    private static final int FARTHEST_RANGE = 40000;
    private int minDistance = Integer.MAX_VALUE;
    private IBranchPart targetParent = null;
    private boolean canDropInsideTopic;

    public ParentSearcher(boolean canDropInsideTopic) {
        this.canDropInsideTopic = canDropInsideTopic;
    }

    public ParentSearcher() {
        this(false);
    }

    public IBranchPart searchTargetParent(IPart root, ParentSearchKey key) {
        this.minDistance = Integer.MAX_VALUE;
        this.targetParent = null;
        this.search(root, key);
        if (this.minDistance > 40000) {
            this.targetParent = null;
        }
        return this.targetParent;
    }

    private void search(IPart parent, ParentSearchKey key) {
        if (parent instanceof IBranchPart) {
            this.searchBranch((IBranchPart)parent, key);
        } else {
            for (IPart p : parent.getChildren()) {
                this.search(p, key);
            }
        }
    }

    private void searchBranch(IBranchPart branch, ParentSearchKey key) {
        int distance;
        ITopicPart topic = branch.getTopicPart();
        if (topic == null) {
            return;
        }
        IFigure topicFigure = topic.getFigure();
        if (topicFigure == null || !topicFigure.isEnabled()) {
            return;
        }
        if (this.canDropInsideTopic && ((IGraphicalEditPart)topic).containsPoint(key.getCursorPos())) {
            this.minDistance = 0;
            this.targetParent = branch;
            return;
        }
        IStructure sa = branch.getBranchPolicy().getStructure(branch);
        if (sa instanceof IInsertableBranchStructureExtension && (distance = ((IInsertableBranchStructureExtension)sa).calcChildDistance(branch, key)) >= 0 && distance < this.minDistance) {
            this.minDistance = distance;
            this.targetParent = branch;
        }
        if (branch.canSearchChild()) {
            for (IBranchPart subBranch : branch.getSubBranches()) {
                this.searchBranch(subBranch, key);
            }
            for (IBranchPart summaryBranch : branch.getSummaryBranches()) {
                this.searchBranch(summaryBranch, key);
            }
            for (IBranchPart callout : branch.getCalloutBranches()) {
                this.searchBranch(callout, key);
            }
        }
    }

    public int getIndex(IBranchPart targetParent, ParentSearchKey key) {
        if (targetParent != null) {
            if (this.canDropInsideTopic && ((IGraphicalEditPart)targetParent.getTopicPart()).containsPoint(key.getCursorPos())) {
                return -1;
            }
            IStructure sa = targetParent.getBranchPolicy().getStructure(targetParent);
            if (sa instanceof IInsertableBranchStructureExtension) {
                return ((IInsertableBranchStructureExtension)sa).calcChildIndex(targetParent, key);
            }
        }
        return -1;
    }
}

