/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.e4handlers;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.inject.Named;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;
import org.xmind.core.CoreException;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.SaveWizardDialog;
import org.xmind.ui.internal.editor.DecryptionDialog;
import org.xmind.ui.internal.editor.IEncryptable;
import org.xmind.ui.internal.editor.SaveWizardManager;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.IWorkbookRefFactory;
import org.xmind.ui.wizards.ISaveContext;
import org.xmind.ui.wizards.ISaveWizard;
import org.xmind.ui.wizards.SaveOptions;

public class SaveWorkbookAsHandler {
    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") Object selection, @Optional IProgressService progressProvider, final @Optional IServiceLocator serviceLocator) throws InvocationTargetException {
        if (selection instanceof IStructuredSelection) {
            selection = ((IStructuredSelection)selection).getFirstElement();
        }
        if (selection instanceof IWorkbookRef) {
            SaveWorkbookAsHandler.saveWorkbookAs(new ISaveContext(){

                @Override
                public Object getContextVariable(String key) {
                    IEvaluationService service = (IEvaluationService)serviceLocator.getService(IEvaluationService.class);
                    Assert.isNotNull((Object)service);
                    Object variable = service.getCurrentState().getVariable(key);
                    return variable == IEvaluationContext.UNDEFINED_VARIABLE ? null : variable;
                }

                @Override
                public <T> T getContextVariable(Class<T> key) {
                    return (T)serviceLocator.getService(key);
                }
            }, (IWorkbookRef)selection, (IRunnableContext)progressProvider, null, false);
        }
    }

    public static IWorkbookRef saveWorkbookAs(ISaveContext context, final IWorkbookRef workbookRef, IRunnableContext runner, IFilter optionFilter, boolean onlyToLocal) throws InvocationTargetException {
        IWorkbookRef newWorkbookRef;
        String oldName;
        Assert.isLegal((context != null ? 1 : 0) != 0);
        Shell shell = context.getContextVariable(Shell.class);
        List<SaveWizardManager.SaveWizardDescriptor> wizards = MindMapUIPlugin.getDefault().getSaveWizardManager().getWizards();
        if (wizards.isEmpty()) {
            MessageDialog.openWarning((Shell)shell, (String)"Save As", (String)"No 'Save As' options available in this application. Please contact the software provider for this issue.");
            return null;
        }
        wizards = new ArrayList<SaveWizardManager.SaveWizardDescriptor>(wizards);
        if (optionFilter != null) {
            Iterator<SaveWizardManager.SaveWizardDescriptor> locationProviderIt = wizards.iterator();
            while (locationProviderIt.hasNext()) {
                SaveWizardManager.SaveWizardDescriptor locationProvider = locationProviderIt.next();
                if (optionFilter.select((Object)locationProvider.getId())) continue;
                locationProviderIt.remove();
            }
        }
        SaveWorkbookAsHandler.sortLocationProviders(wizards);
        if (runner == null) {
            runner = new ProgressMonitorDialog(shell);
        }
        if ((oldName = workbookRef.getName()) == null) {
            IWorkbook workbook = workbookRef.getWorkbook();
            if (workbook != null) {
                oldName = workbook.getPrimarySheet().getRootTopic().getTitleText();
            }
            if (oldName == null) {
                oldName = MindMapMessages.SaveWorkbookAsHandler_oldName_default;
            }
        }
        while (true) {
            URI newURI;
            SaveWizardManager.SaveWizardDescriptor wizard;
            if (wizards.isEmpty()) {
                MessageDialog.openError((Shell)shell, (String)"Save As", (String)"No 'Save As' options available now for this workbook. Please contact the software provider for this issue.");
                return null;
            }
            SaveOptions options = SaveOptions.getDefault().proposalName(oldName).oldURI(workbookRef.getURI());
            if (onlyToLocal || wizards.size() == 1) {
                wizard = wizards.get(0);
            } else {
                SaveWizardDialog dialog;
                SaveWizardManager.SaveWizardDescriptor defaultWizard;
                String oldWizardId = workbookRef.getSaveWizardId();
                SaveWizardManager.SaveWizardDescriptor saveWizardDescriptor = defaultWizard = oldWizardId == null ? null : SaveWorkbookAsHandler.findSaveWizard(wizards, oldWizardId, false);
                if (defaultWizard == null) {
                    int maxPriority = 0;
                    for (SaveWizardManager.SaveWizardDescriptor wizardDescriptor : wizards) {
                        ISaveWizard wizard_0 = wizardDescriptor.getWizard();
                        if (wizard_0 == null) continue;
                        int priority = wizard_0.getPriorityFor(context, options);
                        if (priority > maxPriority) {
                            maxPriority = priority;
                            defaultWizard = wizardDescriptor;
                        }
                        if (priority >= 0) continue;
                        wizards.remove(wizardDescriptor);
                    }
                }
                if (defaultWizard == null) {
                    defaultWizard = wizards.get(0);
                }
                if ((dialog = new SaveWizardDialog(shell, wizards, defaultWizard, options)).open() != 0) {
                    return null;
                }
                wizard = dialog.getTargetWizard();
                options = dialog.getTargetOptions();
            }
            ISaveWizard wizardImpl = wizard.getWizard();
            Assert.isNotNull((Object)wizardImpl);
            try {
                newURI = wizardImpl.askForTargetURI(context, options);
            }
            catch (ISaveWizard.SaveWizardNotAvailable na) {
                wizards.remove(wizard);
                if (wizards.size() == 0) {
                    MessageDialog.openInformation((Shell)shell, (String)"No options", (String)na.getMessage());
                    return null;
                }
                String saveText = wizards.size() == 1 ? NLS.bind((String)MindMapMessages.SaveWorkbookAsHandler_saveToOtherDialog_saveTo_text, (Object)wizards.get(0).getName()) : MindMapMessages.SaveWorkbookAsHandler_saveToOtherDialog_saveToAnother_text;
                MessageDialog dialog = new MessageDialog(shell, MindMapMessages.SaveWorkbookAsHandler_saveToOtherDialog_title, null, na.getMessage(), 5, new String[]{saveText, IDialogConstants.CANCEL_LABEL}, 0);
                if (dialog.open() == 0) continue;
                return null;
            }
            if (newURI == null) {
                return null;
            }
            IWorkbookRefFactory workbookRefFactory = MindMapUIPlugin.getDefault().getWorkbookRefFactory();
            newWorkbookRef = workbookRefFactory.createWorkbookRef(newURI, null);
            Assert.isNotNull((Object)newWorkbookRef);
            if (!newWorkbookRef.isInState(1)) {
                MessageDialog.openWarning((Shell)shell, (String)MindMapMessages.SaveWorkbookAsHandler_warningDialog_title, (String)MindMapMessages.SaveWorkbookAsHandler_warningDialog_description);
                continue;
            }
            newWorkbookRef.setActiveContext(workbookRef.getActiveContext());
            if (newWorkbookRef.equals(workbookRef)) {
                if (!workbookRef.isInState(1)) {
                    try {
                        runner.run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                workbookRef.save(monitor);
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        return null;
                    }
                }
                return newWorkbookRef;
            }
            if (newWorkbookRef.canImportFrom(workbookRef)) break;
            MessageDialog.openError((Shell)shell, (String)MindMapMessages.SaveWorkbookAsHandler_saveAsDialog_title, (String)MindMapMessages.SaveWorkbookAsHandler_saveAsDialog_description);
            wizards.remove(wizard);
        }
        try {
            runner.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SaveWorkbookAsHandler.doSaveAs(monitor, workbookRef, newWorkbookRef, 0);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return newWorkbookRef;
    }

    private static void doSaveAs(IProgressMonitor monitor, IWorkbookRef oldWorkbookRef, IWorkbookRef newWorkbookRef, int times) {
        block28: {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                oldWorkbookRef.open((IProgressMonitor)subMonitor.newChild(15));
                newWorkbookRef.importFrom((IProgressMonitor)subMonitor.newChild(80), oldWorkbookRef);
            }
            catch (InvocationTargetException e) {
                CoreException coreEx = SaveWorkbookAsHandler.getCoreException(e);
                if (coreEx != null) {
                    int errType = coreEx.getType();
                    if (errType == 17) {
                        SaveWorkbookAsHandler.openDecryptionDialog(oldWorkbookRef, newWorkbookRef, monitor, MindMapMessages.MindMapEditor_passwordPrompt_message2, times);
                        subMonitor.setWorkRemaining(5);
                        try {
                            oldWorkbookRef.close((IProgressMonitor)subMonitor.newChild(5));
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                        catch (InterruptedException interruptedException) {}
                        return;
                    }
                    subMonitor.setWorkRemaining(5);
                    try {
                        oldWorkbookRef.close((IProgressMonitor)subMonitor.newChild(5));
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (InterruptedException interruptedException) {}
                    return;
                }
                subMonitor.setWorkRemaining(5);
                try {
                    oldWorkbookRef.close((IProgressMonitor)subMonitor.newChild(5));
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
                break block28;
            }
            catch (InterruptedException interruptedException) {
                try {}
                catch (Throwable throwable) {
                    subMonitor.setWorkRemaining(5);
                    try {
                        oldWorkbookRef.close((IProgressMonitor)subMonitor.newChild(5));
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (InterruptedException interruptedException2) {}
                    throw throwable;
                }
                subMonitor.setWorkRemaining(5);
                try {
                    oldWorkbookRef.close((IProgressMonitor)subMonitor.newChild(5));
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException3) {}
                return;
            }
            subMonitor.setWorkRemaining(5);
            try {
                oldWorkbookRef.close((IProgressMonitor)subMonitor.newChild(5));
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static CoreException getCoreException(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof CoreException) {
            return (CoreException)e;
        }
        return SaveWorkbookAsHandler.getCoreException(e.getCause());
    }

    private static void openDecryptionDialog(final IWorkbookRef oldWorkbookRef, final IWorkbookRef newWorkbookRef, final IProgressMonitor monitor, String message, final int times) {
        final int nextTime = times + 1;
        final IEncryptable encryptable = (IEncryptable)oldWorkbookRef.getAdapter(IEncryptable.class);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                new DecryptionDialog(Display.getDefault().getActiveShell(), oldWorkbookRef.getName(), encryptable.getPasswordHint(), times){

                    @Override
                    protected void okPressed() {
                        super.okPressed();
                        encryptable.setPassword(this.getPassword());
                        SaveWorkbookAsHandler.doSaveAs(monitor, oldWorkbookRef, newWorkbookRef, nextTime);
                    }

                    protected void cancelPressed() {
                        super.cancelPressed();
                    }
                }.open();
            }
        });
    }

    private static void sortLocationProviders(List<SaveWizardManager.SaveWizardDescriptor> list) {
        IPreferenceStore pref = MindMapUIPlugin.getDefault().getPreferenceStore();
        ArrayList<SaveWizardManager.SaveWizardDescriptor> preferredWizards = new ArrayList<SaveWizardManager.SaveWizardDescriptor>();
        ArrayList<SaveWizardManager.SaveWizardDescriptor> nameSortedWizards = new ArrayList<SaveWizardManager.SaveWizardDescriptor>();
        String[] preferredWizardIds = SaveWorkbookAsHandler.getPreferredSaveWizardIds(pref);
        if (preferredWizardIds != null) {
            String[] stringArray = preferredWizardIds;
            int n = preferredWizardIds.length;
            int n2 = 0;
            while (n2 < n) {
                String wizardId = stringArray[n2];
                SaveWizardManager.SaveWizardDescriptor wizard = SaveWorkbookAsHandler.findSaveWizard(list, wizardId, true);
                if (wizard != null) {
                    preferredWizards.add(wizard);
                }
                ++n2;
            }
        }
        nameSortedWizards.addAll(list);
        if (!nameSortedWizards.isEmpty()) {
            Collections.sort(nameSortedWizards, new Comparator<SaveWizardManager.SaveWizardDescriptor>(){

                @Override
                public int compare(SaveWizardManager.SaveWizardDescriptor w1, SaveWizardManager.SaveWizardDescriptor w2) {
                    return w1.getName().compareTo(w2.getName());
                }
            });
        }
        list.clear();
        list.addAll(preferredWizards);
        list.addAll(nameSortedWizards);
    }

    private static SaveWizardManager.SaveWizardDescriptor findSaveWizard(List<SaveWizardManager.SaveWizardDescriptor> list, String id, boolean remove) {
        Iterator<SaveWizardManager.SaveWizardDescriptor> it = list.iterator();
        while (it.hasNext()) {
            SaveWizardManager.SaveWizardDescriptor wizard = it.next();
            if (!id.equals(wizard.getId())) continue;
            if (remove) {
                it.remove();
            }
            return wizard;
        }
        return null;
    }

    private static String[] getPreferredSaveWizardIds(IPreferenceStore pref) {
        String preferredWizardIds = pref.getString("saveWizards");
        if (preferredWizardIds != null && !"".equals(preferredWizardIds)) {
            return preferredWizardIds.split(",");
        }
        return null;
    }
}

