/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import org.yccheok.jstock.engine.Observer;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.gui.trading.CreateOrderDlg;
import org.yccheok.jstock.trading.api.Instrument;
import org.yccheok.jstock.trading.api.OrderManager;
import org.yccheok.jstock.trading.engine.AjaxDriveWealthSearchEngineMonitor;

public class StocksComboBox
extends ComboBox {
    private final AjaxDriveWealthSearchEngineMonitor ajaxDriveWealthSearchEngineMonitor = new AjaxDriveWealthSearchEngineMonitor();
    private final ProgressIndicator pi = new ProgressIndicator();

    public ProgressIndicator getPi() {
        return this.pi;
    }

    public StocksComboBox() {
        this.pi.setPrefHeight(20.0);
        this.pi.setMaxHeight(20.0);
        this.pi.setVisible(false);
        this.setPrefWidth(230.0);
        this.setEditable(true);
        ObservableList observableList = FXCollections.observableArrayList();
        this.setItems(observableList);
        this.ajaxDriveWealthSearchEngineMonitor.attach(this.getDriveWealthMonitorObserver());
        this.getEditor().textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldVal, String newVal) {
                if (newVal != null) {
                    Object selected = StocksComboBox.this.getSelectionModel().getSelectedItem();
                    if (selected != null && newVal.equals(selected.toString())) {
                        return;
                    }
                    if (!newVal.isEmpty()) {
                        StocksComboBox.this.ajaxDriveWealthSearchEngineMonitor.clearAndPut(newVal);
                        StocksComboBox.this.showBusy(true);
                        StocksComboBox.this.hide();
                    } else {
                        StocksComboBox.this.clearList();
                    }
                }
            }
        });
        this.setCellFactory((Callback)new Callback<ListView<Instrument>, ListCell<Instrument>>(){

            public ListCell<Instrument> call(ListView<Instrument> p) {
                ListCell<Instrument> cell = new ListCell<Instrument>(){

                    protected void updateItem(Instrument item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty || item == null) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            Label symbol = new Label(item.symbol);
                            Label name = new Label(item.name);
                            symbol.setPrefWidth(60.0);
                            name.setPrefWidth(150.0);
                            HBox box = new HBox();
                            box.setSpacing(20.0);
                            box.getChildren().addAll((Object[])new Node[]{symbol, name});
                            this.setGraphic((Node)box);
                        }
                    }
                };
                cell.addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent ev) {
                        Instrument ins = (Instrument)StocksComboBox.this.getSelectionModel().getSelectedItem();
                        StocksComboBox.this.selectedShowBuyDlg(ins);
                        ev.consume();
                    }
                });
                return cell;
            }
        });
        this.addEventFilter(KeyEvent.KEY_RELEASED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ev) {
                if (ev.getCode() == KeyCode.ENTER) {
                    String string = StocksComboBox.this.getEditor().getText();
                    ObservableList list = StocksComboBox.this.getItems();
                    for (Instrument ins : list) {
                        if (!ins.symbol.equals(string)) continue;
                        Instrument in = (Instrument)StocksComboBox.this.getSelectionModel().getSelectedItem();
                        StocksComboBox.this.selectedShowBuyDlg(in);
                        ev.consume();
                        break;
                    }
                }
            }
        });
    }

    public void selectedShowBuyDlg(Instrument ins) {
        this.getEditor().clear();
        this.clearList();
        Platform.runLater(() -> {
            CreateOrderDlg dlg = new CreateOrderDlg(ins, OrderManager.OrderSide.BUY);
            dlg.initDlgAndWait();
        });
    }

    public void clearList() {
        this.hide();
        this.getItems().clear();
        this.showBusy(false);
    }

    public void showBusy(boolean show) {
        this.pi.setVisible(show);
    }

    private Observer<AjaxDriveWealthSearchEngineMonitor, Pair<String, List<Instrument>>> getDriveWealthMonitorObserver() {
        return new Observer<AjaxDriveWealthSearchEngineMonitor, Pair<String, List<Instrument>>>(){

            @Override
            public void update(AjaxDriveWealthSearchEngineMonitor subject, Pair<String, List<Instrument>> arg) {
                String query = (String)arg.first;
                List insList = (List)arg.second;
                String string = StocksComboBox.this.getEditor().getText().trim();
                if (string.isEmpty() || !string.equals(query)) {
                    return;
                }
                if (insList.isEmpty()) {
                    Platform.runLater(() -> StocksComboBox.this.clearList());
                    return;
                }
                Platform.runLater(() -> {
                    StocksComboBox.this.clearList();
                    for (Instrument ins : insList) {
                        StocksComboBox.this.getItems().add((Object)ins);
                    }
                    StocksComboBox.this.show();
                });
            }
        };
    }

    public void stop() {
        this.ajaxDriveWealthSearchEngineMonitor.stop();
    }
}

