/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.analysis;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jhotdraw.draw.AbstractAttributedFigure;
import org.jhotdraw.draw.AbstractConnector;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.ConnectorHandle;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GraphicalCompositeFigure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Layouter;
import org.jhotdraw.draw.ListFigure;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.draw.MoveHandle;
import org.jhotdraw.draw.RectangleFigure;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.draw.VerticalLayouter;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.Insets2D;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.yccheok.jstock.analysis.AbstractOperator;
import org.yccheok.jstock.analysis.Operator;
import org.yccheok.jstock.gui.InputConnector;
import org.yccheok.jstock.gui.OutputConnector;
import org.yccheok.jstock.gui.analysis.DependencyFigure;
import org.yccheok.jstock.gui.analysis.SeparatorLineFigure;

public abstract class OperatorFigure
extends GraphicalCompositeFigure
implements PropertyChangeListener {
    private LinkedList<AbstractConnector> connectors;
    private Operator operator;
    private static final Log log = LogFactory.getLog(OperatorFigure.class);

    protected OperatorFigure(Operator operator) {
        super((Figure)new RectangleFigure());
        this.operator = operator;
        ((AbstractOperator)this.operator).addPropertyChangeListener(this);
        this.setLayouter((Layouter)new VerticalLayouter());
        RectangleFigure nameCompartmentPF = new RectangleFigure();
        AttributeKeys.STROKE_COLOR.set((Figure)nameCompartmentPF, null);
        nameCompartmentPF.setAttributeEnabled(AttributeKeys.STROKE_COLOR, false);
        AttributeKeys.FILL_COLOR.set((Figure)nameCompartmentPF, null);
        nameCompartmentPF.setAttributeEnabled(AttributeKeys.FILL_COLOR, false);
        ListFigure nameCompartment = new ListFigure((Figure)nameCompartmentPF);
        ListFigure attributeCompartment = new ListFigure();
        SeparatorLineFigure separator1 = new SeparatorLineFigure();
        this.applyAttributes(this.getPresentationFigure());
        this.add((Figure)nameCompartment);
        this.add((Figure)separator1);
        this.add((Figure)attributeCompartment);
        Insets2D.Double insets = new Insets2D.Double(4.0, 8.0, 4.0, 8.0);
        LAYOUT_INSETS.set((Figure)nameCompartment, (Object)insets);
        LAYOUT_INSETS.set((Figure)attributeCompartment, (Object)insets);
        TextFigure nameFigure = new TextFigure();
        nameCompartment.add((Figure)nameFigure);
        AttributeKeys.FONT_BOLD.set((Figure)nameFigure, (Object)true);
        nameFigure.setEditable(false);
        nameFigure.setAttributeEnabled(AttributeKeys.FONT_BOLD, false);
        TextFigure durationFigure = new TextFigure();
        attributeCompartment.add((Figure)durationFigure);
        AttributeKeys.FONT_BOLD.set((Figure)durationFigure, (Object)true);
        durationFigure.setEditable(false);
        durationFigure.setText("0");
        durationFigure.setAttributeEnabled(AttributeKeys.FONT_BOLD, false);
        TextFigure startTimeFigure = new TextFigure();
        attributeCompartment.add((Figure)startTimeFigure);
        startTimeFigure.setEditable(false);
        startTimeFigure.setText("0");
        startTimeFigure.setAttributeEnabled(AttributeKeys.FONT_BOLD, false);
        this.applyAttributes((Figure)this);
        this.setAttributeEnabled(AttributeKeys.STROKE_DASHES, false);
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle((String)"org.yccheok.jstock.data.Labels");
        this.setName(labels.getString("operatorDefaultName"));
        this.createConnectors();
    }

    private void createConnectors() {
        int i;
        this.connectors = new LinkedList();
        Operator _operator = this.getOperator();
        int numOfInputConnector = _operator.getNumOfInputConnector();
        int numOfOutputConnector = _operator.getNumOfOutputConnector();
        double inputStep = 1.0 / (double)(numOfInputConnector << 1);
        double outputStep = 1.0 / (double)(numOfOutputConnector << 1);
        for (i = 0; i < numOfInputConnector; ++i) {
            this.connectors.add((AbstractConnector)new InputConnector((Figure)this, (Locator)new RelativeLocator(0.0, inputStep + inputStep * (double)i * 2.0), i));
        }
        for (i = 0; i < numOfOutputConnector; ++i) {
            this.connectors.add((AbstractConnector)new OutputConnector((Figure)this, (Locator)new RelativeLocator(1.0, outputStep + outputStep * (double)i * 2.0), i));
        }
    }

    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
            ConnectorHandle connectorHandle;
            Connector c;
            Class type;
            handles.add((Handle)new MoveHandle((Figure)this, RelativeLocator.northWest()));
            handles.add((Handle)new MoveHandle((Figure)this, RelativeLocator.northEast()));
            handles.add((Handle)new MoveHandle((Figure)this, RelativeLocator.southWest()));
            handles.add((Handle)new MoveHandle((Figure)this, RelativeLocator.southEast()));
            Operator _operator = this.getOperator();
            int numOfInputConnector = _operator.getNumOfInputConnector();
            int numOfOutputConnector = _operator.getNumOfOutputConnector();
            assert (numOfInputConnector + numOfOutputConnector == this.connectors.size());
            int connectorIndex = 0;
            int index = 0;
            while (index < numOfInputConnector) {
                type = _operator.getInputClass(index);
                c = (Connector)this.connectors.get(connectorIndex);
                connectorHandle = new ConnectorHandle(c, (ConnectionFigure)new DependencyFigure());
                connectorHandle.setToolTipText(type.getSimpleName());
                handles.add((Handle)connectorHandle);
                ++index;
                ++connectorIndex;
            }
            index = 0;
            while (index < numOfOutputConnector) {
                type = _operator.getOutputClass(index);
                c = (Connector)this.connectors.get(connectorIndex);
                connectorHandle = new ConnectorHandle(c, (ConnectionFigure)new DependencyFigure());
                connectorHandle.setToolTipText(type.getSimpleName());
                handles.add((Handle)connectorHandle);
                ++index;
                ++connectorIndex;
            }
        }
        return handles;
    }

    public void setName(String newValue) {
        this.getNameFigure().willChange();
        this.getNameFigure().setText(newValue);
        this.getNameFigure().changed();
    }

    public String getName() {
        return this.getNameFigure().getText();
    }

    public void setAttribute(String attribute) {
        this.getAttributeFigure().willChange();
        this.getAttributeFigure().setText(attribute);
        this.getAttributeFigure().changed();
    }

    public String getAttribute() {
        return this.getAttributeFigure().getText();
    }

    public void setValue(String value) {
        this.getValueFigure().willChange();
        this.getValueFigure().setText(value);
        this.getValueFigure().changed();
    }

    public String getValue() {
        return this.getValueFigure().getText();
    }

    public Connector findConnector(Point2D.Double p, ConnectionFigure figure) {
        double min = Double.MAX_VALUE;
        Connector closest = null;
        for (Connector connector : this.connectors) {
            Point2D.Double p2 = Geom.center((Rectangle2D.Double)connector.getBounds());
            double d = Geom.length2((double)p.x, (double)p.y, (double)p2.x, (double)p2.y);
            if (!(d < min)) continue;
            min = d;
            closest = connector;
        }
        return closest;
    }

    public Connector findCompatibleConnector(Connector c, boolean isStart) {
        return (Connector)this.connectors.getFirst();
    }

    private TextFigure getNameFigure() {
        return (TextFigure)((ListFigure)this.getChild(0)).getChild(0);
    }

    private TextFigure getAttributeFigure() {
        return (TextFigure)((ListFigure)this.getChild(2)).getChild(0);
    }

    private TextFigure getValueFigure() {
        return (TextFigure)((ListFigure)this.getChild(2)).getChild(1);
    }

    private void applyAttributes(Figure f) {
        Map attr = ((AbstractAttributedFigure)this.getPresentationFigure()).getAttributes();
        for (Map.Entry entry : attr.entrySet()) {
            f.setAttribute((AttributeKey)entry.getKey(), entry.getValue());
        }
    }

    public OperatorFigure clone() {
        throw new UnsupportedOperationException();
    }

    public void read(DOMInput in) throws IOException {
        double x = in.getAttribute("x", 0.0);
        double y = in.getAttribute("y", 0.0);
        double w = in.getAttribute("w", 0.0);
        double h = in.getAttribute("h", 0.0);
        this.setBounds(new Point2D.Double(x, y), new Point2D.Double(x + w, y + h));
        this.readAttributes(in);
        in.openElement("model");
        in.openElement("name");
        this.setName((String)in.readObject());
        in.closeElement();
        in.openElement("attribute");
        this.setAttribute((String)in.readObject());
        in.closeElement();
        in.openElement("value");
        this.setValue((String)in.readObject());
        in.closeElement();
        in.openElement("connectors");
        this.connectors.clear();
        int size = in.getElementCount();
        for (int i = 0; i < size; ++i) {
            AbstractConnector c = (AbstractConnector)in.readObject(i);
            this.connectors.add(c);
        }
        in.closeElement();
        in.closeElement();
    }

    public void write(DOMOutput out) throws IOException {
        Rectangle2D.Double r = this.getBounds();
        out.addAttribute("x", r.x);
        out.addAttribute("y", r.y);
        this.writeAttributes(out);
        out.openElement("model");
        out.openElement("name");
        out.writeObject((Object)this.getName());
        out.closeElement();
        out.openElement("attribute");
        out.writeObject((Object)this.getAttribute());
        out.closeElement();
        out.openElement("value");
        out.writeObject((Object)this.getValue());
        out.closeElement();
        out.openElement("connectors");
        for (AbstractConnector child : this.connectors) {
            out.writeObject((Object)child);
        }
        out.closeElement();
        out.closeElement();
    }

    public int getLayer() {
        return 0;
    }

    public String toString() {
        return "OperatorFigure#" + this.hashCode() + " " + this.getName() + " " + this.getAttribute() + " " + this.getValue();
    }

    public void addNotify(Drawing d) {
        super.addNotify(d);
        System.out.println(this + " addNotify");
    }

    public void removeNotify(Drawing d) {
        super.removeNotify(d);
        System.out.println(this + " removeNotify");
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("value")) {
            this.setValue("" + propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("attribute")) {
            this.setAttribute("" + propertyChangeEvent.getNewValue());
        } else {
            log.error((Object)("Unknown property change : " + propertyChangeEvent.getPropertyName()));
        }
    }
}

