/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;

public abstract class GenericListener {
    public static Object create(Class listenerInterface, String listenerMethodName, Object target, String targetMethodName) {
        Method listenerMethod = GenericListener.getListenerMethod(listenerInterface, listenerMethodName);
        Method targetMethod = GenericListener.getTargetMethod(target, targetMethodName, listenerMethod.getParameterTypes());
        if (targetMethod == null) {
            targetMethod = GenericListener.getTargetMethod(target, targetMethodName, new Class[0]);
        }
        if (targetMethod == null) {
            throw new RuntimeException("no such method " + targetMethodName + " in " + target.getClass());
        }
        return GenericListener.create(listenerMethod, target, targetMethod);
    }

    public static Object create(final Method listenerMethod, final Object target, final Method targetMethod) {
        DefaultInvoker handler = new DefaultInvoker(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (listenerMethod.equals(method)) {
                    if (targetMethod.getParameterTypes().length == 0) {
                        return targetMethod.invoke(target, new Object[0]);
                    }
                    return targetMethod.invoke(target, args);
                }
                return super.invoke(proxy, method, args);
            }
        };
        Class<?> cls = listenerMethod.getDeclaringClass();
        ClassLoader cl = cls.getClassLoader();
        return Proxy.newProxyInstance(cl, new Class[]{cls}, (InvocationHandler)handler);
    }

    private static Method getListenerMethod(Class listenerInterface, String listenerMethodName) {
        Method[] m = listenerInterface.getMethods();
        Method result = null;
        for (int i = 0; i < m.length; ++i) {
            if (!listenerMethodName.equals(m[i].getName())) continue;
            if (result != null) {
                throw new RuntimeException("ambiguous method: " + m[i] + " vs. " + result);
            }
            result = m[i];
        }
        if (result == null) {
            throw new RuntimeException("no such method " + listenerMethodName + " in " + listenerInterface);
        }
        return result;
    }

    private static Method getTargetMethod(Object target, String targetMethodName, Class[] parameterTypes) {
        Method[] m = target.getClass().getMethods();
        Method result = null;
        block0: for (int i = 0; i < m.length; ++i) {
            Class<?>[] p;
            if (!targetMethodName.equals(m[i].getName()) || (p = m[i].getParameterTypes()).length != parameterTypes.length) continue;
            for (int j = 0; j < p.length; ++j) {
                if (!p[j].isAssignableFrom(parameterTypes[j])) continue block0;
            }
            if (result != null) {
                throw new RuntimeException("ambiguous method: " + m[i] + " vs. " + result);
            }
            result = m[i];
        }
        if (result == null) {
            return null;
        }
        Method publicResult = GenericListener.raiseToPublicClass(result);
        if (publicResult != null) {
            result = publicResult;
        }
        return result;
    }

    private static Method raiseToPublicClass(Method m) {
        Method sm;
        Class<?> c = m.getDeclaringClass();
        if (Modifier.isPublic(m.getModifiers()) && Modifier.isPublic(c.getModifiers())) {
            return m;
        }
        Class<?> sc = c.getSuperclass();
        if (sc != null && (sm = GenericListener.raiseToPublicClass(m, sc)) != null) {
            return sm;
        }
        Class<?>[] ints = c.getInterfaces();
        for (int i = 0; i < ints.length; ++i) {
            Method im = GenericListener.raiseToPublicClass(m, ints[i]);
            if (im == null) continue;
            return im;
        }
        return null;
    }

    private static Method raiseToPublicClass(Method m, Class c) {
        try {
            Method sm = c.getMethod(m.getName(), m.getParameterTypes());
            return GenericListener.raiseToPublicClass(sm);
        }
        catch (NoSuchMethodException ee) {
            return null;
        }
    }

    private GenericListener() {
    }

    private static class DefaultInvoker
    implements InvocationHandler {
        private static final Character char_0 = new Character('\u0000');
        private static final Byte byte_0 = new Byte(0);

        private DefaultInvoker() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                String methodName = method.getName();
                if (methodName.equals("hashCode")) {
                    return this.proxyHashCode(proxy);
                }
                if (methodName.equals("equals")) {
                    return this.proxyEquals(proxy, args[0]);
                }
                if (methodName.equals("toString")) {
                    return this.proxyToString(proxy);
                }
            }
            return DefaultInvoker.nullValueOf(method.getReturnType());
        }

        protected Integer proxyHashCode(Object proxy) {
            return new Integer(System.identityHashCode(proxy));
        }

        protected Boolean proxyEquals(Object proxy, Object other) {
            return proxy == other ? Boolean.TRUE : Boolean.FALSE;
        }

        protected String proxyToString(Object proxy) {
            return proxy.getClass().getName() + '@' + Integer.toHexString(proxy.hashCode());
        }

        private static final Object nullValueOf(Class rt) {
            if (!rt.isPrimitive()) {
                return null;
            }
            if (rt == Void.TYPE) {
                return null;
            }
            if (rt == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (rt == Character.TYPE) {
                return char_0;
            }
            return byte_0;
        }
    }
}

