/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.BezierControlPointHandle;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.draw.Liner;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.util.ResourceBundleUtil;

public abstract class AbstractConnectionHandle
extends AbstractHandle {
    private Connector savedTarget;
    private Connector connectableConnector;
    private Figure connectableFigure;
    private Point start;
    private Liner savedLiner;
    protected Collection<Connector> connectors = Collections.emptyList();

    protected AbstractConnectionHandle(ConnectionFigure owner) {
        super(owner);
    }

    @Override
    public ConnectionFigure getOwner() {
        return (ConnectionFigure)super.getOwner();
    }

    @Override
    public boolean isCombinableWith(Handle handle) {
        return false;
    }

    protected abstract Connector getTarget();

    protected abstract void disconnect();

    protected abstract void connect(Connector var1);

    protected abstract void setLocation(Point2D.Double var1);

    protected abstract Point2D.Double getLocation();

    protected Connector getSource() {
        if (this.getTarget() == this.getOwner().getStartConnector()) {
            return this.getOwner().getEndConnector();
        }
        return this.getOwner().getStartConnector();
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
        this.savedTarget = this.getTarget();
        this.start = anchor;
        this.savedLiner = this.getOwner().getLiner();
        this.getOwner().setLiner(null);
        this.fireHandleRequestSecondaryHandles();
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        Connector aTarget;
        Point2D.Double p = this.view.viewToDrawing(lead);
        this.view.getConstrainer().constrainPoint(p);
        this.connectableFigure = this.findConnectableFigure(p, this.view.getDrawing());
        if (this.connectableFigure != null && (aTarget = this.findConnectionTarget(p, this.view.getDrawing())) != null) {
            p = aTarget.getAnchor();
        }
        this.getOwner().willChange();
        this.setLocation(p);
        this.getOwner().changed();
        this.repaintConnectors();
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        ConnectionFigure f = this.getOwner();
        if ((modifiersEx & 0x3C0) != 0 && (modifiersEx & 0x800) == 0) {
            f.willChange();
            int index = this.getBezierNodeIndex();
            BezierPath.Node v = f.getNode(index);
            v.mask = index > 0 && index < f.getNodeCount() ? (v.mask + 3) % 4 : (index == 0 ? ((v.mask & 2) == 0 ? 2 : 0) : ((v.mask & 1) == 0 ? 1 : 0));
            f.setNode(index, v);
            f.changed();
            this.fireHandleRequestSecondaryHandles();
        }
        Point2D.Double p = this.view.viewToDrawing(lead);
        this.view.getConstrainer().constrainPoint(p);
        Connector target = this.findConnectionTarget(p, this.view.getDrawing());
        if (target == null) {
            target = this.savedTarget;
        }
        this.setLocation(p);
        if (target != this.savedTarget) {
            this.disconnect();
            this.connect(target);
        }
        this.getOwner().setLiner(this.savedLiner);
        this.getOwner().updateConnection();
        this.connectableConnector = null;
        this.connectors = Collections.emptyList();
    }

    private Connector findConnectionTarget(Point2D.Double p, Drawing drawing) {
        Figure targetFigure = this.findConnectableFigure(p, drawing);
        if (this.getSource() == null && targetFigure != null) {
            return this.findConnector(p, targetFigure, this.getOwner());
        }
        if (targetFigure != null) {
            Connector target = this.findConnector(p, targetFigure, this.getOwner());
            if (targetFigure != null && targetFigure.canConnect() && targetFigure != this.savedTarget && !targetFigure.includes(this.getOwner()) && this.canConnect(this.getSource(), target)) {
                return target;
            }
        }
        return null;
    }

    protected abstract boolean canConnect(Connector var1, Connector var2);

    protected Connector findConnector(Point2D.Double p, Figure f, ConnectionFigure prototype) {
        return f.findConnector(p, prototype);
    }

    @Override
    public void draw(Graphics2D g) {
        Graphics2D gg = (Graphics2D)g.create();
        gg.transform(this.view.getDrawingToViewTransform());
        for (Connector c : this.connectors) {
            c.draw(gg);
        }
        gg.dispose();
        if (this.getTarget() == null) {
            this.drawCircle(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.DISCONNECTED_CONNECTION_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.DISCONNECTED_CONNECTION_HANDLE_STROKE_COLOR));
        } else {
            this.drawCircle(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.CONNECTED_CONNECTION_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.CONNECTED_CONNECTION_HANDLE_STROKE_COLOR));
        }
    }

    private Figure findConnectableFigure(Point2D.Double p, Drawing drawing) {
        for (Figure f : drawing.getFiguresFrontToBack()) {
            if (f.includes(this.getOwner()) || !f.canConnect() || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    protected void setPotentialTarget(Connector newTarget) {
        this.connectableConnector = newTarget;
    }

    @Override
    protected Rectangle basicGetBounds() {
        Point center = this.view.drawingToView(this.getLocation());
        return new Rectangle(center.x - this.getHandlesize() / 2, center.y - this.getHandlesize() / 2, this.getHandlesize(), this.getHandlesize());
    }

    protected BezierFigure getBezierFigure() {
        return (BezierFigure)((Object)this.getOwner());
    }

    protected abstract int getBezierNodeIndex();

    @Override
    public final Collection<Handle> createSecondaryHandles() {
        LinkedList<Handle> list = new LinkedList<Handle>();
        if (this.getOwner().getLiner() == null && this.savedLiner == null) {
            int i;
            int index = this.getBezierNodeIndex();
            BezierFigure f = this.getBezierFigure();
            BezierPath.Node v = f.getNode(index);
            if ((v.mask & 1) != 0 && (index != 0 || f.isClosed())) {
                list.add(new BezierControlPointHandle(f, index, 1));
            }
            if ((v.mask & 2) != 0 && (index < f.getNodeCount() - 1 || f.isClosed())) {
                list.add(new BezierControlPointHandle(f, index, 2));
            }
            if (index > 0 || f.isClosed()) {
                i = index == 0 ? f.getNodeCount() - 1 : index - 1;
                v = f.getNode(i);
                if ((v.mask & 2) != 0) {
                    list.add(new BezierControlPointHandle(f, i, 2));
                }
            }
            if (index < f.getNodeCount() - 2 || f.isClosed()) {
                i = index == f.getNodeCount() - 1 ? 0 : index + 1;
                v = f.getNode(i);
                if ((v.mask & 1) != 0) {
                    list.add(new BezierControlPointHandle(f, i, 1));
                }
            }
        }
        return list;
    }

    protected BezierPath.Node getBezierNode() {
        int index = this.getBezierNodeIndex();
        return this.getBezierFigure().getNodeCount() > index ? this.getBezierFigure().getNode(index) : null;
    }

    @Override
    public String getToolTipText(Point p) {
        ConnectionFigure f = this.getOwner();
        if (f.getLiner() == null && this.savedLiner == null) {
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            BezierPath.Node node = this.getBezierNode();
            return node == null ? null : labels.getFormatted("handle.bezierNode.toolTipText", labels.getFormatted(node.getMask() == 0 ? "bezierNode.linearNode" : (node.getMask() == 3 ? "bezierNode.cubicNode" : "bezierNode.quadraticNode"), new Object[0]));
        }
        return null;
    }

    public void repaintConnectors() {
        Rectangle2D.Double invalidArea = null;
        for (Connector c : this.connectors) {
            if (invalidArea == null) {
                invalidArea = c.getDrawingArea();
                continue;
            }
            invalidArea.add(c.getDrawingArea());
        }
        this.connectors = this.connectableFigure == null ? new LinkedList<Connector>() : this.connectableFigure.getConnectors(this.getOwner());
        for (Connector c : this.connectors) {
            if (invalidArea == null) {
                invalidArea = c.getDrawingArea();
                continue;
            }
            invalidArea.add(c.getDrawingArea());
        }
        if (invalidArea != null) {
            this.view.getComponent().repaint(this.view.drawingToView(invalidArea));
        }
    }
}

