/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import org.jhotdraw.color.AbstractColorSystem;

public class HSVRYBColorSystem
extends AbstractColorSystem {
    @Override
    public int toRGB(float ... components) {
        float blue;
        float green;
        float red;
        float f;
        int hi;
        float hue = components[0];
        float saturation = components[1];
        float value = components[2];
        if ((hue -= (float)Math.floor(hue)) < 0.0f) {
            hue -= 1.0f;
        }
        if (saturation > 1.0f) {
            saturation = 1.0f;
        } else if (saturation < 0.0f) {
            saturation = 0.0f;
        }
        if (value > 1.0f) {
            value = 1.0f;
        } else if (value < 0.0f) {
            value = 0.0f;
        }
        float hueDeg = hue * 360.0f;
        if (hueDeg < 120.0f) {
            hi = 0;
            f = hueDeg / 120.0f;
        } else if (hueDeg < 160.0f) {
            hi = 1;
            f = (hueDeg - 120.0f) / 40.0f;
        } else if (hueDeg < 220.0f) {
            hi = 2;
            f = (hueDeg - 160.0f) / 60.0f;
        } else if (hueDeg < 280.0f) {
            hi = 3;
            f = (hueDeg - 220.0f) / 60.0f;
        } else if (hueDeg < 340.0f) {
            hi = 4;
            f = (hueDeg - 280.0f) / 60.0f;
        } else {
            f = (hueDeg - 340.0f) / 20.0f;
            hi = 5;
        }
        float p = value * (1.0f - saturation);
        float q = value * (1.0f - f * saturation);
        float t = value * (1.0f - (1.0f - f) * saturation);
        switch (hi) {
            case 0: {
                red = value;
                green = t;
                blue = p;
                break;
            }
            case 1: {
                red = q;
                green = value;
                blue = p;
                break;
            }
            case 2: {
                red = p;
                green = value;
                blue = t;
                break;
            }
            case -3: 
            case 3: {
                red = p;
                green = q;
                blue = value;
                break;
            }
            case -2: 
            case 4: {
                red = t;
                green = p;
                blue = value;
                break;
            }
            case -1: 
            case 5: {
                red = value;
                green = p;
                blue = q;
                break;
            }
            default: {
                blue = 0.0f;
                green = 0.0f;
                red = 0.0f;
            }
        }
        int rgb = (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f);
        return rgb;
    }

    @Override
    public float[] toComponents(int red, int green, int blue, float[] components) {
        float min;
        if (components == null || components.length != 3) {
            components = new float[3];
        }
        float r = (float)(red & 0xFF) / 255.0f;
        float g = (float)(green & 0xFF) / 255.0f;
        float b = (float)(blue & 0xFF) / 255.0f;
        float max = Math.max(Math.max(r, g), b);
        float hue = max == (min = Math.min(Math.min(r, g), b)) ? 0.0f : (max == r && g >= b ? 120.0f * (g - b) / (max - min) : (max == r ? 20.0f * (g - b) / (max - min) + 360.0f : (max == g && r >= b ? 40.0f * (b - r) / (max - min) + 120.0f + 40.0f : (max == g ? 60.0f * (b - r) / (max - min) + 120.0f + 40.0f : (g >= r ? 60.0f * (r - g) / (max - min) + 240.0f + 40.0f : 60.0f * (r - g) / (max - min) + 240.0f + 40.0f)))));
        float value = max;
        float saturation = max == 0.0f ? 0.0f : (max - min) / max;
        components[0] = hue / 360.0f;
        components[1] = saturation;
        components[2] = value;
        return components;
    }

    @Override
    public int getComponentCount() {
        return 3;
    }
}

