/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractApplicationAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.util.ResourceBundleUtil;

public class ExitAction
extends AbstractApplicationAction {
    public static final String ID = "application.exit";
    private Component oldFocusOwner;
    private View unsavedView;

    public ExitAction(Application app) {
        super(app);
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        final Application app = this.getApplication();
        if (app.isEnabled()) {
            app.setEnabled(false);
            int unsavedViewsCount = 0;
            View documentToBeReviewed = null;
            for (View p : app.views()) {
                if (!p.hasUnsavedChanges()) continue;
                if (p.isEnabled()) {
                    documentToBeReviewed = p;
                }
                ++unsavedViewsCount;
            }
            if (unsavedViewsCount > 0 && documentToBeReviewed == null) {
                app.setEnabled(true);
                return;
            }
            switch (unsavedViewsCount) {
                case 0: {
                    this.doExit();
                    break;
                }
                case 1: {
                    this.unsavedView = documentToBeReviewed;
                    this.oldFocusOwner = SwingUtilities.getWindowAncestor(this.unsavedView.getComponent()).getFocusOwner();
                    this.unsavedView.setEnabled(false);
                    JOptionPane pane = new JOptionPane("<html>" + UIManager.getString("OptionPane.css") + "<b>Do you want to save changes to this document " + "before exiting?</b><p>" + "If you don't save, your changes will be lost.", 2);
                    Object[] options = new Object[]{"Save", "Cancel", "Don't Save"};
                    pane.setOptions(options);
                    pane.setInitialValue(options[0]);
                    pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
                    JSheet.showSheet(pane, this.unsavedView.getComponent(), new SheetListener(){

                        @Override
                        public void optionSelected(SheetEvent evt) {
                            Object value = evt.getValue();
                            if (value == null || value.equals("Cancel")) {
                                ExitAction.this.unsavedView.setEnabled(true);
                                app.setEnabled(true);
                            } else if (value.equals("Don't Save")) {
                                ExitAction.this.doExit();
                                ExitAction.this.unsavedView.setEnabled(true);
                            } else if (value.equals("Save")) {
                                ExitAction.this.saveChanges();
                            }
                        }
                    });
                    break;
                }
                default: {
                    JOptionPane pane = new JOptionPane("<html>" + UIManager.get("OptionPane.css") + "<b>You have " + unsavedViewsCount + " documents with unsaved changes. " + "Do you want to " + "review these changes before quitting?</b><p>" + "If you don't review your documents, " + "all your changes will be lost.", 3);
                    Object[] options = new Object[]{"Review Changes", "Cancel", "Discard Changes"};
                    pane.setOptions(options);
                    pane.setInitialValue(options[0]);
                    pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
                    JDialog dialog = pane.createDialog(app.getComponent(), null);
                    dialog.setVisible(true);
                    Object value = pane.getValue();
                    if (value == null || value.equals("Cancel")) {
                        app.setEnabled(true);
                        break;
                    }
                    if (value.equals("Discard Changes")) {
                        this.doExit();
                        app.setEnabled(true);
                        break;
                    }
                    if (!value.equals("Review Changes")) break;
                    this.unsavedView = documentToBeReviewed;
                    this.reviewChanges();
                }
            }
        }
    }

    protected void saveChanges() {
        if (this.unsavedView.getFile() == null) {
            JFileChooser fileChooser = this.unsavedView.getSaveChooser();
            JSheet.showSaveSheet(fileChooser, this.unsavedView.getComponent(), new SheetListener(){

                @Override
                public void optionSelected(SheetEvent evt) {
                    if (evt.getOption() == 0) {
                        File file = evt.getFileChooser().getSelectedFile();
                        ExitAction.this.saveToFile(file);
                    } else {
                        ExitAction.this.unsavedView.setEnabled(true);
                        if (ExitAction.this.oldFocusOwner != null) {
                            ExitAction.this.oldFocusOwner.requestFocus();
                        }
                        ExitAction.this.getApplication().setEnabled(true);
                    }
                }
            });
        } else {
            this.saveToFile(this.unsavedView.getFile());
        }
    }

    protected void reviewChanges() {
        if (this.unsavedView.isEnabled()) {
            this.oldFocusOwner = SwingUtilities.getWindowAncestor(this.unsavedView.getComponent()).getFocusOwner();
            this.unsavedView.setEnabled(false);
            JOptionPane pane = new JOptionPane("<html>" + UIManager.getString("OptionPane.css") + "<b>Do you want to save changes to this document " + "before exiting?</b><p>" + "If you don't save, your changes will be lost.", 2);
            Object[] options = new Object[]{"Save", "Cancel", "Don't Save"};
            pane.setOptions(options);
            pane.setInitialValue(options[0]);
            pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
            JSheet.showSheet(pane, this.unsavedView.getComponent(), new SheetListener(){

                @Override
                public void optionSelected(SheetEvent evt) {
                    Object value = evt.getValue();
                    if (value == null || value.equals("Cancel")) {
                        ExitAction.this.unsavedView.setEnabled(true);
                        ExitAction.this.getApplication().setEnabled(true);
                    } else if (value.equals("Don't Save")) {
                        ExitAction.this.getApplication().dispose(ExitAction.this.unsavedView);
                        ExitAction.this.reviewNext();
                    } else if (value.equals("Save")) {
                        ExitAction.this.saveChangesAndReviewNext();
                    }
                }
            });
        } else {
            this.getApplication().setEnabled(true);
            System.out.println("review silently aborted");
        }
    }

    protected void saveChangesAndReviewNext() {
        if (this.unsavedView.getFile() == null) {
            JFileChooser fileChooser = this.unsavedView.getSaveChooser();
            JSheet.showSaveSheet(fileChooser, this.unsavedView.getComponent(), new SheetListener(){

                @Override
                public void optionSelected(SheetEvent evt) {
                    if (evt.getOption() == 0) {
                        File file = evt.getFileChooser().getSelectedFile();
                        ExitAction.this.saveToFileAndReviewNext(file);
                    } else {
                        ExitAction.this.unsavedView.setEnabled(true);
                        if (ExitAction.this.oldFocusOwner != null) {
                            ExitAction.this.oldFocusOwner.requestFocus();
                        }
                        ExitAction.this.getApplication().setEnabled(true);
                    }
                }
            });
        } else {
            this.saveToFileAndReviewNext(this.unsavedView.getFile());
        }
    }

    protected void reviewNext() {
        int unsavedViewsCount = 0;
        View documentToBeReviewed = null;
        for (View p : this.getApplication().views()) {
            if (!p.hasUnsavedChanges()) continue;
            if (p.isEnabled()) {
                documentToBeReviewed = p;
            }
            ++unsavedViewsCount;
        }
        if (unsavedViewsCount == 0) {
            this.doExit();
        } else if (documentToBeReviewed != null) {
            this.unsavedView = documentToBeReviewed;
            this.reviewChanges();
        } else {
            this.getApplication().setEnabled(true);
        }
    }

    protected void saveToFile(final File file) {
        this.unsavedView.execute(new Worker(){

            @Override
            public Object construct() {
                try {
                    ExitAction.this.unsavedView.write(file);
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            @Override
            public void finished(Object value) {
                ExitAction.this.fileSaved(ExitAction.this.unsavedView, file, value);
            }
        });
    }

    protected void saveToFileAndReviewNext(final File file) {
        this.unsavedView.execute(new Worker(){

            @Override
            public Object construct() {
                try {
                    ExitAction.this.unsavedView.write(file);
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            @Override
            public void finished(Object value) {
                ExitAction.this.fileSavedAndReviewNext(ExitAction.this.unsavedView, file, value);
            }
        });
    }

    protected void fileSaved(View unsavedView, File file, Object value) {
        if (value == null) {
            unsavedView.setFile(file);
            this.doExit();
        } else {
            JSheet.showMessageSheet((Component)unsavedView.getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + "<b>Couldn't save to the file \"" + file + "\".<p>" + "Reason: " + value), 0);
        }
        unsavedView.setEnabled(true);
        if (this.oldFocusOwner != null) {
            this.oldFocusOwner.requestFocus();
        }
        this.getApplication().setEnabled(true);
    }

    protected void fileSavedAndReviewNext(View unsavedView, File file, Object value) {
        if (value == null) {
            unsavedView.setFile(file);
            this.getApplication().dispose(unsavedView);
            this.reviewNext();
            return;
        }
        JSheet.showMessageSheet((Component)unsavedView.getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + "<b>Couldn't save to the file \"" + file + "\".<p>" + "Reason: " + value), 0);
        unsavedView.setEnabled(true);
        if (this.oldFocusOwner != null) {
            this.oldFocusOwner.requestFocus();
        }
        this.getApplication().setEnabled(true);
    }

    protected void doExit() {
        this.getApplication().stop();
        System.exit(0);
    }
}

