/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.directory;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.guacamole.GuacamoleClientException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceNotFoundException;
import org.apache.guacamole.GuacamoleUnsupportedException;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.Identifiable;
import org.apache.guacamole.net.auth.Permissions;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.permission.SystemPermission;
import org.apache.guacamole.net.auth.permission.SystemPermissionSet;
import org.apache.guacamole.rest.APIPatch;
import org.apache.guacamole.rest.PATCH;
import org.apache.guacamole.rest.directory.DirectoryObjectResource;
import org.apache.guacamole.rest.directory.DirectoryObjectResourceFactory;
import org.apache.guacamole.rest.directory.DirectoryObjectTranslator;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public abstract class DirectoryResource<InternalType extends Identifiable, ExternalType> {
    private final UserContext userContext;
    private final Directory<InternalType> directory;
    private final DirectoryObjectTranslator<InternalType, ExternalType> translator;
    private final DirectoryObjectResourceFactory<InternalType, ExternalType> resourceFactory;

    public DirectoryResource(UserContext userContext, Directory<InternalType> directory, DirectoryObjectTranslator<InternalType, ExternalType> translator, DirectoryObjectResourceFactory<InternalType, ExternalType> resourceFactory) {
        this.userContext = userContext;
        this.directory = directory;
        this.translator = translator;
        this.resourceFactory = resourceFactory;
    }

    protected abstract ObjectPermissionSet getObjectPermissions(Permissions var1) throws GuacamoleException;

    @GET
    public Map<String, ExternalType> getObjects(@QueryParam(value="permission") List<ObjectPermission.Type> permissions) throws GuacamoleException {
        Permissions effective = this.userContext.self().getEffectivePermissions();
        SystemPermissionSet systemPermissions = effective.getSystemPermissions();
        boolean isAdmin = systemPermissions.hasPermission(SystemPermission.Type.ADMINISTER);
        Collection identifiers = this.directory.getIdentifiers();
        if (!isAdmin && permissions != null && !permissions.isEmpty()) {
            ObjectPermissionSet objectPermissions = this.getObjectPermissions(effective);
            identifiers = objectPermissions.getAccessibleObjects(permissions, identifiers);
        }
        HashMap<String, Object> apiObjects = new HashMap<String, Object>();
        for (Identifiable object : this.directory.getAll(identifiers)) {
            apiObjects.put(object.getIdentifier(), this.translator.toExternalObject(object));
        }
        return apiObjects;
    }

    @PATCH
    public void patchObjects(List<APIPatch<String>> patches) throws GuacamoleException {
        for (APIPatch<String> patch : patches) {
            if (patch.getOp() != APIPatch.Operation.remove) {
                throw new GuacamoleUnsupportedException("Only the \"remove\" operation is supported.");
            }
            String path = patch.getPath();
            if (!path.startsWith("/")) {
                throw new GuacamoleClientException("Patch paths must start with \"/\".");
            }
            this.directory.remove(path.substring(1));
        }
    }

    @POST
    public ExternalType createObject(ExternalType object) throws GuacamoleException {
        if (object == null) {
            throw new GuacamoleClientException("Data must be submitted when creating objects.");
        }
        this.translator.filterExternalObject(this.userContext, object);
        this.directory.add(this.translator.toInternalObject(object));
        return object;
    }

    @Path(value="{identifier}")
    public DirectoryObjectResource<InternalType, ExternalType> getObjectResource(@PathParam(value="identifier") String identifier) throws GuacamoleException {
        Identifiable object = this.directory.get(identifier);
        if (object == null) {
            throw new GuacamoleResourceNotFoundException("Not found: \"" + identifier + "\"");
        }
        return this.resourceFactory.create(this.userContext, this.directory, object);
    }
}

