/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TeeInputStream
extends FilterInputStream {
    private final OutputStream delegate;
    private boolean closeDelegate;

    public TeeInputStream(InputStream in, OutputStream delegate, boolean closeDelegate) {
        super(in);
        this.delegate = delegate;
        this.closeDelegate = closeDelegate;
    }

    @Override
    public int read() throws IOException {
        int ch = super.read();
        if (ch != -1) {
            this.delegate.write(ch);
        }
        return ch;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if ((len = super.read(b, off, len)) > 0) {
            this.delegate.write(b, off, len);
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.closeDelegate) {
                this.delegate.close();
            }
        }
    }
}

