/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing;

import cz.vity.freerapid.core.application.SubmitErrorReporter;
import cz.vity.freerapid.gui.dialogs.ErrorDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceManager;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;

public class Swinger {
    private static final Logger logger = Logger.getLogger(Swinger.class.getName());
    private static final String MESSAGE_ERROR_TITLE_CODE = "errorMessage";
    private static final String MESSAGE_CONFIRM_TITLE_CODE = "confirmMessage";
    private static final String MESSAGE_INFORMATION_TITLE_CODE = "informationMessage";
    private static final String MESSAGE_BTN_YES_CODE = "message.button.yes";
    private static final String MESSAGE_BTN_NO_CODE = "message.button.no";
    private static final String MESSAGE_BTN_OK_CODE = "message.button.ok";
    public static final String MESSAGE_BTN_CANCEL_CODE = "message.button.cancel";
    public static final int RESULT_NO = 1;
    public static final int RESULT_YES = 0;
    public static final int RESULT_CANCEL = 1;
    public static final int RESULT_OK = 0;

    private Swinger() {
    }

    public static void initActions(Object actionsObject, ApplicationContext context) {
        ApplicationActionMap globalMap = context.getActionMap();
        ApplicationActionMap actionMap = context.getActionMap(actionsObject);
        for (Object key : actionMap.keys()) {
            globalMap.put(key, actionMap.get(key));
        }
    }

    public static void showInformationDialog(String message) {
        JOptionPane.showMessageDialog(Swinger.getActiveWindowComponent(), message, Swinger.getResourceMap().getString(MESSAGE_INFORMATION_TITLE_CODE, new Object[0]), 1);
    }

    public static int getChoiceYesNoCancel(String message) {
        ResourceMap map = Swinger.getResourceMap();
        return JOptionPane.showOptionDialog(Swinger.getActiveWindowComponent(), message, map.getString(MESSAGE_CONFIRM_TITLE_CODE, new Object[0]), 0, 3, null, new Object[]{map.getString(MESSAGE_BTN_YES_CODE, new Object[0]), map.getString(MESSAGE_BTN_NO_CODE, new Object[0]), map.getString(MESSAGE_BTN_CANCEL_CODE, new Object[0])}, map.getString(MESSAGE_BTN_YES_CODE, new Object[0]));
    }

    public static int getChoiceYesNoCancel(String messageCode, Object ... args) {
        ResourceMap map = Swinger.getResourceMap();
        return Swinger.getChoiceYesNoCancel(map.getString(messageCode, args));
    }

    public static int getChoiceOKCancel(String messageCode, Object ... args) {
        ResourceMap map = Swinger.getResourceMap();
        return JOptionPane.showOptionDialog(Swinger.getActiveWindowComponent(), map.getString(messageCode, args), map.getString(MESSAGE_CONFIRM_TITLE_CODE, new Object[0]), 2, 3, null, new Object[]{map.getString(MESSAGE_BTN_OK_CODE, new Object[0]), map.getString(MESSAGE_BTN_CANCEL_CODE, new Object[0])}, map.getString(MESSAGE_BTN_OK_CODE, new Object[0]));
    }

    public static ImageIcon getIconImage(String imagePropertyCode) {
        ResourceMap map = Swinger.getResourceMap();
        return Swinger.getIconImage(map, imagePropertyCode);
    }

    public static ImageIcon getIconImage(ResourceMap map, String imagePropertyCode) {
        ImageIcon imageIcon = map.getImageIcon(imagePropertyCode);
        if (imageIcon == null) {
            logger.warning("Invalid image property code:" + imagePropertyCode);
        }
        return imageIcon;
    }

    public static ResourceMap getResourceMap() {
        return Swinger.getContext().getResourceManager().getResourceMap();
    }

    public static ResourceMap getResourceMap(Class className) {
        ResourceManager rm = Swinger.getContext().getResourceManager();
        return rm.getResourceMap(className);
    }

    public static ResourceMap getResourceMap(Class className, Class stopClass) {
        ResourceManager rm = Swinger.getContext().getResourceManager();
        return rm.getResourceMap(className, stopClass);
    }

    public static Action getAction(Object actionName) {
        Action action = Swinger.getContext().getActionMap().get(actionName);
        if (action == null) {
            throw new IllegalStateException("Action with a name \"" + actionName + "\" does not exist.");
        }
        return action;
    }

    public static ActionMap getActionMap(Class aClass, Object actionsObject) {
        return Swinger.getContext().getActionMap(aClass, actionsObject);
    }

    public static String[] getList(ResourceMap resourceMap, String key, int valueCount) {
        String[] list = new String[valueCount];
        for (int i = 0; i < valueCount; ++i) {
            list[i] = resourceMap.getString(key + "_" + i, new Object[0]);
        }
        return list;
    }

    private static ApplicationContext getContext() {
        return Application.getInstance().getContext();
    }

    public static ActionMap getActionMap(Object actionsObject) {
        return Swinger.getContext().getActionMap(actionsObject);
    }

    public static void showErrorMessage(ResourceMap map, String message, Object ... args) {
        JOptionPane.showMessageDialog(Swinger.getActiveWindowComponent(), map.containsKey(message) ? map.getString(message, args) : message, Swinger.getResourceMap().getString(MESSAGE_ERROR_TITLE_CODE, new Object[0]), 0);
    }

    public static void showErrorMessage(ResourceMap map, Throwable cause) {
        JOptionPane.showMessageDialog(Swinger.getActiveWindowComponent(), Swinger.getMessageFromException(map, cause), Swinger.getResourceMap().getString(MESSAGE_ERROR_TITLE_CODE, new Object[0]), 0);
    }

    public static int showOptionDialog(ResourceMap map, int messageType, String titleCode, String messageCode, String[] buttons, Object ... args) {
        return Swinger.showOptionDialog(map, true, messageType, titleCode, messageCode, buttons, args);
    }

    public static int showOptionDialog(ResourceMap map, boolean bringToFront, int messageType, String titleCode, String messageCode, String[] buttons, Object ... args) {
        ResourceMap mainMap = Swinger.getResourceMap();
        Object[] objects = new Object[buttons.length];
        for (int i = 0; i < buttons.length; ++i) {
            String s = map.getString(buttons[i], new Object[0]);
            assert (s != null);
            objects[i] = s;
        }
        Frame frame = Swinger.getActiveFrame();
        if (bringToFront) {
            Swinger.bringToFront(frame, true);
        }
        return JOptionPane.showOptionDialog(Swinger.getActiveWindowComponent(), map.getString(messageCode, args), mainMap.getString(titleCode, new Object[0]), 1, messageType, null, objects, objects[0]);
    }

    public static int showInputDialog(String title, final Object inputObject, boolean cancelButton) {
        ResourceMap mainMap = Swinger.getResourceMap();
        String[] buttons = cancelButton ? new String[]{MESSAGE_BTN_OK_CODE, MESSAGE_BTN_CANCEL_CODE} : new String[]{MESSAGE_BTN_OK_CODE};
        Object[] objects = new Object[buttons.length];
        for (int i = 0; i < buttons.length; ++i) {
            String s = mainMap.getString(buttons[i], new Object[0]);
            assert (s != null);
            objects[i] = s;
        }
        Frame frame = Swinger.getActiveFrame();
        Swinger.bringToFront(frame, true);
        if (inputObject instanceof JComponent) {
            Timer timer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Swinger.inputFocus((JComponent)inputObject);
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
        return JOptionPane.showOptionDialog(frame, inputObject, title, 1, -1, null, objects, objects[0]);
    }

    public static void bringToFront(Frame frame, boolean activate) {
        if (frame != null) {
            int state = frame.getExtendedState();
            if ((state & 1) == 1) {
                frame.setExtendedState(state &= 0xFFFFFFFE);
            }
            frame.setVisible(true);
            if (activate) {
                frame.toFront();
            }
        }
    }

    public static void showMessage(ResourceMap map, String message, Object ... args) {
        JOptionPane.showMessageDialog(Swinger.getActiveFrame(), map.getString(message, args), Swinger.getResourceMap().getString(MESSAGE_ERROR_TITLE_CODE, args), 0);
    }

    public static void inputFocus(JComboBox combo) {
        Swinger.inputFocus((JComponent)combo.getEditor().getEditorComponent());
    }

    public static void inputFocus(final JComponent field) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                field.grabFocus();
                field.requestFocus();
            }
        });
    }

    public static TableColumn updateColumn(JTable table, String name, int columnId, int minWidth, int width, TableCellRenderer renderer) {
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn column = columnModel.getColumn(columnId);
        column.setIdentifier(name);
        if (renderer != null) {
            column.setCellRenderer(renderer);
        }
        if (width != -1) {
            column.setPreferredWidth(width);
        }
        if (minWidth != -1) {
            column.setMinWidth(width);
        }
        return column;
    }

    public static TableColumn updateColumn(JTable table, String name, int columnId, int width) {
        return Swinger.updateColumn(table, name, columnId, width, width, null);
    }

    public static void showErrorDialog(Class clazz, String messageResource, Throwable e, boolean showErrorReporter) {
        Swinger.showErrorDialog(Swinger.getResourceMap(clazz), messageResource, e, showErrorReporter);
    }

    public static void showErrorDialog(Class clazz, String messageResource, Throwable e) {
        Swinger.showErrorDialog(Swinger.getResourceMap(clazz), messageResource, e, false);
    }

    public static void showErrorDialog(String messageResource, Throwable e, boolean showErrorReporter) {
        Swinger.showErrorDialog(ErrorDialog.class, messageResource, e, showErrorReporter);
    }

    public static void showErrorDialog(String messageResource, Throwable e) {
        Swinger.showErrorDialog(ErrorDialog.class, messageResource, e, false);
    }

    public static void showErrorDialog(ResourceMap map, String messageResource, Throwable e) {
        Swinger.showErrorDialog(map, messageResource, e, false);
    }

    private static void showErrorDialog(ResourceMap map, String messageResource, Throwable e, boolean showErrorReporter) {
        if (map == null) {
            throw new IllegalArgumentException("Map cannot be null");
        }
        String localizedMessage = e.getLocalizedMessage();
        if (localizedMessage == null) {
            localizedMessage = "";
        }
        String text = map.getString(messageResource, localizedMessage);
        Swinger.showErrorDialog(text, false, e, showErrorReporter);
    }

    private static void showErrorDialog(String message, boolean isMesssageResourceKey, Throwable e, boolean showErrorReporter) {
        ResourceMap map = Swinger.getResourceMap();
        ErrorInfo errorInfo = new ErrorInfo(map.getString(MESSAGE_ERROR_TITLE_CODE, new Object[0]), isMesssageResourceKey ? map.getString(message, new Object[0]) : message, null, "EDT Thread", e, Level.SEVERE, null);
        JXErrorPane pane = new JXErrorPane();
        if (showErrorReporter) {
            pane.setErrorReporter(new SubmitErrorReporter());
        }
        pane.setErrorInfo(errorInfo);
        JXErrorPane.showDialog((Component)Swinger.getActiveFrame(), pane);
    }

    public static Component getActiveWindowComponent() {
        Window window = Swinger.getActiveDialog();
        if (window == null) {
            return Swinger.getActiveFrame();
        }
        return window;
    }

    public static JComponent getTitleComponent(String title) {
        return Swinger.getTitleComponent(new JLabel(title));
    }

    public static JComponent getTitleComponent2(String titleCode) {
        JLabel label = new JLabel();
        label.setName(titleCode);
        label.setFont(label.getFont().deriveFont(1, 16.0f));
        return Swinger.getTitleComponent(label);
    }

    private static JComponent getTitleComponent(JLabel label) {
        JToolBar toolBar = new JToolBar();
        toolBar.setLayout(new GridBagLayout());
        toolBar.setFloatable(false);
        toolBar.setBorderPainted(false);
        toolBar.setOpaque(false);
        toolBar.add((Component)label, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 17, 0, new Insets(0, 4, 0, 2), 0, 0));
        toolBar.add((Component)new JSeparator(0), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(4, 0, 0, 0), 0, 0));
        return toolBar;
    }

    public static int getChoiceYesNo(String message) {
        ResourceMap map = Swinger.getResourceMap();
        return JOptionPane.showOptionDialog(Swinger.getActiveWindowComponent(), message, map.getString(MESSAGE_CONFIRM_TITLE_CODE, new Object[0]), 0, 3, null, new Object[]{map.getString(MESSAGE_BTN_YES_CODE, new Object[0]), map.getString(MESSAGE_BTN_NO_CODE, new Object[0])}, null);
    }

    public static void minimize(JFrame frame) {
        int state = frame.getExtendedState();
        frame.setExtendedState(state |= 1);
    }

    public static Frame getActiveFrame() {
        Frame[] frames;
        for (Frame frame : frames = Frame.getFrames()) {
            if (!frame.isActive()) continue;
            return frame;
        }
        return frames.length > 0 ? frames[0] : null;
    }

    public static Window getActiveDialog() {
        Window[] frames;
        for (Window frame : frames = Dialog.getWindows()) {
            if (!frame.isActive()) continue;
            return frame;
        }
        return frames.length > 0 ? frames[0] : null;
    }

    public static int[] getSelectedRows(JTable table) {
        int[] ints = table.getSelectedRows();
        int length = ints.length;
        int count = 0;
        for (int i = 0; i < length; ++i) {
            int rowIndex = ints[i];
            if (rowIndex >= table.getModel().getRowCount() || rowIndex >= table.getRowSorter().getViewRowCount()) continue;
            ints[count++] = table.convertRowIndexToModel(rowIndex);
        }
        if (count > 0) {
            return Arrays.copyOfRange(ints, 0, count);
        }
        return new int[0];
    }

    public static String getMessageFromException(ResourceMap map, Throwable cause) {
        String errorMessage;
        String localizedMessage = cause.getLocalizedMessage();
        String msg = localizedMessage != null ? (map.containsKey(localizedMessage) ? map.getString(localizedMessage, new Object[0]) : localizedMessage) : ((errorMessage = cause.getMessage()) != null && map.containsKey(errorMessage) ? map.getString(errorMessage, new Object[0]) : errorMessage);
        return msg;
    }

    public static int convertRowIndexToView(JTable table, int row) {
        if (row <= -1 || row >= table.getModel().getRowCount()) {
            return -1;
        }
        return table.convertRowIndexToView(row);
    }
}

