/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content.comparators;

import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import java.util.Comparator;

public final class ProgressBarColumnComparator
implements Comparator<DownloadFile> {
    @Override
    public final int compare(DownloadFile o1, DownloadFile o2) {
        int[] res2;
        int[] res1 = ProgressBarColumnComparator.getSortValue(o1);
        if (res1[0] == (res2 = ProgressBarColumnComparator.getSortValue(o2))[0]) {
            return new Integer(res1[1]).compareTo(res2[1]);
        }
        return new Integer(res1[0]).compareTo(res2[0]);
    }

    private static int[] getSortValue(DownloadFile downloadFile) {
        int[] result = new int[2];
        int toQueued = downloadFile.getTimeToQueued();
        DownloadState state = downloadFile.getState();
        if ((state == DownloadState.ERROR || state == DownloadState.SLEEPING) && toQueued >= 0) {
            result[0] = 2;
            result[1] = toQueued;
        } else {
            int sleep = downloadFile.getSleep();
            if (state == DownloadState.WAITING && sleep >= 0) {
                result[0] = 1;
                result[1] = sleep;
            } else {
                result[0] = 0;
                result[1] = ContentPanel.getProgress(downloadFile);
            }
        }
        return result;
    }
}

