/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content.comparators;

import cz.vity.freerapid.gui.actions.DownloadsActions;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import java.util.Comparator;

public final class AvgSpeedColumnComparator
implements Comparator<DownloadFile> {
    @Override
    public final int compare(DownloadFile o1, DownloadFile o2) {
        DownloadState state1 = o1.getState();
        DownloadState state2 = o2.getState();
        boolean isProcessState1 = DownloadsActions.isProcessState(state1);
        boolean isProcessState2 = DownloadsActions.isProcessState(state2);
        if (isProcessState1 && !isProcessState2) {
            return -1;
        }
        if (!isProcessState1 && isProcessState2) {
            return 1;
        }
        if (isProcessState1) {
            int p2;
            int p1 = DownloadsActions.getPriorityForState(state1);
            if (p1 == (p2 = DownloadsActions.getPriorityForState(state2))) {
                float value1 = o1.getSpeed() >= 0L ? o1.getAverageSpeed() : 0.0f;
                float value2 = o2.getSpeed() >= 0L ? o2.getAverageSpeed() : 0.0f;
                return Float.compare(value1, value2);
            }
            return new Integer(p1).compareTo(p2);
        }
        return 0;
    }
}

