/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content;

import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.gui.actions.DownloadsActions;
import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import java.awt.Component;
import java.util.concurrent.TimeUnit;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

final class EstTimeCellRenderer
extends DefaultTableCellRenderer {
    private final String tooltip;
    private final String elapsedTime;

    EstTimeCellRenderer(ApplicationContext context) {
        ResourceMap map = context.getResourceMap();
        this.tooltip = map.getString("tooltip", new Object[0]);
        this.elapsedTime = map.getString("elapsedTime", new Object[0]);
    }

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        DownloadTask task;
        if (value == null) {
            value = table.getValueAt(row, column);
        }
        DownloadFile downloadFile = (DownloadFile)value;
        DownloadState state = downloadFile.getState();
        value = ContentPanel.stateToString(state);
        this.setHorizontalAlignment(0);
        this.setToolTipText(null);
        if (state == DownloadState.DOWNLOADING) {
            long hasToBeDownloaded = downloadFile.getFileSize() - downloadFile.getDownloaded();
            double avgSpeed = downloadFile.getShortTimeAvgSpeed();
            if (hasToBeDownloaded >= 0L && avgSpeed > 0.0) {
                value = ContentPanel.secondsToHMin(Math.round((double)hasToBeDownloaded / avgSpeed));
            }
        } else if (state == DownloadState.WAITING) {
            // empty if block
        }
        if (state == DownloadState.ERROR || state == DownloadState.SLEEPING || state == DownloadState.DISABLED || state == DownloadState.SKIPPED) {
            String errorMessage = downloadFile.getErrorMessage();
            if (errorMessage != null) {
                if (state == DownloadState.ERROR || state == DownloadState.DISABLED) {
                    value = value + " - " + errorMessage.replaceAll("<.*?>", "");
                }
                this.setToolTipText(String.format(this.tooltip, errorMessage));
            }
        } else if (DownloadsActions.isProcessState(state) && (task = downloadFile.getTask()) != null) {
            this.setToolTipText(String.format(this.elapsedTime, ContentPanel.secondsToHMin(task.getExecutionDuration(TimeUnit.SECONDS))));
        }
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.getAccessibleContext().setAccessibleName(table.getColumnName(column) + " " + value);
        this.getAccessibleContext().setAccessibleDescription(table.getColumnName(column) + " " + value);
        return comp;
    }
}

