/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.plugimpl.StandardDialogSupportImpl;
import cz.vity.freerapid.plugins.container.ContainerException;
import cz.vity.freerapid.plugins.container.ContainerPlugin;
import cz.vity.freerapid.plugins.container.FileInfo;
import cz.vity.freerapid.plugins.exceptions.ServiceConnectionProblemException;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class ImportLinksTask
extends CoreTask<List<FileInfo>, Void> {
    private static final Logger logger = Logger.getLogger(ImportLinksTask.class.getName());
    private final MainApp app;
    private final ContainerPlugin plugin;
    private final File[] files;
    private final File saveToDirectory = new File(AppPrefs.getProperty("lastComboPath", ""));

    public ImportLinksTask(MainApp app, ContainerPlugin plugin, File[] files) {
        super(app);
        this.app = app;
        this.plugin = plugin;
        this.files = files;
        this.setTaskToForeground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<FileInfo> doInBackground() throws Exception {
        int i = 0;
        this.setProgress(i, 0, this.files.length);
        List<ConnectionSettings> settingsList = this.app.getManagerDirector().getClientManager().getAvailableConnections();
        this.plugin.setConnectionSettings(settingsList.isEmpty() ? null : settingsList.get(0));
        this.plugin.setDialogSupport(new StandardDialogSupportImpl(this.app.getContext()));
        LinkedList<FileInfo> list = new LinkedList<FileInfo>();
        for (File file : this.files) {
            this.message("importingLinks", Utils.shortenFileName(file));
            InputStream stream = null;
            try {
                stream = new FileInputStream(file);
                list.addAll(this.plugin.read(stream, file.toString()));
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception e) {
                        LogUtils.processException(logger, e);
                    }
                }
            }
            this.setProgress(++i, 0, this.files.length);
        }
        if (list.isEmpty()) {
            throw new ContainerException("noLinksFound");
        }
        return list;
    }

    @Override
    protected void failed(Throwable cause) {
        LogUtils.processException(logger, cause);
        if (cause instanceof ContainerException) {
            Swinger.showErrorMessage(this.getResourceMap(), cause.getMessage(), new Object[0]);
        } else if (cause instanceof ServiceConnectionProblemException) {
            if ("noAvailableConnection".equals(cause.getMessage())) {
                Swinger.showErrorMessage(this.getResourceMap(), "noAvailableConnection", new Object[0]);
            } else {
                Swinger.showErrorMessage(this.getResourceMap(), "connectionProblem", Utils.getThrowableDescription(cause));
            }
        } else if (cause instanceof UnknownHostException) {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_check_inet_settings", new Object[0]);
        } else {
            Swinger.showErrorMessage(this.getResourceMap(), "otherProblem", Utils.getThrowableDescription(cause));
        }
    }

    @Override
    protected void succeeded(List<FileInfo> list) {
        this.app.getManagerDirector().getDataManager().addLinksToQueueFromContainer(list, this.saveToDirectory, null, true);
    }
}

