/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.binding.impl.processor;

import java.util.Collection;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import jlibs.core.annotation.processing.AnnotationError;
import jlibs.core.lang.model.ModelUtil;
import jlibs.xml.sax.binding.Binding;
import jlibs.xml.sax.binding.impl.processor.Binding;
import jlibs.xml.sax.binding.impl.processor.BindingAnnotation;
import jlibs.xml.sax.binding.impl.processor.BindingRelation;

class BindingTextAnnotation
extends BindingAnnotation {
    BindingTextAnnotation() {
        super(Binding.Text.class, "public void text(int state, SAXContext current, String text) throws SAXException{");
    }

    @Override
    public void consume(Binding binding, ExecutableElement method, AnnotationMirror mirror) {
        super.consume(binding, method, mirror);
        for (AnnotationValue xpath : (Collection)ModelUtil.getAnnotationValue((Element)method, (AnnotationMirror)mirror, (String)"value")) {
            binding.getBinding((ExecutableElement)method, (AnnotationMirror)mirror, (String)((String)xpath.getValue())).textMethod = method;
        }
    }

    @Override
    public String lvalue(ExecutableElement method) {
        if (method.getReturnType().getKind() == TypeKind.VOID) {
            return "";
        }
        return "current.object = ";
    }

    @Override
    public String params(ExecutableElement method) {
        if (method.getParameters().size() > 0 && !this.matches(method, method.getParameters().size() - 1, String.class)) {
            throw new AnnotationError((Element)method, "method annotated with " + this.annotation.getCanonicalName() + " must take String as last argument");
        }
        switch (method.getParameters().size()) {
            case 1: {
                return "text";
            }
            case 2: {
                return this.context(method, 0, false) + ", text";
            }
        }
        throw new AnnotationError((Element)method, "method annotated with " + this.annotation.getCanonicalName() + " must take either one or two argument(s)");
    }

    @Override
    boolean getMethods(Binding binding, List<ExecutableElement> methods) {
        boolean nonEmpty = binding.textMethod != null;
        methods.add(binding.textMethod);
        for (BindingRelation bindingRelation : binding.registry.values()) {
            nonEmpty |= this.getMethods(bindingRelation.binding, methods);
        }
        return nonEmpty;
    }
}

