/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.async;

import jlibs.xml.ClarkName;
import jlibs.xml.sax.async.AttributeType;
import jlibs.xml.sax.async.DTD;
import jlibs.xml.sax.async.Namespaces;
import jlibs.xml.sax.async.QName;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class Attributes {
    private AttributesImpl attrs = new AttributesImpl();
    private Namespaces namespaces;
    DTD dtd;

    public Attributes(Namespaces namespaces) {
        this.namespaces = namespaces;
    }

    public void reset() {
        this.attrs.clear();
    }

    public String addAttribute(String elemName, QName attrQName, StringBuilder value) throws SAXException {
        String attrName = attrQName.name;
        AttributeType type = this.dtd == null ? AttributeType.CDATA : this.dtd.attributeType(elemName, attrName);
        String attrValue = type.normalize(value.toString());
        String attrLocalName = attrQName.localName;
        if (attrName.startsWith("xmlns")) {
            if (attrName.length() == 5) {
                this.namespaces.add("", attrValue);
                return null;
            }
            if (attrName.charAt(5) == ':') {
                if (attrLocalName.equals("xml")) {
                    if (!attrValue.equals("http://www.w3.org/XML/1998/namespace")) {
                        return "prefix xml must refer to http://www.w3.org/XML/1998/namespace";
                    }
                    return null;
                }
                if (attrLocalName.equals("xmlns")) {
                    return "prefix xmlns must not be declared";
                }
                if (attrValue.equals("http://www.w3.org/XML/1998/namespace")) {
                    return "http://www.w3.org/XML/1998/namespace must be bound to xml";
                }
                if (attrValue.equals("http://www.w3.org/2000/xmlns/")) {
                    return "http://www.w3.org/2000/xmlns/ must be bound to xmlns";
                }
                if (attrValue.length() == 0) {
                    return "No Prefix Undeclaring: " + attrLocalName;
                }
                this.namespaces.add(attrLocalName, attrValue);
                return null;
            }
        }
        this.attrs.addAttribute(attrQName.prefix, attrLocalName, attrName, type.name(), attrValue);
        return null;
    }

    public String fixAttributes(String elemName) throws SAXException {
        int attrCount = this.attrs.getLength();
        if (attrCount > 0) {
            int i;
            for (i = 0; i < attrCount; ++i) {
                String prefix = this.attrs.getURI(i);
                if (prefix.length() <= 0) continue;
                String uri = this.namespaces.getNamespaceURI(prefix);
                if (uri == null) {
                    return "Unbound prefix: " + prefix;
                }
                this.attrs.setURI(i, uri);
            }
            if (attrCount > 1) {
                for (i = 1; i < attrCount; ++i) {
                    if (this.attrs.getIndex(this.attrs.getURI(i), this.attrs.getLocalName(i)) >= i) continue;
                    return "Attribute \"" + ClarkName.valueOf(this.attrs.getURI(i), this.attrs.getLocalName(i)) + "\" was already specified for element \"" + elemName + "\"";
                }
            }
        }
        if (this.dtd != null) {
            this.dtd.addMissingAttributes(elemName, this.attrs);
        }
        return null;
    }

    public AttributesImpl get() {
        return this.attrs;
    }
}

