/*
 * Decompiled with CFR 0.152.
 */
package nl.ikarus.nxt.priv.imageio.icoreader.obj;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import nl.ikarus.nxt.priv.imageio.icoreader.lib.ImageReaderException;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.Bitmap;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.IconEntry;

public class IndexedBitmap
extends Bitmap {
    protected IndexedBitmap(IconEntry pEntry) throws IOException {
        super(pEntry);
        try {
            this.init();
        }
        catch (ImageReaderException ex) {
            throw new IOException("ImageReaderException: " + ex.getMessage());
        }
    }

    private void init() throws IOException, ImageReaderException {
        int tmpL;
        this.XORmaskSize = this.biWidth * (this.biHeight / 2) * this.biBitCount / 8;
        this.ANDMaskSize = tmpL = Math.max(this.biWidth, 32) * (this.biHeight / 2) / 8;
        int length = this.biBitCount <= 8 ? (int)Math.pow(2.0, this.biBitCount) * 4 : 0;
        if (length > 500000) {
            throw new ImageReaderException("RGBQUAD mask to large... " + length);
        }
        this.RGBQUAD = this.Chunk("RGBQUAD", length);
        if (this.XORmaskSize > 500000) {
            throw new ImageReaderException("XOR mask to large... " + this.XORmaskSize);
        }
        this.XOR = this.Chunk("XOR", this.XORmaskSize);
        if (this.ANDMaskSize > 500000) {
            throw new ImageReaderException("AND mask to large... " + this.ANDMaskSize);
        }
        this.AND = this.Chunk("AND", this.ANDMaskSize);
    }

    protected BufferedImage createImage() throws IOException {
        int w = this.entry.getWidth();
        int h = this.entry.getHeight();
        if (w < 1 || h < 1) {
            System.err.println("java.lang.IllegalArgumentException: Width (0) and height (0) cannot be <= 0");
            return null;
        }
        Color TRANSPARENT = new Color(0, 0, 0, 0);
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g = image.createGraphics();
        for (int y = this.biHeight / 2 - 1; y >= 0; --y) {
            for (int x = 0; x < this.biWidth; ++x) {
                if (!this.hasAlpha(x, y)) {
                    g.setColor(this.getRGB(x, y));
                } else {
                    g.setColor(TRANSPARENT);
                }
                g.fillRect(x, h - y - 1, 1, 1);
            }
        }
        return image;
    }

    private Color getRGB(int xx, int yy) {
        int bbc = this.biBitCount;
        if (bbc > 8) {
            System.err.println("This class can only handle bpp values of < 16.... (<=8 actually) but the current bpp value is " + bbc + "  you may get unexpected results");
        }
        int bbyte = yy * this.biWidth + xx;
        int pixelsPerByte = 8 / this.biBitCount;
        int shift = (pixelsPerByte - xx % pixelsPerByte - 1) * this.biBitCount;
        int colIdx = this.ord(this.XOR[bbyte /= pixelsPerByte]) >> shift & (1 << this.biBitCount) - 1;
        int b = this.ord(this.RGBQUAD[4 * colIdx]);
        int g = this.ord(this.RGBQUAD[4 * colIdx + 1]);
        int r = this.ord(this.RGBQUAD[4 * colIdx + 2]);
        return new Color(r, g, b);
    }

    private byte[] Chunk(String txt, int len) throws IOException {
        return this.reader.readBytes(len);
    }

    private int ord(byte c) {
        return c < 0 ? c + 256 : c;
    }

    private boolean hasAlpha(int xx, int yy) {
        int bbyte = yy * 32 + xx;
        int c = this.ord(this.AND[bbyte /= 8]);
        int res = c >> 7 - xx % 8 & 1;
        return res == 1;
    }
}

