/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Version
implements Serializable,
Comparable<Version> {
    private static final long serialVersionUID = -3054349171116917643L;
    public static final char SEPARATOR = '.';
    private transient int major;
    private transient int minor;
    private transient int build;
    private transient String name;
    private transient String asString;

    public static Version parse(String str) {
        Version result = new Version();
        result.parseString(str);
        return result;
    }

    private Version() {
    }

    private void parseString(String str) {
        this.major = 0;
        this.minor = 0;
        this.build = 0;
        this.name = "";
        StringTokenizer st = new StringTokenizer(str, ".", false);
        if (!st.hasMoreTokens()) {
            return;
        }
        String token = st.nextToken();
        try {
            this.major = Integer.parseInt(token, 10);
        }
        catch (NumberFormatException nfe) {
            this.name = token;
            while (st.hasMoreTokens()) {
                this.name = this.name + st.nextToken();
            }
            return;
        }
        if (!st.hasMoreTokens()) {
            return;
        }
        token = st.nextToken();
        try {
            this.minor = Integer.parseInt(token, 10);
        }
        catch (NumberFormatException nfe) {
            this.name = token;
            while (st.hasMoreTokens()) {
                this.name = this.name + st.nextToken();
            }
            return;
        }
        if (!st.hasMoreTokens()) {
            return;
        }
        token = st.nextToken();
        try {
            this.build = Integer.parseInt(token, 10);
        }
        catch (NumberFormatException nfe) {
            this.name = token;
            while (st.hasMoreTokens()) {
                this.name = this.name + st.nextToken();
            }
            return;
        }
        if (st.hasMoreTokens()) {
            this.name = st.nextToken();
            while (st.hasMoreTokens()) {
                this.name = this.name + st.nextToken();
            }
        }
    }

    public Version(int aMajor, int aMinor, int aBuild, String aName) {
        this.major = aMajor;
        this.minor = aMinor;
        this.build = aBuild;
        this.name = aName == null ? "" : aName;
    }

    public int getBuild() {
        return this.build;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getName() {
        return this.name;
    }

    public boolean isGreaterOrEqualTo(Version other) {
        if (other == null) {
            return false;
        }
        if (this.major > other.major) {
            return true;
        }
        if (this.major == other.major && this.minor > other.minor) {
            return true;
        }
        if (this.major == other.major && this.minor == other.minor && this.build > other.build) {
            return true;
        }
        return this.major == other.major && this.minor == other.minor && this.build == other.build && this.name.equalsIgnoreCase(other.name);
    }

    public boolean isCompatibleWith(Version other) {
        if (other == null) {
            return false;
        }
        if (this.major != other.major) {
            return false;
        }
        if (this.minor > other.minor) {
            return true;
        }
        if (this.minor < other.minor) {
            return false;
        }
        return this.build >= other.build;
    }

    public boolean isEquivalentTo(Version other) {
        if (other == null) {
            return false;
        }
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return this.build >= other.build;
    }

    public boolean isGreaterThan(Version other) {
        if (other == null) {
            return false;
        }
        if (this.major > other.major) {
            return true;
        }
        if (this.major < other.major) {
            return false;
        }
        if (this.minor > other.minor) {
            return true;
        }
        if (this.minor < other.minor) {
            return false;
        }
        return this.build > other.build;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version other = (Version)obj;
        return this.major == other.major && this.minor == other.minor && this.build == other.build && this.name.equalsIgnoreCase(other.name);
    }

    public String toString() {
        if (this.asString == null) {
            this.asString = "" + this.major + '.' + this.minor + '.' + this.build + (this.name.length() == 0 ? "" : '.' + this.name);
        }
        return this.asString;
    }

    @Override
    public int compareTo(Version obj) {
        if (this.equals(obj)) {
            return 0;
        }
        if (this.major != obj.major) {
            return this.major - obj.major;
        }
        if (this.minor != obj.minor) {
            return this.minor - obj.minor;
        }
        if (this.build != obj.build) {
            return this.build - obj.build;
        }
        return this.name.toLowerCase(Locale.ENGLISH).compareTo(obj.name.toLowerCase(Locale.ENGLISH));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.parseString(in.readUTF());
    }
}

