/*
 * Decompiled with CFR 0.152.
 */
package glguerin.authkit.imp.plain;

import glguerin.authkit.Authorization;
import glguerin.authkit.Privilege;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;

public class GrantAllAuthorization
extends Authorization {
    private boolean isAttached = false;

    public int getCapabilities() {
        return 126;
    }

    public void authorize(Privilege privilege, boolean bl) {
        this.isAttached = true;
        this.addGranted(privilege);
    }

    public void preauthorize(Privilege privilege) {
        this.isAttached = true;
        this.addGranted(privilege);
    }

    public boolean isAvailable(Privilege privilege) {
        this.isAttached = true;
        return true;
    }

    public void detach(boolean bl) {
        this.isAttached = false;
        this.clearGranted();
    }

    public Enumeration getPastGrantedPrivileges() {
        return this.keysGranted();
    }

    public Date getPastGrantedDate(Privilege privilege, int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("Illegal when-code: " + n);
        }
        return this.whenGranted(privilege, n);
    }

    public Privilege makeExecPrivilege(String string) {
        return new Privilege("exec.root.granted", string, 0);
    }

    public Process execPrivileged(String[] stringArray) {
        this.isAttached = true;
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            this.addGranted(this.makeExecPrivilege(stringArray[0]));
            return process;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Execution failed: " + stringArray[0]);
        }
    }

    public int getSecretLength() {
        return 21;
    }

    public byte[] getSecretIdentifier() {
        if (this.isAttached) {
            byte[] byArray = new byte[this.getSecretLength()];
            int n = 0;
            while (n < byArray.length) {
                byArray[n] = (byte)(~n);
                ++n;
            }
            return byArray;
        }
        return new byte[0];
    }

    public void attach(byte[] byArray) {
        if (byArray == null || byArray.length < this.getSecretLength()) {
            throw new IllegalArgumentException();
        }
        if (this.isAttached) {
            throw new IllegalStateException("Session active");
        }
    }

    public void attachPrivileged() {
        if (this.isAttached) {
            throw new IllegalStateException("Session active");
        }
    }
}

