/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.misc;

import org.stringtemplate.v4.InstanceScope;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.misc.Coordinate;
import org.stringtemplate.v4.misc.ErrorType;
import org.stringtemplate.v4.misc.Interval;
import org.stringtemplate.v4.misc.Misc;
import org.stringtemplate.v4.misc.STMessage;

public class STRuntimeMessage
extends STMessage {
    Interpreter interp;
    public int ip = -1;
    public InstanceScope scope;

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip) {
        this(interp, error, ip, null);
    }

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip, ST self) {
        this(interp, error, ip, self, null);
    }

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip, ST self, Object arg) {
        this(interp, error, ip, self, null, arg, null);
    }

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip, ST self, Throwable e2, Object arg) {
        this(interp, error, ip, self, e2, arg, null);
    }

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip, ST self, Throwable e2, Object arg, Object arg2) {
        this(interp, error, ip, self, e2, arg, arg2, null);
    }

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip, ST self, Throwable e2, Object arg, Object arg2, Object arg3) {
        super(error, self, e2, arg, arg2, arg3);
        this.interp = interp;
        this.ip = ip;
        if (interp != null) {
            this.scope = interp.currentScope;
        }
    }

    public String getSourceLocation() {
        if (this.ip < 0 || this.self.impl == null) {
            return null;
        }
        Interval I2 = this.self.impl.sourceMap[this.ip];
        if (I2 == null) {
            return null;
        }
        int i2 = I2.a;
        Coordinate loc = Misc.getLineCharPosition(this.self.impl.template, i2);
        return loc.toString();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        String loc = this.getSourceLocation();
        if (this.self != null) {
            buf.append("context [");
            if (this.interp != null) {
                buf.append(Interpreter.getEnclosingInstanceStackString(this.scope));
            }
            buf.append("]");
        }
        if (loc != null) {
            buf.append(" " + loc);
        }
        buf.append(" " + super.toString());
        return buf.toString();
    }
}

