/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.gui;

import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.antlr.runtime.tree.CommonTree;
import org.stringtemplate.v4.InstanceScope;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.debug.AddAttributeEvent;

public class JTreeScopeStackModel
implements TreeModel {
    CommonTree root = new StringTree("Scope stack:");

    public JTreeScopeStackModel(InstanceScope scope) {
        List<InstanceScope> stack = Interpreter.getScopeStack(scope, true);
        for (InstanceScope s2 : stack) {
            StringTree templateNode = new StringTree(s2.st.getName());
            this.root.addChild(templateNode);
            this.addAttributeDescriptions(s2.st, templateNode);
        }
    }

    public void addAttributeDescriptions(ST st, StringTree node) {
        Map<String, Object> attrs = st.getAttributes();
        if (attrs == null) {
            return;
        }
        for (String a2 : attrs.keySet()) {
            String descr = null;
            if (st.debugState != null && st.debugState.addAttrEvents != null) {
                List events = (List)st.debugState.addAttrEvents.get(a2);
                StringBuilder locations = new StringBuilder();
                int i2 = 0;
                if (events != null) {
                    for (AddAttributeEvent ae : events) {
                        if (i2 > 0) {
                            locations.append(", ");
                        }
                        locations.append(ae.getFileName() + ":" + ae.getLine());
                        ++i2;
                    }
                }
                descr = locations.length() > 0 ? a2 + " = " + attrs.get(a2) + " @ " + locations.toString() : a2 + " = " + attrs.get(a2);
            } else {
                descr = a2 + " = " + attrs.get(a2);
            }
            node.addChild(new StringTree(descr));
        }
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int i2) {
        StringTree t2 = (StringTree)parent;
        return t2.getChild(i2);
    }

    @Override
    public int getChildCount(Object parent) {
        StringTree t2 = (StringTree)parent;
        return t2.getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        StringTree c2 = (StringTree)child;
        return c2.getChildIndex();
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object o2) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
    }

    public static class StringTree
    extends CommonTree {
        String text;

        public StringTree(String text) {
            this.text = text;
        }

        @Override
        public boolean isNil() {
            return this.text == null;
        }

        @Override
        public String toString() {
            if (!this.isNil()) {
                return this.text.toString();
            }
            return "nil";
        }
    }
}

