/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.schema.BuiltinSchemaTypeSystem;
import org.apache.xmlbeans.impl.util.XsTypeConverter;
import org.apache.xmlbeans.impl.values.NamespaceManager;
import org.apache.xmlbeans.impl.values.XmlObjectBase;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;

public abstract class JavaLongHolder
extends XmlObjectBase {
    private long _value;
    private static final BigInteger _max = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger _min = BigInteger.valueOf(Long.MIN_VALUE);

    public SchemaType schemaType() {
        return BuiltinSchemaTypeSystem.ST_LONG;
    }

    protected String compute_text(NamespaceManager nsm) {
        return Long.toString(this._value);
    }

    protected void set_text(String s2) {
        try {
            this.set_long(XsTypeConverter.lexLong(s2));
        }
        catch (Exception e2) {
            throw new XmlValueOutOfRangeException("long", new Object[]{s2});
        }
    }

    protected void set_nil() {
        this._value = 0L;
    }

    public BigDecimal getBigDecimalValue() {
        this.check_dated();
        return BigDecimal.valueOf(this._value);
    }

    public BigInteger getBigIntegerValue() {
        this.check_dated();
        return BigInteger.valueOf(this._value);
    }

    public long getLongValue() {
        this.check_dated();
        return this._value;
    }

    protected void set_BigDecimal(BigDecimal v2) {
        this.set_BigInteger(v2.toBigInteger());
    }

    protected void set_BigInteger(BigInteger v2) {
        if (v2.compareTo(_max) > 0 || v2.compareTo(_min) < 0) {
            throw new XmlValueOutOfRangeException();
        }
        this._value = v2.longValue();
    }

    protected void set_long(long l2) {
        this._value = l2;
    }

    protected int compare_to(XmlObject l2) {
        if (((SimpleValue)l2).instanceType().getDecimalSize() > 64) {
            return -l2.compareTo(this);
        }
        return this._value == ((XmlObjectBase)l2).longValue() ? 0 : (this._value < ((XmlObjectBase)l2).longValue() ? -1 : 1);
    }

    protected boolean equal_to(XmlObject l2) {
        if (((SimpleValue)l2).instanceType().getDecimalSize() > 64) {
            return l2.valueEquals(this);
        }
        return this._value == ((XmlObjectBase)l2).longValue();
    }

    protected int value_hash_code() {
        return (int)((this._value >> 32) * 19L + this._value);
    }
}

