/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.sl.draw.DrawPictureShape;
import org.apache.poi.sl.draw.DrawShape;
import org.apache.poi.sl.draw.ImageRenderer;
import org.apache.poi.sl.draw.PathGradientPaint;
import org.apache.poi.sl.usermodel.ColorStyle;
import org.apache.poi.sl.usermodel.PaintStyle;
import org.apache.poi.sl.usermodel.PlaceableShape;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class DrawPaint {
    private static final POILogger LOG = POILogFactory.getLogger(DrawPaint.class);
    private static final Color TRANSPARENT = new Color(1.0f, 1.0f, 1.0f, 0.0f);
    protected PlaceableShape<?, ?> shape;

    public DrawPaint(PlaceableShape<?, ?> shape) {
        this.shape = shape;
    }

    public static PaintStyle.SolidPaint createSolidPaint(Color color) {
        return color == null ? null : new SimpleSolidPaint(color);
    }

    public static PaintStyle.SolidPaint createSolidPaint(ColorStyle color) {
        return color == null ? null : new SimpleSolidPaint(color);
    }

    public Paint getPaint(Graphics2D graphics, PaintStyle paint) {
        return this.getPaint(graphics, paint, PaintStyle.PaintModifier.NORM);
    }

    public Paint getPaint(Graphics2D graphics, PaintStyle paint, PaintStyle.PaintModifier modifier) {
        if (modifier == PaintStyle.PaintModifier.NONE) {
            return null;
        }
        if (paint instanceof PaintStyle.SolidPaint) {
            return this.getSolidPaint((PaintStyle.SolidPaint)paint, graphics, modifier);
        }
        if (paint instanceof PaintStyle.GradientPaint) {
            return this.getGradientPaint((PaintStyle.GradientPaint)paint, graphics);
        }
        if (paint instanceof PaintStyle.TexturePaint) {
            return this.getTexturePaint((PaintStyle.TexturePaint)paint, graphics);
        }
        return null;
    }

    protected Paint getSolidPaint(PaintStyle.SolidPaint fill, Graphics2D graphics, final PaintStyle.PaintModifier modifier) {
        final ColorStyle orig = fill.getSolidColor();
        ColorStyle cs = new ColorStyle(){

            @Override
            public Color getColor() {
                return orig.getColor();
            }

            @Override
            public int getAlpha() {
                return orig.getAlpha();
            }

            @Override
            public int getHueOff() {
                return orig.getHueOff();
            }

            @Override
            public int getHueMod() {
                return orig.getHueMod();
            }

            @Override
            public int getSatOff() {
                return orig.getSatOff();
            }

            @Override
            public int getSatMod() {
                return orig.getSatMod();
            }

            @Override
            public int getLumOff() {
                return orig.getLumOff();
            }

            @Override
            public int getLumMod() {
                return orig.getLumMod();
            }

            @Override
            public int getShade() {
                int shade = orig.getShade();
                switch (modifier) {
                    case DARKEN: {
                        return Math.min(100000, Math.max(0, shade) + 40000);
                    }
                    case DARKEN_LESS: {
                        return Math.min(100000, Math.max(0, shade) + 20000);
                    }
                }
                return shade;
            }

            @Override
            public int getTint() {
                int tint = orig.getTint();
                switch (modifier) {
                    case LIGHTEN: {
                        return Math.min(100000, Math.max(0, tint) + 40000);
                    }
                    case LIGHTEN_LESS: {
                        return Math.min(100000, Math.max(0, tint) + 20000);
                    }
                }
                return tint;
            }
        };
        return DrawPaint.applyColorTransform(cs);
    }

    protected Paint getGradientPaint(PaintStyle.GradientPaint fill, Graphics2D graphics) {
        switch (fill.getGradientType()) {
            case linear: {
                return this.createLinearGradientPaint(fill, graphics);
            }
            case circular: {
                return this.createRadialGradientPaint(fill, graphics);
            }
            case shape: {
                return this.createPathGradientPaint(fill, graphics);
            }
        }
        throw new UnsupportedOperationException("gradient fill of type " + fill + " not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Paint getTexturePaint(PaintStyle.TexturePaint fill, Graphics2D graphics) {
        InputStream is = fill.getImageData();
        if (is == null) {
            return null;
        }
        assert (graphics != null);
        ImageRenderer renderer = DrawPictureShape.getImageRenderer(graphics, fill.getContentType());
        try {
            try {
                renderer.loadImage(is, fill.getContentType());
            }
            finally {
                is.close();
            }
        }
        catch (IOException e2) {
            LOG.log(7, "Can't load image data - using transparent color", e2);
            return null;
        }
        int alpha = fill.getAlpha();
        if (0 <= alpha && alpha < 100000) {
            renderer.setAlpha((float)alpha / 100000.0f);
        }
        Rectangle2D textAnchor = this.shape.getAnchor();
        BufferedImage image = "image/x-wmf".equals(fill.getContentType()) ? renderer.getImage(new Dimension((int)textAnchor.getWidth(), (int)textAnchor.getHeight())) : renderer.getImage();
        if (image == null) {
            LOG.log(7, "Can't load image data");
            return null;
        }
        TexturePaint paint = new TexturePaint(image, textAnchor);
        return paint;
    }

    public static Color applyColorTransform(ColorStyle color) {
        if (color == null || color.getColor() == null) {
            return TRANSPARENT;
        }
        Color result = color.getColor();
        double alpha = DrawPaint.getAlpha(result, color);
        double[] hsl = DrawPaint.RGB2HSL(result);
        DrawPaint.applyHslModOff(hsl, 0, color.getHueMod(), color.getHueOff());
        DrawPaint.applyHslModOff(hsl, 1, color.getSatMod(), color.getSatOff());
        DrawPaint.applyHslModOff(hsl, 2, color.getLumMod(), color.getLumOff());
        DrawPaint.applyShade(hsl, color);
        DrawPaint.applyTint(hsl, color);
        result = DrawPaint.HSL2RGB(hsl[0], hsl[1], hsl[2], alpha);
        return result;
    }

    private static double getAlpha(Color c2, ColorStyle fc) {
        double alpha = (double)c2.getAlpha() / 255.0;
        int fcAlpha = fc.getAlpha();
        if (fcAlpha != -1) {
            alpha *= (double)fcAlpha / 100000.0;
        }
        return Math.min(1.0, Math.max(0.0, alpha));
    }

    private static void applyHslModOff(double[] hsl, int hslPart, int mod, int off) {
        if (mod == -1) {
            mod = 100000;
        }
        if (off == -1) {
            off = 0;
        }
        if (mod != 100000 || off != 0) {
            double fOff = (double)off / 1000.0;
            double fMod = (double)mod / 100000.0;
            hsl[hslPart] = hsl[hslPart] * fMod + fOff;
        }
    }

    private static void applyShade(double[] hsl, ColorStyle fc) {
        int shade = fc.getShade();
        if (shade == -1) {
            return;
        }
        double shadePct = (double)shade / 100000.0;
        hsl[2] = hsl[2] * (1.0 - shadePct);
    }

    private static void applyTint(double[] hsl, ColorStyle fc) {
        int tint = fc.getTint();
        if (tint == -1) {
            return;
        }
        double tintPct = (double)tint / 100000.0;
        hsl[2] = hsl[2] * (1.0 - tintPct) + (100.0 - 100.0 * (1.0 - tintPct));
    }

    protected Paint createLinearGradientPaint(PaintStyle.GradientPaint fill, Graphics2D graphics) {
        double angle = fill.getGradientAngle();
        if (!fill.isRotatedWithShape()) {
            angle -= this.shape.getRotation();
        }
        Rectangle2D anchor = DrawShape.getAnchor(graphics, this.shape);
        double h2 = anchor.getHeight();
        double w2 = anchor.getWidth();
        double x2 = anchor.getX();
        double y2 = anchor.getY();
        AffineTransform at = AffineTransform.getRotateInstance(Math.toRadians(angle), anchor.getCenterX(), anchor.getCenterY());
        double diagonal = Math.sqrt(h2 * h2 + w2 * w2);
        Point2D p1 = new Point2D.Double(x2 + w2 / 2.0 - diagonal / 2.0, y2 + h2 / 2.0);
        p1 = at.transform(p1, null);
        Point2D p2 = new Point2D.Double(x2 + w2, y2 + h2 / 2.0);
        if (p1.equals(p2 = at.transform(p2, null))) {
            return null;
        }
        float[] fractions = fill.getGradientFractions();
        Color[] colors = new Color[fractions.length];
        int i2 = 0;
        for (ColorStyle fc : fill.getGradientColors()) {
            colors[i2++] = fc == null ? TRANSPARENT : DrawPaint.applyColorTransform(fc);
        }
        return new LinearGradientPaint(p1, p2, fractions, colors);
    }

    protected Paint createRadialGradientPaint(PaintStyle.GradientPaint fill, Graphics2D graphics) {
        Rectangle2D anchor = DrawShape.getAnchor(graphics, this.shape);
        Point2D.Double pCenter = new Point2D.Double(anchor.getX() + anchor.getWidth() / 2.0, anchor.getY() + anchor.getHeight() / 2.0);
        float radius = (float)Math.max(anchor.getWidth(), anchor.getHeight());
        float[] fractions = fill.getGradientFractions();
        Color[] colors = new Color[fractions.length];
        int i2 = 0;
        for (ColorStyle fc : fill.getGradientColors()) {
            colors[i2++] = DrawPaint.applyColorTransform(fc);
        }
        return new RadialGradientPaint(pCenter, radius, fractions, colors);
    }

    protected Paint createPathGradientPaint(PaintStyle.GradientPaint fill, Graphics2D graphics) {
        float[] fractions = fill.getGradientFractions();
        Color[] colors = new Color[fractions.length];
        int i2 = 0;
        for (ColorStyle fc : fill.getGradientColors()) {
            colors[i2++] = DrawPaint.applyColorTransform(fc);
        }
        return new PathGradientPaint(colors, fractions);
    }

    protected void snapToAnchor(Point2D p2, Rectangle2D anchor) {
        if (p2.getX() < anchor.getX()) {
            p2.setLocation(anchor.getX(), p2.getY());
        } else if (p2.getX() > anchor.getX() + anchor.getWidth()) {
            p2.setLocation(anchor.getX() + anchor.getWidth(), p2.getY());
        }
        if (p2.getY() < anchor.getY()) {
            p2.setLocation(p2.getX(), anchor.getY());
        } else if (p2.getY() > anchor.getY() + anchor.getHeight()) {
            p2.setLocation(p2.getX(), anchor.getY() + anchor.getHeight());
        }
    }

    public static Color HSL2RGB(double h2, double s2, double l2, double alpha) {
        s2 = Math.max(0.0, Math.min(100.0, s2));
        l2 = Math.max(0.0, Math.min(100.0, l2));
        if (alpha < 0.0 || alpha > 1.0) {
            String message = "Color parameter outside of expected range - Alpha: " + alpha;
            throw new IllegalArgumentException(message);
        }
        h2 %= 360.0;
        double q2 = (l2 /= 100.0) < 0.5 ? l2 * (1.0 + s2) : l2 + (s2 /= 100.0) - s2 * l2;
        double p2 = 2.0 * l2 - q2;
        double r2 = Math.max(0.0, DrawPaint.HUE2RGB(p2, q2, (h2 /= 360.0) + 0.3333333333333333));
        double g2 = Math.max(0.0, DrawPaint.HUE2RGB(p2, q2, h2));
        double b2 = Math.max(0.0, DrawPaint.HUE2RGB(p2, q2, h2 - 0.3333333333333333));
        r2 = Math.min(r2, 1.0);
        g2 = Math.min(g2, 1.0);
        b2 = Math.min(b2, 1.0);
        return new Color((float)r2, (float)g2, (float)b2, (float)alpha);
    }

    private static double HUE2RGB(double p2, double q2, double h2) {
        if (h2 < 0.0) {
            h2 += 1.0;
        }
        if (h2 > 1.0) {
            h2 -= 1.0;
        }
        if (6.0 * h2 < 1.0) {
            return p2 + (q2 - p2) * 6.0 * h2;
        }
        if (2.0 * h2 < 1.0) {
            return q2;
        }
        if (3.0 * h2 < 2.0) {
            return p2 + (q2 - p2) * 6.0 * (0.6666666666666666 - h2);
        }
        return p2;
    }

    private static double[] RGB2HSL(Color color) {
        float[] rgb = color.getRGBColorComponents(null);
        double r2 = rgb[0];
        double g2 = rgb[1];
        double b2 = rgb[2];
        double min = Math.min(r2, Math.min(g2, b2));
        double max = Math.max(r2, Math.max(g2, b2));
        double h2 = 0.0;
        if (max == min) {
            h2 = 0.0;
        } else if (max == r2) {
            h2 = (60.0 * (g2 - b2) / (max - min) + 360.0) % 360.0;
        } else if (max == g2) {
            h2 = 60.0 * (b2 - r2) / (max - min) + 120.0;
        } else if (max == b2) {
            h2 = 60.0 * (r2 - g2) / (max - min) + 240.0;
        }
        double l2 = (max + min) / 2.0;
        double s2 = 0.0;
        s2 = max == min ? 0.0 : (l2 <= 0.5 ? (max - min) / (max + min) : (max - min) / (2.0 - max - min));
        return new double[]{h2, s2 * 100.0, l2 * 100.0};
    }

    public static int srgb2lin(float sRGB) {
        if ((double)sRGB <= 0.04045) {
            return (int)Math.rint(100000.0 * (double)sRGB / 12.92);
        }
        return (int)Math.rint(100000.0 * Math.pow(((double)sRGB + 0.055) / 1.055, 2.4));
    }

    public static float lin2srgb(int linRGB) {
        if ((double)linRGB <= 0.0031308) {
            return (float)((double)linRGB / 100000.0 * 12.92);
        }
        return (float)(1.055 * Math.pow((double)linRGB / 100000.0, 0.4166666666666667) - 0.055);
    }

    private static class SimpleSolidPaint
    implements PaintStyle.SolidPaint {
        private final ColorStyle solidColor;

        SimpleSolidPaint(final Color color) {
            if (color == null) {
                throw new NullPointerException("Color needs to be specified");
            }
            this.solidColor = new ColorStyle(){

                @Override
                public Color getColor() {
                    return new Color(color.getRed(), color.getGreen(), color.getBlue());
                }

                @Override
                public int getAlpha() {
                    return (int)Math.round((double)color.getAlpha() * 100000.0 / 255.0);
                }

                @Override
                public int getHueOff() {
                    return -1;
                }

                @Override
                public int getHueMod() {
                    return -1;
                }

                @Override
                public int getSatOff() {
                    return -1;
                }

                @Override
                public int getSatMod() {
                    return -1;
                }

                @Override
                public int getLumOff() {
                    return -1;
                }

                @Override
                public int getLumMod() {
                    return -1;
                }

                @Override
                public int getShade() {
                    return -1;
                }

                @Override
                public int getTint() {
                    return -1;
                }
            };
        }

        SimpleSolidPaint(ColorStyle color) {
            if (color == null) {
                throw new NullPointerException("Color needs to be specified");
            }
            this.solidColor = color;
        }

        @Override
        public ColorStyle getSolidColor() {
            return this.solidColor;
        }
    }
}

