/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.poifs.common.POIFSBigBlockSize;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.storage.BigBlock;
import org.apache.poi.poifs.storage.BlockWritable;

public final class PropertyBlock
extends BigBlock {
    private Property[] _properties;

    private PropertyBlock(POIFSBigBlockSize bigBlockSize, Property[] properties, int offset) {
        super(bigBlockSize);
        this._properties = new Property[bigBlockSize.getPropertiesPerBlock()];
        for (int j2 = 0; j2 < this._properties.length; ++j2) {
            this._properties[j2] = properties[j2 + offset];
        }
    }

    public static BlockWritable[] createPropertyBlockArray(POIFSBigBlockSize bigBlockSize, List<Property> properties) {
        int _properties_per_block = bigBlockSize.getPropertiesPerBlock();
        int block_count = (properties.size() + _properties_per_block - 1) / _properties_per_block;
        Property[] to_be_written = new Property[block_count * _properties_per_block];
        System.arraycopy(properties.toArray(new Property[0]), 0, to_be_written, 0, properties.size());
        for (int j2 = properties.size(); j2 < to_be_written.length; ++j2) {
            to_be_written[j2] = new Property(){

                @Override
                protected void preWrite() {
                }

                @Override
                public boolean isDirectory() {
                    return false;
                }
            };
        }
        BlockWritable[] rvalue = new BlockWritable[block_count];
        for (int j3 = 0; j3 < block_count; ++j3) {
            rvalue[j3] = new PropertyBlock(bigBlockSize, to_be_written, j3 * _properties_per_block);
        }
        return rvalue;
    }

    @Override
    void writeData(OutputStream stream) throws IOException {
        int _properties_per_block = this.bigBlockSize.getPropertiesPerBlock();
        for (int j2 = 0; j2 < _properties_per_block; ++j2) {
            this._properties[j2].writeData(stream);
        }
    }
}

