/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.swing.gvt.Overlay;

public class SVGUpdateOverlay
implements Overlay {
    List rects = new LinkedList();
    int size;
    int updateCount;
    int[] counts;

    public SVGUpdateOverlay(int size, int numUpdates) {
        this.size = size;
        this.counts = new int[numUpdates];
    }

    public void addRect(Rectangle r2) {
        this.rects.add(r2);
        if (this.rects.size() > this.size) {
            this.rects.remove(0);
        }
        ++this.updateCount;
    }

    public void endUpdate() {
        int i2;
        for (i2 = 0; i2 < this.counts.length - 1; ++i2) {
            this.counts[i2] = this.counts[i2 + 1];
        }
        this.counts[i2] = this.updateCount;
        this.updateCount = 0;
        int num = this.rects.size();
        for (i2 = this.counts.length - 1; i2 >= 0; --i2) {
            if (this.counts[i2] > num) {
                this.counts[i2] = num;
            }
            num -= this.counts[i2];
        }
        this.counts[0] = this.counts[0] + num;
    }

    @Override
    public void paint(Graphics g2) {
        int group;
        Iterator i2 = this.rects.iterator();
        int count = 0;
        int idx = 0;
        for (group = 0; group < this.counts.length - 1 && idx == this.counts[group]; ++group) {
        }
        int cmax = this.counts.length - 1;
        while (i2.hasNext()) {
            Rectangle r2 = (Rectangle)i2.next();
            Color c2 = new Color(1.0f, (float)(cmax - group) / (float)cmax, 0.0f, ((float)count + 1.0f) / (float)this.rects.size());
            g2.setColor(c2);
            g2.drawRect(r2.x, r2.y, r2.width, r2.height);
            ++count;
            ++idx;
            while (group < this.counts.length - 1 && idx == this.counts[group]) {
                ++group;
                idx = 0;
            }
        }
    }
}

