/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import org.apache.batik.swing.gvt.InteractorAdapter;
import org.apache.batik.swing.gvt.JGVTComponent;

public class AbstractRotateInteractor
extends InteractorAdapter {
    protected boolean finished;
    protected double initialRotation;

    @Override
    public boolean endInteraction() {
        return this.finished;
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.finished = false;
        JGVTComponent c2 = (JGVTComponent)e2.getSource();
        Dimension d2 = c2.getSize();
        double dx = e2.getX() - d2.width / 2;
        double dy = e2.getY() - d2.height / 2;
        double cos = -dy / Math.sqrt(dx * dx + dy * dy);
        this.initialRotation = dx > 0.0 ? Math.acos(cos) : -Math.acos(cos);
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this.finished = true;
        JGVTComponent c2 = (JGVTComponent)e2.getSource();
        AffineTransform at = this.rotateTransform(c2.getSize(), e2.getX(), e2.getY());
        at.concatenate(c2.getRenderingTransform());
        c2.setRenderingTransform(at);
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        this.finished = true;
        JGVTComponent c2 = (JGVTComponent)e2.getSource();
        c2.setPaintingTransform(null);
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        JGVTComponent c2 = (JGVTComponent)e2.getSource();
        c2.setPaintingTransform(this.rotateTransform(c2.getSize(), e2.getX(), e2.getY()));
    }

    protected AffineTransform rotateTransform(Dimension d2, int x2, int y2) {
        double dx = x2 - d2.width / 2;
        double dy = y2 - d2.height / 2;
        double cos = -dy / Math.sqrt(dx * dx + dy * dy);
        double angle = dx > 0.0 ? Math.acos(cos) : -Math.acos(cos);
        return AffineTransform.getRotateInstance(angle -= this.initialRotation, d2.width / 2, d2.height / 2);
    }
}

