/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.Script;
import org.apache.batik.svggen.font.table.ScriptRecord;

public class ScriptList {
    private int scriptCount = 0;
    private ScriptRecord[] scriptRecords;
    private Script[] scripts;

    protected ScriptList(RandomAccessFile raf, int offset) throws IOException {
        int i2;
        raf.seek(offset);
        this.scriptCount = raf.readUnsignedShort();
        this.scriptRecords = new ScriptRecord[this.scriptCount];
        this.scripts = new Script[this.scriptCount];
        for (i2 = 0; i2 < this.scriptCount; ++i2) {
            this.scriptRecords[i2] = new ScriptRecord(raf);
        }
        for (i2 = 0; i2 < this.scriptCount; ++i2) {
            this.scripts[i2] = new Script(raf, offset + this.scriptRecords[i2].getOffset());
        }
    }

    public int getScriptCount() {
        return this.scriptCount;
    }

    public ScriptRecord getScriptRecord(int i2) {
        return this.scriptRecords[i2];
    }

    public Script findScript(String tag) {
        if (tag.length() != 4) {
            return null;
        }
        int tagVal = tag.charAt(0) << 24 | tag.charAt(1) << 16 | tag.charAt(2) << 8 | tag.charAt(3);
        for (int i2 = 0; i2 < this.scriptCount; ++i2) {
            if (this.scriptRecords[i2].getTag() != tagVal) continue;
            return this.scripts[i2];
        }
        return null;
    }
}

