/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.NameRecord;
import org.apache.batik.svggen.font.table.Table;

public class NameTable
implements Table {
    private short formatSelector;
    private short numberOfNameRecords;
    private short stringStorageOffset;
    private NameRecord[] records;

    protected NameTable(DirectoryEntry de, RandomAccessFile raf) throws IOException {
        int i2;
        raf.seek(de.getOffset());
        this.formatSelector = raf.readShort();
        this.numberOfNameRecords = raf.readShort();
        this.stringStorageOffset = raf.readShort();
        this.records = new NameRecord[this.numberOfNameRecords];
        for (i2 = 0; i2 < this.numberOfNameRecords; ++i2) {
            this.records[i2] = new NameRecord(raf);
        }
        for (i2 = 0; i2 < this.numberOfNameRecords; ++i2) {
            this.records[i2].loadString(raf, de.getOffset() + this.stringStorageOffset);
        }
    }

    public String getRecord(short nameId) {
        for (int i2 = 0; i2 < this.numberOfNameRecords; ++i2) {
            if (this.records[i2].getNameId() != nameId) continue;
            return this.records[i2].getRecordString();
        }
        return "";
    }

    @Override
    public int getType() {
        return 1851878757;
    }
}

