/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.PatternPaintContext;

public class PatternPaint
implements Paint {
    private GraphicsNode node;
    private Rectangle2D patternRegion;
    private AffineTransform patternTransform;
    private Filter tile;
    private boolean overflow;
    private PatternPaintContext lastContext;

    public PatternPaint(GraphicsNode node, Rectangle2D patternRegion, boolean overflow, AffineTransform patternTransform) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (patternRegion == null) {
            throw new IllegalArgumentException();
        }
        this.node = node;
        this.patternRegion = patternRegion;
        this.overflow = overflow;
        this.patternTransform = patternTransform;
        CompositeGraphicsNode comp = new CompositeGraphicsNode();
        comp.getChildren().add(node);
        Filter gnr = comp.getGraphicsNodeRable(true);
        Rectangle2D padBounds = (Rectangle2D)patternRegion.clone();
        if (overflow) {
            Rectangle2D nodeBounds = comp.getBounds();
            padBounds.add(nodeBounds);
        }
        this.tile = new PadRable8Bit(gnr, padBounds, PadMode.ZERO_PAD);
    }

    public GraphicsNode getGraphicsNode() {
        return this.node;
    }

    public Rectangle2D getPatternRect() {
        return (Rectangle2D)this.patternRegion.clone();
    }

    public AffineTransform getPatternTransform() {
        return this.patternTransform;
    }

    public boolean getOverflow() {
        return this.overflow;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        if (this.patternTransform != null) {
            xform = new AffineTransform(xform);
            xform.concatenate(this.patternTransform);
        }
        if (this.lastContext != null && this.lastContext.getColorModel().equals(cm)) {
            double[] p2 = new double[6];
            double[] q2 = new double[6];
            xform.getMatrix(p2);
            this.lastContext.getUsr2Dev().getMatrix(q2);
            if (p2[0] == q2[0] && p2[1] == q2[1] && p2[2] == q2[2] && p2[3] == q2[3]) {
                if (p2[4] == q2[4] && p2[5] == q2[5]) {
                    return this.lastContext;
                }
                return new PatternPaintContextWrapper(this.lastContext, (int)(q2[4] - p2[4] + 0.5), (int)(q2[5] - p2[5] + 0.5));
            }
        }
        this.lastContext = new PatternPaintContext(cm, xform, hints, this.tile, this.patternRegion, this.overflow);
        return this.lastContext;
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    static class PatternPaintContextWrapper
    implements PaintContext {
        PatternPaintContext ppc;
        int xShift;
        int yShift;

        PatternPaintContextWrapper(PatternPaintContext ppc, int xShift, int yShift) {
            this.ppc = ppc;
            this.xShift = xShift;
            this.yShift = yShift;
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return this.ppc.getColorModel();
        }

        @Override
        public Raster getRaster(int x2, int y2, int width, int height) {
            return this.ppc.getRaster(x2 + this.xShift, y2 + this.yShift, width, height);
        }
    }
}

