/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.Light;
import org.apache.batik.ext.awt.image.SpotLight;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.BumpMap;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class SpecularLightingRed
extends AbstractTiledRed {
    private double ks;
    private double specularExponent;
    private Light light;
    private BumpMap bumpMap;
    private double scaleX;
    private double scaleY;
    private Rectangle litRegion;
    private boolean linear;

    public SpecularLightingRed(double ks, double specularExponent, Light light, BumpMap bumpMap, Rectangle litRegion, double scaleX, double scaleY, boolean linear) {
        this.ks = ks;
        this.specularExponent = specularExponent;
        this.light = light;
        this.bumpMap = bumpMap;
        this.litRegion = litRegion;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.linear = linear;
        ColorModel cm = linear ? GraphicsUtil.Linear_sRGB_Unpre : GraphicsUtil.sRGB_Unpre;
        int tw = litRegion.width;
        int th = litRegion.height;
        int defSz = AbstractTiledRed.getDefaultTileSize();
        if (tw > defSz) {
            tw = defSz;
        }
        if (th > defSz) {
            th = defSz;
        }
        SampleModel sm = cm.createCompatibleSampleModel(tw, th);
        this.init((CachableRed)null, litRegion, cm, sm, litRegion.x, litRegion.y, null);
    }

    @Override
    public WritableRaster copyData(WritableRaster wr) {
        this.copyToRaster(wr);
        return wr;
    }

    @Override
    public void genRect(WritableRaster wr) {
        double scaleX = this.scaleX;
        double scaleY = this.scaleY;
        double[] lightColor = this.light.getColor(this.linear);
        int w2 = wr.getWidth();
        int h2 = wr.getHeight();
        int minX = wr.getMinX();
        int minY = wr.getMinY();
        DataBufferInt db = (DataBufferInt)wr.getDataBuffer();
        int[] pixels = db.getBankData()[0];
        SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)wr.getSampleModel();
        int offset = db.getOffset() + sppsm.getOffset(minX - wr.getSampleModelTranslateX(), minY - wr.getSampleModelTranslateY());
        int scanStride = sppsm.getScanlineStride();
        int adjust = scanStride - w2;
        int p2 = offset;
        int a2 = 0;
        int i2 = 0;
        int j2 = 0;
        double x2 = scaleX * (double)minX;
        double y2 = scaleY * (double)minY;
        double norm = 0.0;
        int pixel = 0;
        double mult = lightColor[0] > lightColor[1] ? lightColor[0] : lightColor[1];
        mult = mult > lightColor[2] ? mult : lightColor[2];
        double scale = 255.0 / mult;
        pixel = (int)(lightColor[0] * scale + 0.5);
        int tmp = (int)(lightColor[1] * scale + 0.5);
        pixel = pixel << 8 | tmp;
        tmp = (int)(lightColor[2] * scale + 0.5);
        pixel = pixel << 8 | tmp;
        mult *= 255.0 * this.ks;
        double[][][] NA2 = this.bumpMap.getNormalArray(minX, minY, w2, h2);
        if (this.light instanceof SpotLight) {
            SpotLight slight = (SpotLight)this.light;
            double[][] LA2 = new double[w2][4];
            for (i2 = 0; i2 < h2; ++i2) {
                double[][] NR = NA2[i2];
                slight.getLightRow4(x2, y2 + (double)i2 * scaleY, scaleX, w2, NR, LA2);
                for (j2 = 0; j2 < w2; ++j2) {
                    double[] N2 = NR[j2];
                    double[] L2 = LA2[j2];
                    double vs = L2[3];
                    if (vs == 0.0) {
                        a2 = 0;
                    } else {
                        L2[2] = L2[2] + 1.0;
                        norm = L2[0] * L2[0] + L2[1] * L2[1] + L2[2] * L2[2];
                        double dot = N2[0] * L2[0] + N2[1] * L2[1] + N2[2] * L2[2];
                        a2 = (int)(mult * (vs *= Math.pow(dot / (norm = Math.sqrt(norm)), this.specularExponent)) + 0.5);
                        if ((a2 & 0xFFFFFF00) != 0) {
                            a2 = (a2 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                        }
                    }
                    pixels[p2++] = a2 << 24 | pixel;
                }
                p2 += adjust;
            }
        } else if (!this.light.isConstant()) {
            double[][] LA3 = new double[w2][4];
            for (i2 = 0; i2 < h2; ++i2) {
                double[][] NR = NA2[i2];
                this.light.getLightRow(x2, y2 + (double)i2 * scaleY, scaleX, w2, NR, LA3);
                for (j2 = 0; j2 < w2; ++j2) {
                    double[] N3 = NR[j2];
                    double[] L3 = LA3[j2];
                    L3[2] = L3[2] + 1.0;
                    norm = L3[0] * L3[0] + L3[1] * L3[1] + L3[2] * L3[2];
                    norm = Math.sqrt(norm);
                    double dot = N3[0] * L3[0] + N3[1] * L3[1] + N3[2] * L3[2];
                    a2 = (int)(mult * (norm = Math.pow(dot / norm, this.specularExponent)) + 0.5);
                    if ((a2 & 0xFFFFFF00) != 0) {
                        a2 = (a2 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    pixels[p2++] = a2 << 24 | pixel;
                }
                p2 += adjust;
            }
        } else {
            double[] L4 = new double[3];
            this.light.getLight(0.0, 0.0, 0.0, L4);
            L4[2] = L4[2] + 1.0;
            norm = Math.sqrt(L4[0] * L4[0] + L4[1] * L4[1] + L4[2] * L4[2]);
            if (norm > 0.0) {
                L4[0] = L4[0] / norm;
                L4[1] = L4[1] / norm;
                L4[2] = L4[2] / norm;
            }
            for (i2 = 0; i2 < h2; ++i2) {
                double[][] NR = NA2[i2];
                for (j2 = 0; j2 < w2; ++j2) {
                    double[] N4 = NR[j2];
                    a2 = (int)(mult * Math.pow(N4[0] * L4[0] + N4[1] * L4[1] + N4[2] * L4[2], this.specularExponent) + 0.5);
                    if ((a2 & 0xFFFFFF00) != 0) {
                        a2 = (a2 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    pixels[p2++] = a2 << 24 | pixel;
                }
                p2 += adjust;
            }
        }
    }
}

