/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class FloodRed
extends AbstractRed {
    private WritableRaster raster;

    public FloodRed(Rectangle bounds) {
        this(bounds, new Color(0, 0, 0, 0));
    }

    public FloodRed(Rectangle bounds, Paint paint) {
        int th;
        ColorModel cm = GraphicsUtil.sRGB_Unpre;
        int defSz = AbstractTiledRed.getDefaultTileSize();
        int tw = bounds.width;
        if (tw > defSz) {
            tw = defSz;
        }
        if ((th = bounds.height) > defSz) {
            th = defSz;
        }
        SampleModel sm = cm.createCompatibleSampleModel(tw, th);
        this.init((CachableRed)null, bounds, cm, sm, 0, 0, null);
        this.raster = Raster.createWritableRaster(sm, new Point(0, 0));
        BufferedImage offScreen = new BufferedImage(cm, this.raster, cm.isAlphaPremultiplied(), null);
        Graphics2D g2 = GraphicsUtil.createGraphics(offScreen);
        g2.setPaint(paint);
        g2.fillRect(0, 0, bounds.width, bounds.height);
        g2.dispose();
    }

    @Override
    public Raster getTile(int x2, int y2) {
        int tx = this.tileGridXOff + x2 * this.tileWidth;
        int ty = this.tileGridYOff + y2 * this.tileHeight;
        return this.raster.createTranslatedChild(tx, ty);
    }

    @Override
    public WritableRaster copyData(WritableRaster wr) {
        int tx0 = this.getXTile(wr.getMinX());
        int ty0 = this.getYTile(wr.getMinY());
        int tx1 = this.getXTile(wr.getMinX() + wr.getWidth() - 1);
        int ty1 = this.getYTile(wr.getMinY() + wr.getHeight() - 1);
        boolean is_INT_PACK = GraphicsUtil.is_INT_PACK_Data(this.getSampleModel(), false);
        for (int y2 = ty0; y2 <= ty1; ++y2) {
            for (int x2 = tx0; x2 <= tx1; ++x2) {
                Raster r2 = this.getTile(x2, y2);
                if (is_INT_PACK) {
                    GraphicsUtil.copyData_INT_PACK(r2, wr);
                    continue;
                }
                GraphicsUtil.copyData_FALLBACK(r2, wr);
            }
        }
        return wr;
    }
}

