/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import java.awt.Color;
import org.apache.batik.ext.awt.image.AbstractLight;

public class SpotLight
extends AbstractLight {
    private double lightX;
    private double lightY;
    private double lightZ;
    private double pointAtX;
    private double pointAtY;
    private double pointAtZ;
    private double specularExponent;
    private double limitingConeAngle;
    private double limitingCos;
    private final double[] S = new double[3];

    public double getLightX() {
        return this.lightX;
    }

    public double getLightY() {
        return this.lightY;
    }

    public double getLightZ() {
        return this.lightZ;
    }

    public double getPointAtX() {
        return this.pointAtX;
    }

    public double getPointAtY() {
        return this.pointAtY;
    }

    public double getPointAtZ() {
        return this.pointAtZ;
    }

    public double getSpecularExponent() {
        return this.specularExponent;
    }

    public double getLimitingConeAngle() {
        return this.limitingConeAngle;
    }

    public SpotLight(double lightX, double lightY, double lightZ, double pointAtX, double pointAtY, double pointAtZ, double specularExponent, double limitingConeAngle, Color lightColor) {
        super(lightColor);
        this.lightX = lightX;
        this.lightY = lightY;
        this.lightZ = lightZ;
        this.pointAtX = pointAtX;
        this.pointAtY = pointAtY;
        this.pointAtZ = pointAtZ;
        this.specularExponent = specularExponent;
        this.limitingConeAngle = limitingConeAngle;
        this.limitingCos = Math.cos(Math.toRadians(limitingConeAngle));
        this.S[0] = pointAtX - lightX;
        this.S[1] = pointAtY - lightY;
        this.S[2] = pointAtZ - lightZ;
        double invNorm = 1.0 / Math.sqrt(this.S[0] * this.S[0] + this.S[1] * this.S[1] + this.S[2] * this.S[2]);
        this.S[0] = this.S[0] * invNorm;
        this.S[1] = this.S[1] * invNorm;
        this.S[2] = this.S[2] * invNorm;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    public final double getLightBase(double x2, double y2, double z2, double[] L2) {
        double L0 = this.lightX - x2;
        double L1 = this.lightY - y2;
        double L22 = this.lightZ - z2;
        double invNorm = 1.0 / Math.sqrt(L0 * L0 + L1 * L1 + L22 * L22);
        double LS = -((L0 *= invNorm) * this.S[0] + (L1 *= invNorm) * this.S[1] + (L22 *= invNorm) * this.S[2]);
        L2[0] = L0;
        L2[1] = L1;
        L2[2] = L22;
        if (LS <= this.limitingCos) {
            return 0.0;
        }
        double Iatt = this.limitingCos / LS;
        Iatt *= Iatt;
        Iatt *= Iatt;
        Iatt *= Iatt;
        Iatt *= Iatt;
        Iatt *= Iatt;
        Iatt *= Iatt;
        Iatt = 1.0 - Iatt;
        return Iatt * Math.pow(LS, this.specularExponent);
    }

    @Override
    public final void getLight(double x2, double y2, double z2, double[] L2) {
        double s2 = this.getLightBase(x2, y2, z2, L2);
        L2[0] = L2[0] * s2;
        L2[1] = L2[1] * s2;
        L2[2] = L2[2] * s2;
    }

    public final void getLight4(double x2, double y2, double z2, double[] L2) {
        L2[3] = this.getLightBase(x2, y2, z2, L2);
    }

    public double[][] getLightRow4(double x2, double y2, double dx, int width, double[][] z2, double[][] lightRow) {
        double[][] ret = lightRow;
        if (ret == null) {
            ret = new double[width][4];
        }
        for (int i2 = 0; i2 < width; ++i2) {
            this.getLight4(x2, y2, z2[i2][3], ret[i2]);
            x2 += dx;
        }
        return ret;
    }
}

