/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import java.awt.Color;
import org.apache.batik.ext.awt.image.AbstractLight;

public class PointLight
extends AbstractLight {
    private double lightX;
    private double lightY;
    private double lightZ;

    public double getLightX() {
        return this.lightX;
    }

    public double getLightY() {
        return this.lightY;
    }

    public double getLightZ() {
        return this.lightZ;
    }

    public PointLight(double lightX, double lightY, double lightZ, Color lightColor) {
        super(lightColor);
        this.lightX = lightX;
        this.lightY = lightY;
        this.lightZ = lightZ;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public final void getLight(double x2, double y2, double z2, double[] L2) {
        double L0 = this.lightX - x2;
        double L1 = this.lightY - y2;
        double L22 = this.lightZ - z2;
        double norm = Math.sqrt(L0 * L0 + L1 * L1 + L22 * L22);
        if (norm > 0.0) {
            double invNorm = 1.0 / norm;
            L0 *= invNorm;
            L1 *= invNorm;
            L22 *= invNorm;
        }
        L2[0] = L0;
        L2[1] = L1;
        L2[2] = L22;
    }
}

