/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import org.apache.batik.ext.awt.image.TransferFunction;

public class DiscreteTransfer
implements TransferFunction {
    public byte[] lutData;
    public int[] tableValues;
    private int n;

    public DiscreteTransfer(int[] tableValues) {
        this.tableValues = tableValues;
        this.n = tableValues.length;
    }

    private void buildLutData() {
        this.lutData = new byte[256];
        for (int j2 = 0; j2 <= 255; ++j2) {
            int i2 = (int)Math.floor((float)(j2 * this.n) / 255.0f);
            if (i2 == this.n) {
                i2 = this.n - 1;
            }
            this.lutData[j2] = (byte)(this.tableValues[i2] & 0xFF);
        }
    }

    @Override
    public byte[] getLookupTable() {
        this.buildLutData();
        return this.lutData;
    }
}

