/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.MultiResGraphicsNode;
import org.apache.batik.bridge.SVGImageElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.Viewport;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ImageNode;
import org.apache.batik.parser.UnitProcessor;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SVGMultiImageElementBridge
extends SVGImageElementBridge {
    @Override
    public String getNamespaceURI() {
        return "http://www.w3.org/2000/svg";
    }

    @Override
    public String getLocalName() {
        return "multiImage";
    }

    @Override
    public Bridge getInstance() {
        return new SVGMultiImageElementBridge();
    }

    @Override
    public GraphicsNode createGraphicsNode(BridgeContext ctx, Element e2) {
        if (!SVGUtilities.matchUserAgent(e2, ctx.getUserAgent())) {
            return null;
        }
        ImageNode imgNode = (ImageNode)this.instantiateGraphicsNode();
        if (imgNode == null) {
            return null;
        }
        this.associateSVGContext(ctx, e2, imgNode);
        Rectangle2D b2 = SVGMultiImageElementBridge.getImageBounds(ctx, e2);
        AffineTransform at = null;
        String s2 = e2.getAttribute("transform");
        at = s2.length() != 0 ? SVGUtilities.convertTransform(e2, "transform", s2, ctx) : new AffineTransform();
        at.translate(b2.getX(), b2.getY());
        imgNode.setTransform(at);
        imgNode.setVisible(CSSUtilities.convertVisibility(e2));
        Rectangle2D.Double clip = new Rectangle2D.Double(0.0, 0.0, b2.getWidth(), b2.getHeight());
        Filter filter = imgNode.getGraphicsNodeRable(true);
        imgNode.setClip(new ClipRable8Bit(filter, clip));
        Rectangle2D r2 = CSSUtilities.convertEnableBackground(e2);
        if (r2 != null) {
            imgNode.setBackgroundEnable(r2);
        }
        ctx.openViewport(e2, new MultiImageElementViewport((float)b2.getWidth(), (float)b2.getHeight()));
        LinkedList elems = new LinkedList();
        LinkedList minDim = new LinkedList();
        LinkedList maxDim = new LinkedList();
        for (Node n2 = e2.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            if (n2.getNodeType() != 1) continue;
            Element se = (Element)n2;
            if (!this.getNamespaceURI().equals(se.getNamespaceURI())) continue;
            if (se.getLocalName().equals("subImage")) {
                this.addInfo(se, elems, minDim, maxDim, b2);
            }
            if (!se.getLocalName().equals("subImageRef")) continue;
            this.addRefInfo(se, elems, minDim, maxDim, b2);
        }
        Dimension[] mindary = new Dimension[elems.size()];
        Dimension[] maxdary = new Dimension[elems.size()];
        Element[] elemary = new Element[elems.size()];
        Iterator mindi = minDim.iterator();
        Iterator maxdi = maxDim.iterator();
        Iterator ei = elems.iterator();
        int n3 = 0;
        while (mindi.hasNext()) {
            int i2;
            Dimension minD = (Dimension)mindi.next();
            Dimension maxD = (Dimension)maxdi.next();
            if (minD != null) {
                for (i2 = 0; i2 < n3 && (mindary[i2] == null || minD.width >= mindary[i2].width); ++i2) {
                }
            }
            for (int j2 = n3; j2 > i2; --j2) {
                elemary[j2] = elemary[j2 - 1];
                mindary[j2] = mindary[j2 - 1];
                maxdary[j2] = maxdary[j2 - 1];
            }
            elemary[i2] = (Element)ei.next();
            mindary[i2] = minD;
            maxdary[i2] = maxD;
            ++n3;
        }
        MultiResGraphicsNode node = new MultiResGraphicsNode(e2, clip, elemary, mindary, maxdary, ctx);
        imgNode.setImage(node);
        return imgNode;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public void buildGraphicsNode(BridgeContext ctx, Element e2, GraphicsNode node) {
        this.initializeDynamicSupport(ctx, e2, node);
        ctx.closeViewport(e2);
    }

    @Override
    protected void initializeDynamicSupport(BridgeContext ctx, Element e2, GraphicsNode node) {
        if (ctx.isInteractive()) {
            ImageNode imgNode = (ImageNode)node;
            ctx.bind(e2, imgNode.getImage());
        }
    }

    @Override
    public void dispose() {
        this.ctx.removeViewport(this.e);
        super.dispose();
    }

    protected static Rectangle2D getImageBounds(BridgeContext ctx, Element element) {
        UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, element);
        String s2 = element.getAttributeNS(null, "x");
        float x2 = 0.0f;
        if (s2.length() != 0) {
            x2 = UnitProcessor.svgHorizontalCoordinateToUserSpace(s2, "x", uctx);
        }
        s2 = element.getAttributeNS(null, "y");
        float y2 = 0.0f;
        if (s2.length() != 0) {
            y2 = UnitProcessor.svgVerticalCoordinateToUserSpace(s2, "y", uctx);
        }
        if ((s2 = element.getAttributeNS(null, "width")).length() == 0) {
            throw new BridgeException(ctx, element, "attribute.missing", new Object[]{"width"});
        }
        float w2 = UnitProcessor.svgHorizontalLengthToUserSpace(s2, "width", uctx);
        s2 = element.getAttributeNS(null, "height");
        if (s2.length() == 0) {
            throw new BridgeException(ctx, element, "attribute.missing", new Object[]{"height"});
        }
        float h2 = UnitProcessor.svgVerticalLengthToUserSpace(s2, "height", uctx);
        return new Rectangle2D.Float(x2, y2, w2, h2);
    }

    protected void addInfo(Element e2, Collection elems, Collection minDim, Collection maxDim, Rectangle2D bounds) {
        Document doc = e2.getOwnerDocument();
        Element gElem = doc.createElementNS("http://www.w3.org/2000/svg", "g");
        NamedNodeMap attrs = e2.getAttributes();
        int len = attrs.getLength();
        for (int i2 = 0; i2 < len; ++i2) {
            Attr attr = (Attr)attrs.item(i2);
            gElem.setAttributeNS(attr.getNamespaceURI(), attr.getName(), attr.getValue());
        }
        Node n2 = e2.getFirstChild();
        while (n2 != null) {
            gElem.appendChild(n2);
            n2 = e2.getFirstChild();
        }
        e2.appendChild(gElem);
        elems.add(gElem);
        minDim.add(this.getElementMinPixel(e2, bounds));
        maxDim.add(this.getElementMaxPixel(e2, bounds));
    }

    protected void addRefInfo(Element e2, Collection elems, Collection minDim, Collection maxDim, Rectangle2D bounds) {
        String uriStr = XLinkSupport.getXLinkHref(e2);
        if (uriStr.length() == 0) {
            throw new BridgeException(this.ctx, e2, "attribute.missing", new Object[]{"xlink:href"});
        }
        String baseURI = AbstractNode.getBaseURI(e2);
        ParsedURL purl = baseURI == null ? new ParsedURL(uriStr) : new ParsedURL(baseURI, uriStr);
        Document doc = e2.getOwnerDocument();
        Element imgElem = doc.createElementNS("http://www.w3.org/2000/svg", "image");
        imgElem.setAttributeNS("http://www.w3.org/1999/xlink", "href", purl.toString());
        NamedNodeMap attrs = e2.getAttributes();
        int len = attrs.getLength();
        for (int i2 = 0; i2 < len; ++i2) {
            Attr attr = (Attr)attrs.item(i2);
            imgElem.setAttributeNS(attr.getNamespaceURI(), attr.getName(), attr.getValue());
        }
        String s2 = e2.getAttribute("x");
        if (s2.length() == 0) {
            imgElem.setAttribute("x", "0");
        }
        if ((s2 = e2.getAttribute("y")).length() == 0) {
            imgElem.setAttribute("y", "0");
        }
        if ((s2 = e2.getAttribute("width")).length() == 0) {
            imgElem.setAttribute("width", "100%");
        }
        if ((s2 = e2.getAttribute("height")).length() == 0) {
            imgElem.setAttribute("height", "100%");
        }
        e2.appendChild(imgElem);
        elems.add(imgElem);
        minDim.add(this.getElementMinPixel(e2, bounds));
        maxDim.add(this.getElementMaxPixel(e2, bounds));
    }

    protected Dimension getElementMinPixel(Element e2, Rectangle2D bounds) {
        return this.getElementPixelSize(e2, "max-pixel-size", bounds);
    }

    protected Dimension getElementMaxPixel(Element e2, Rectangle2D bounds) {
        return this.getElementPixelSize(e2, "min-pixel-size", bounds);
    }

    protected Dimension getElementPixelSize(Element e2, String attr, Rectangle2D bounds) {
        float xPixSz;
        String s2 = e2.getAttribute(attr);
        if (s2.length() == 0) {
            return null;
        }
        Float[] vals = SVGUtilities.convertSVGNumberOptionalNumber(e2, attr, s2, this.ctx);
        if (vals[0] == null) {
            return null;
        }
        float yPixSz = xPixSz = vals[0].floatValue();
        if (vals[1] != null) {
            yPixSz = vals[1].floatValue();
        }
        return new Dimension((int)(bounds.getWidth() / (double)xPixSz + 0.5), (int)(bounds.getHeight() / (double)yPixSz + 0.5));
    }

    public static class MultiImageElementViewport
    implements Viewport {
        private float width;
        private float height;

        public MultiImageElementViewport(float w2, float h2) {
            this.width = w2;
            this.height = h2;
        }

        @Override
        public float getWidth() {
            return this.width;
        }

        @Override
        public float getHeight() {
            return this.height;
        }
    }
}

